<?php
namespace SabaiApps\Directories\Component\View\Mode;

use SabaiApps\Directories\Component\Entity;

class MasonryMode extends ListMode
{
    protected function _viewModeInfo()
    {
        return [
            'label' => _x('Masonry', 'view mode label', 'directories'),
            'default_settings' => [
                'template' => 'view_entities_masonry',
                'display' => 'summary',
                'masonry_cols' => 'responsive',
                'masonry_cols_responsive' => ['xs' => 2, 'lg' => 3, 'xl' => 4],
            ],
            'assets' => [
                //'js_files' => [
                //    'masonry' => ['masonry.pkgd.min.js', [], 'directories', true, true],
                //    'drts-view-masonry' => ['view-masonry.min.js', ['drts', 'masonry'], 'directories', true],
                //],
                //'images_loaded_js' => true,
                'css_files' => [
                    'driveway' => ['driveway.min.css', null, null, null, true]
                ],
            ],
        ] + parent::_viewModeInfo();
    }

    public function viewModeSettingsForm(Entity\Model\Bundle $bundle, array $settings, array $parents = [])
    {
        return $this->_getGridColumnSettingsForm($settings, $parents);
    }

    public function viewModeNav(Entity\Model\Bundle $bundle, array $settings)
    {
        return [
            [
                [['filters'], []],
                [['filter', 'num'], ['sort', 'add']],
            ], // header
            [
                [[], ['perpages', 'pagination']],
            ], // footer
        ];
    }
}
