<?php
	require_once('vendor/autoload.php');
	include('MailChimp.php');

	add_action( 'wp_ajax_pafe_ajax_form_builder', 'pafe_ajax_form_builder' );
	add_action( 'wp_ajax_nopriv_pafe_ajax_form_builder', 'pafe_ajax_form_builder' );

	function find_element_recursive( $elements, $form_id ) {
		foreach ( $elements as $element ) {
			if ( $form_id === $element['id'] ) {
				return $element;
			}

			if ( ! empty( $element['elements'] ) ) {
				$element = find_element_recursive( $element['elements'], $form_id );

				if ( $element ) {
					return $element;
				}
			}
		}

		return false;
	}

	function set_val(&$array,$path,$val) {
		for($i=&$array; $key=array_shift($path); $i=&$i[$key]) {
			if(!isset($i[$key])) $i[$key] = array();
		}
		$i = $val;
	}

	function pafe_merge_string(&$string,$string_add) {
		$string = $string . $string_add;
	}

	function pafe_unset_string(&$string) {
		$string = '';
	}

	function pafe_set_string(&$string,$string_set) {
		$string = $string_set;
	}

	function replace_email($content, $fields, $payment_status = 'succeeded', $payment_id = '', $succeeded = 'succeeded', $pending = 'pending', $failed = 'failed' ) {
		$message = $content;

		$message_all_fields = '';

		// $fields_array = array();

		// foreach ($fields as $field) {
		// 	$repeater_id = $field['repeater_id'];
		// 	$repeater_index = $field['repeater_index'];
		// 	$repeater_label = $field['repeater_label'];

		// 	if (!empty($repeater_id)) {
		// 		$repeater_id_array = array_reverse( explode(',', rtrim($repeater_id, ',')) );

		// 		$path = join(",",$repeater_id_array);
		// 		$path = str_replace('|', ',', $path);
		// 		$path = explode(',',$path);

		// 		set_val($fields_array,$path,$field);
		// 	} else {
		// 		$field['repeater'] = false;
		// 		$fields_array[$field['name']] = $field;
		// 	}
		// }

		if (!empty($fields)) {

			// all fields
			foreach ($fields as $field) {

				$repeater_id = $field['repeater_id'];
				$repeater_id_string = '';
				$repeater_id_array = array_reverse( explode(',', rtrim($repeater_id, ',')) );
				foreach ($repeater_id_array as $repeater) {
					$repeater_array = explode('|', $repeater);
					array_pop($repeater_array);
					$repeater_id_string .= join(",",$repeater_array);
				}
				$repeater_index = $field['repeater_index']; 
				$repeater_index_1 = $repeater_index + 1;
				$repeater_label = '<span data-id="' . $repeater_id_string . '"><strong>' . $field['repeater_label'] . ' ' . $repeater_index_1 . ': </strong></span><br>';
				
				if (!empty($repeater_id) && !empty($repeater_label)) {
					if (strpos($message, $repeater_label) !== false) {
						$message_all_fields .= $field['label'] . ': ' . $field['value'] . '<br />';
					} else {
						$message_all_fields .= $repeater_label;
						$message_all_fields .= $field['label'] . ': ' . $field['value'] . '<br />';
					}
					// if ($field['repeater_index'] != ($field['repeater_length'] - 1)) {
					// 	$message .=  '<br />';
					// }
				} else {
					if (strpos($field['name'], 'pafe-end-repeater') === false) {
						$message_all_fields .= $field['label'] . ': ' . $field['value'] . '<br />';
					}
				}

			}

			$message = str_replace( '[all-fields]', $message_all_fields, $message );

			// each field

			$repeater_content = '';
			$repeater_id_one = '';
			foreach ($fields as $field) {
				$search = '[field id="' . $field['name'] . '"]';
				$message = str_replace($search, $field['value'], $message);

				$repeater_id = $field['repeater_id'];
				$repeater_id_string = '';
				$repeater_id_array = array_reverse( explode(',', rtrim($repeater_id, ',')) );
				foreach ($repeater_id_array as $repeater) {
					$repeater_array = explode('|', $repeater);
					array_pop($repeater_array);
					$repeater_id_string .= join(",",$repeater_array);
				}
				$repeater_index = $field['repeater_index']; 
				$repeater_index_1 = $repeater_index + 1;
				$repeater_label = '<span data-id="' . $repeater_id_string . '"><strong>' . $field['repeater_label'] . ' ' . $repeater_index_1 . ': </strong></span><br>';
				
				if (!empty($repeater_id) && !empty($repeater_label)) {
					if (strpos($repeater_content, $repeater_label) !== false) {
						$string_add = $field['label'] . ': ' . $field['value'] . '<br />';
						pafe_merge_string($repeater_content,$string_add);
					} else {
						$string_add = $repeater_label . $field['label'] . ': ' . $field['value'] . '<br />';
						pafe_merge_string($repeater_content,$string_add);
					}
					if (substr_count($field['repeater_id'],'|') == 2) {
						pafe_set_string($repeater_id_one,$field['repeater_id_one']);
					}
				}

				if (empty($repeater_id)) {
					if (!empty($repeater_id_one) && !empty($repeater_content)) {
						$search_repeater = '[repeater id="' . $repeater_id_one . '"]';
						$message = str_replace($search_repeater, $repeater_content, $message);
						pafe_unset_string($repeater_content);
						pafe_unset_string($repeater_id_one);
					}
				}
				
			}
		}

		$message = str_replace( [ "\r\n", "\n", "\r" ], '<br />', $message );

		if ($payment_status == 'succeeded') {
			$message = str_replace( '[payment_status]', $succeeded, $message );
		}

		if ($payment_status == 'pending') {
			$message = str_replace( '[payment_status]', $pending, $message );
		}

		if ($payment_status == 'failed') {
			$message = str_replace( '[payment_status]', $failed, $message );
		}

		if (!empty($payment_id)) {
			$message = str_replace( '[payment_id]', $payment_id, $message );
		}

		return $message;
	}

	function get_field_name_shortcode($content) {
		$field_name = str_replace('[field id="', '', $content);
		$field_name = str_replace('[repeater id="', '', $field_name); // fix alert ]
		$field_name = str_replace('"]', '', $field_name);
		return trim($field_name);
	}

	function pafe_get_field_value($field_name,$fields, $payment_status = 'succeeded', $payment_id = '', $succeeded = 'succeeded', $pending = 'pending', $failed = 'failed' ) {

		$field_name_first = $field_name;

		if (strpos($field_name, '[repeater id') !== false) { // ] [ [ fix alert
			$field_name = str_replace('id="', "id='", $field_name);
			$field_name = str_replace('"]', "']", $field_name);
			$message = $field_name;
			$repeater_content = '';
			$repeater_id_one = '';
			foreach ($fields as $field) {
				$search = '[field id="' . $field['name'] . '"]';
				$message = str_replace($search, $field['value'], $message);

				$repeater_id = $field['repeater_id'];
				$repeater_id_string = '';
				$repeater_id_array = array_reverse( explode(',', rtrim($repeater_id, ',')) );
				foreach ($repeater_id_array as $repeater) {
					$repeater_array = explode('|', $repeater);
					array_pop($repeater_array);
					$repeater_id_string .= join(",",$repeater_array);
				}
				$repeater_index = $field['repeater_index']; 
				$repeater_index_1 = $repeater_index + 1;
				$repeater_label = $field['repeater_label'] . ' ' . $repeater_index_1 . '\n';
				
				if (!empty($repeater_id) && !empty($repeater_label)) {
					if (strpos($repeater_content, $repeater_label) !== false) {
						$string_add = $field['label'] . ': ' . $field['value'] . '\n';
						pafe_merge_string($repeater_content,$string_add);
					} else {
						$string_add = $repeater_label . $field['label'] . ': ' . $field['value'] . '\n';
						pafe_merge_string($repeater_content,$string_add);
					}
					if (substr_count($field['repeater_id'],'|') == 2) {
						pafe_set_string($repeater_id_one,$field['repeater_id_one']);
					}
				}

				if (empty($repeater_id)) {
					if (!empty($repeater_id_one) && !empty($repeater_content)) {
						$search_repeater = "[repeater id='" . $repeater_id_one . "']";
						$message = str_replace($search_repeater, $repeater_content, $message);

						pafe_unset_string($repeater_content);
						pafe_unset_string($repeater_id_one);
					}
				}
			}

			$field_value = $message;
		} else {
			$field_name = get_field_name_shortcode($field_name);
			$field_value = '';
			foreach ($fields as $key_field=>$field) {
				if ($fields[$key_field]['name'] == $field_name) {
					if (!empty($fields[$key_field]['value'])) {
						$field_value = $fields[$key_field]['value'];
					}
				}
			}
		}

		if (strpos($field_name_first, '[payment_status]') !== false || strpos($field_name_first, '[payment_id]') !== false) {
			if ($payment_status == 'succeeded') {
				$field_value = str_replace( '[payment_status]', $succeeded, $field_name_first );
			}

			if ($payment_status == 'pending') {
				$field_value = str_replace( '[payment_status]', $pending, $field_name_first );
			}

			if ($payment_status == 'failed') {
				$field_value = str_replace( '[payment_status]', $failed, $field_name_first );
			}

			if (!empty($payment_id) && strpos($field_name_first, '[payment_id]') !== false) {
				$field_value = str_replace( '[payment_id]', $payment_id, $field_name_first );
			}
		}
		
		return trim($field_value);
	}

	function getIndexColumn($column) {
		$columnArray = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

		$columnFirstWord = strtoupper( substr($column, 0, 1) );
		$columnSecondWord = strtoupper( substr($column, 1, 2) );
		$index = 0;
		  
		if($columnSecondWord == '') {
		  $index = array_search($columnFirstWord, $columnArray);
		} else {
		  $index = (array_search($columnFirstWord, $columnArray) + 1)*26 + array_search($columnSecondWord, $columnArray);
		}

		return $index;
	}

	function acf_get_field_key( $field_name, $post_id ) {
		global $wpdb;
		$acf_fields = $wpdb->get_results( $wpdb->prepare( "SELECT ID,post_parent,post_name FROM $wpdb->posts WHERE post_excerpt=%s AND post_type=%s" , $field_name , 'acf-field' ) );
		// get all fields with that name.
		switch ( count( $acf_fields ) ) {
			case 0: // no such field
				return false;
			case 1: // just one result. 
				return $acf_fields[0]->post_name;
		}
		// result is ambiguous
		// get IDs of all field groups for this post
		$field_groups_ids = array();
		$field_groups = acf_get_field_groups( array(
			'post_id' => $post_id,
		) );
		foreach ( $field_groups as $field_group )
			$field_groups_ids[] = $field_group['ID'];
		
		// Check if field is part of one of the field groups
		// Return the first one.
		foreach ( $acf_fields as $acf_field ) {
			if ( in_array($acf_field->post_parent,$field_groups_ids) )
				return $acf_field->post_name;
		}
		return false;
	}

	function pafe_ajax_form_builder() {

		global $wpdb;
			if ( !empty($_POST['post_id']) && !empty($_POST['form_id']) && !empty($_POST['fields']) ) {
				$post_id = $_POST['post_id'];
				$form_id = $_POST['form_id'];
				$fields = stripslashes($_POST['fields']);
				$fields = json_decode($fields, true);
				$fields = array_unique($fields, SORT_REGULAR);

				$failed = false;

				$post_url = '';

				$message = '';
				$meta_content = '';

				$upload = wp_upload_dir();
				$upload_dir = $upload['basedir'];
				$upload_dir = $upload_dir . '/piotnet-addons-for-elementor';

				$attachment = array();

				if( !empty($_FILES) ) {
					foreach ($_FILES as $key=>$file) {
						
						for ($i=0; $i < count($file['name']); $i++) { 
							$file_extension = pathinfo( $file['name'][$i], PATHINFO_EXTENSION );
							$filename_goc = str_replace( '.' . $file_extension, '', $file['name'][$i]);
							$filename = $filename_goc . '-' . uniqid() . '.' . $file_extension;
							$filename = wp_unique_filename( $upload_dir, $filename );
							$new_file = trailingslashit( $upload_dir ) . $filename;

							if ( is_dir( $upload_dir ) && is_writable( $upload_dir ) ) {
								$move_new_file = @ move_uploaded_file( $file['tmp_name'][$i], $new_file );
								if ( false !== $move_new_file ) {
									// Set correct file permissions.
									$perms = 0644;
									@ chmod( $new_file, $perms );

									$file_url = $upload['baseurl'] . '/piotnet-addons-for-elementor/' . $filename;

									foreach ($fields as $key_field=>$field) {
										if ($key == $field['name']) {
											if ($fields[$key_field]['attach-files'] == 1) {
												$attachment[] = WP_CONTENT_DIR . '/uploads/piotnet-addons-for-elementor/' . $filename;
											} else {
												$fields[$key_field]['value'] = $fields[$key_field]['value'] . $file_url;
												if ( $i != (count($file['name']) - 1) ) {
													$fields[$key_field]['value'] = $fields[$key_field]['value'] . ' , ';
												}
											}
										}
									}
								}
							}
						}						
					} 
				}

				foreach ($fields as $key_field=>$field) {
					if (isset($fields[$key_field]['attach-files'])) {
						if ($fields[$key_field]['attach-files'] == 1) {
							if (isset($fields[$key_field])) {
								unset($fields[$key_field]);
							}
						}
					}
				}

				$elementor = \Elementor\Plugin::$instance;

				if ( version_compare( ELEMENTOR_VERSION, '2.6.0', '>=' ) ) {
					$meta = $elementor->documents->get( $post_id )->get_elements_data();
				} else {
					$meta = $elementor->db->get_plain_editor( $post_id );
				}

				$form = find_element_recursive( $meta, $form_id );

				$widget = $elementor->elements_manager->create_element_instance( $form );
				$form['settings'] = $widget->get_active_settings();

				$body = array(); // Webhook

				$meta_data = array(); // Webhook

				$fields_data = array(); // Webhook

				if ( ! empty( $form['settings']['form_metadata'] ) ) {
					$form_metadata = $form['settings']['form_metadata'];
					$meta_content .= '<br>---<br><br>';
					foreach ($form_metadata as $meta) {
						if ($meta == 'date') {
							$meta_content .= __('Date','pafe') . ': ' . date_i18n( get_option( 'date_format' ) ) . '<br>';
							$meta_data['date']['title'] = __('Date','pafe');
							$meta_data['date']['value'] = date_i18n( get_option( 'date_format' ) );
						}
						if ($meta == 'time') {
							$meta_content .= __('Time','pafe') . ': ' . date_i18n( get_option( 'time_format' ) ) . '<br>';
							$meta_data['time']['title'] = __('Time','pafe');
							$meta_data['time']['value'] = date_i18n( get_option( 'time_format' ) );
						}
						if ($meta == 'page_url') {
							$meta_content .= __('Page URL','pafe') . ': ' . $_POST['referrer'] . '<br>';
							$meta_data['page_url']['title'] = __('Page URL','pafe');
							$meta_data['page_url']['value'] = $_POST['referrer'];
						}
						if ($meta == 'user_agent') {
							$meta_content .= __('User Agent','pafe') . ': ' . $_SERVER['HTTP_USER_AGENT'] . '<br>';
							$meta_data['user_agent']['title'] = __('User Agent','pafe');
							$meta_data['user_agent']['value'] = $_SERVER['HTTP_USER_AGENT'];
						}
						if ($meta == 'remote_ip') {
							$meta_content .= __('Remote IP','pafe') . ': ' . $_POST['remote_ip'] . '<br>';
							$meta_data['remote_ip']['title'] = __('Remote IP','pafe');
							$meta_data['remote_ip']['value'] = $_POST['remote_ip'];
						}
					}
				}

				if( in_array('webhook', $form['settings']['submit_actions']) && !empty($form['settings']['webhooks_advanced_data']) ) {
					if ($form['settings']['webhooks_advanced_data'] == 'yes') {
						$body['meta'] = $meta_data;
					}
				}

				$status = '';

				$payment_status = 'succeeded';
				$payment_id = '';

				if (!empty($_POST['stripeToken'])) {

					\Stripe\Stripe::setApiKey(get_option('piotnet-addons-for-elementor-pro-stripe-secret-key'));

					$token = $_POST['stripeToken'];

					$customer_array = array( 
						"source" => $token,
					);

					
					$currency = strtolower($form['settings']['pafe_stripe_currency']);

					if (!empty($_POST['description'])) {
						$customer_array['description'] = esc_sql( $_POST['description'] );
					}

					// Create Customer In Stripe
					$customer = \Stripe\Customer::create($customer_array);

					$fields_metadata = array();

					foreach ($fields as $field) {
						$fields_metadata[$field['name']] = $field['value'];
					}

					if (empty($form['settings']['pafe_stripe_subscriptions'])) {
						$amount = floatval($_POST['amount']) * 100;

						if (!empty($amount)) {
							// Charge Customer
							$charge = \Stripe\Charge::create(array(
								"amount" => $amount,
								"currency" => $currency,
								"description" => $form_id,
								"customer" => $customer->id,
								"metadata" => $fields_metadata,
							));

							$payment_status = $charge->status;
							$payment_id = $charge->id;
						}
					} else {
						$subscriptions = $form['settings']['pafe_stripe_subscriptions_list'];
						$product_name = $form['settings']['pafe_stripe_subscriptions_product_name'];

						if (!empty($subscriptions)) {
							if (!empty($product_name)) {
								if (count($subscriptions) == 1 && empty($form['settings']['pafe_stripe_subscriptions_field_enable'])) {
									$interval = $subscriptions[0]['pafe_stripe_subscriptions_interval'];
									$interval_count = $subscriptions[0]['pafe_stripe_subscriptions_interval_count'];
									if (!empty($interval) && !empty($interval_count)) {
										if (!empty($subscriptions[0]['pafe_stripe_subscriptions_amount_field_enable'])) {
											if (!empty($subscriptions[0]['pafe_stripe_subscriptions_amount_field'])) {
												$amount = floatval( pafe_get_field_value($subscriptions[0]['pafe_stripe_subscriptions_amount_field'], $fields) ) * 100;
											}
										} else {
											if (!empty($subscriptions[0]['pafe_stripe_subscriptions_amount'])) {
												$amount = floatval( $subscriptions[0]['pafe_stripe_subscriptions_amount'] ) * 100;
											}
										}
									}
								} else {
									if (!empty($form['settings']['pafe_stripe_subscriptions_field_enable'])) {
										$plan_value = pafe_get_field_value($form['settings']['pafe_stripe_subscriptions_field'], $fields);
										if (!empty($plan_value)) {
											foreach ($subscriptions as $subscription_item) {
												if (!empty($subscription_item['pafe_stripe_subscriptions_field_enable_repeater']) && !empty($subscription_item['pafe_stripe_subscriptions_field_value'])) {
													if ($plan_value == $subscription_item['pafe_stripe_subscriptions_field_value']) {
														$interval = $subscription_item['pafe_stripe_subscriptions_interval'];
														$interval_count = $subscription_item['pafe_stripe_subscriptions_interval_count'];
														if (!empty($interval) && !empty($interval_count)) {
															if (!empty($subscription_item['pafe_stripe_subscriptions_amount_field_enable'])) {
																if (!empty($subscription_item['pafe_stripe_subscriptions_amount_field'])) {
																	$amount = floatval( pafe_get_field_value($subscription_item['pafe_stripe_subscriptions_amount_field'], $fields) ) * 100;
																}
															} else {
																if (!empty($subscription_item['pafe_stripe_subscriptions_amount'])) {
																	$amount = floatval( $subscription_item['pafe_stripe_subscriptions_amount'] ) * 100;
																}
															}
														}
													}
												}
											}
										}
									}
								}
								
								if (!empty($amount) && !empty($interval) && !empty($interval_count)) {
									$plan = \Stripe\Plan::create([
										"amount" => $amount,
										"currency" => $currency,
										"interval" => $interval,
										"interval_count" => $interval_count,
										"metadata" => $fields_metadata,
										"product" => [
											"name" => $product_name,
											"metadata" => $fields_metadata,
										],
									]);

									$subscription = \Stripe\Subscription::create([
										"customer" => $customer->id,
										"metadata" => $fields_metadata,
										"items" => [
											[
												"plan" => $plan->id,
											],
										]
									]);

									$payment_status = $subscription->status;
									$payment_id = $subscription->id;
								}
							}
						}
					}

					// Webhook
					$fields_data['payment_id'] = $payment_id;
					$fields_data['payment_status'] = $payment_status;
				}

				// Webhook

				if( in_array('webhook', $form['settings']['submit_actions']) && !empty($form['settings']['webhooks'])) {
					foreach ($fields as $field) {
						$field_name = $field['name'];
						$fields_data[$field_name]['id'] = $field['name'];
						$fields_data[$field_name]['title'] = $field['label'];
						$fields_data[$field_name]['value'] = $field['value'];
					}

					$body['fields'] = $fields_data;

					$body['form']['id'] = $form['settings']['form_id'];

					$args = [
						'body' => $body,
					];

					$response = wp_remote_post( replace_email($form['settings']['webhooks'], $fields), $args );
				}

				// Google Sheets

				if (!empty($form['settings']['pafe_form_google_sheets_connector_enable']) && !empty($form['settings']['pafe_form_google_sheets_connector_field_list']) && !empty($form['settings']['pafe_form_google_sheets_connector_id'])) {
					$row = '';
					$fieldList = $form['settings']['pafe_form_google_sheets_connector_field_list'];
					$columnArray = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
					$fieldColumns = array();

					for ($i = 0; $i < count($fieldList); $i++) {
		            	$fieldColumns[] = getIndexColumn($fieldList[$i]['pafe_form_google_sheets_connector_field_column']); 
			        }

					for ($z = 0; $z < (max($fieldColumns) + 1); $z++) {
						$value = '';

					 	for ($i = 0; $i < count($fieldList); $i++) {
				            $fieldID = $fieldList[$i]['pafe_form_google_sheets_connector_field_id'];
				            $fieldColumn = $fieldList[$i]['pafe_form_google_sheets_connector_field_column'];

			            	if ($z == getIndexColumn($fieldColumn)) {
			            		for($j=0; $j < count($fieldList); $j++) {
			            			// if ($fields[$j]['name'] == $fieldID) {
			            			// 	$value = $fields[$j]['value'];
			            			// }
			            			$value = pafe_get_field_value($fieldID,$fields,$payment_status, $payment_id);
				        		}
			            	}  
				        }

				        $row .= '"' . $value . '",';
			        }
				   
				    // Submission
				    $row = rtrim($row, ',');
				    // Config
				    $gs_sid = $form['settings']['pafe_form_google_sheets_connector_id']; // Enter your Google Sheet ID here
				    $gs_clid = get_option('piotnet-addons-for-elementor-pro-google-sheets-client-id'); // Enter your API Client ID here
				    $gs_clis = get_option('piotnet-addons-for-elementor-pro-google-sheets-client-secret'); // Enter your API Client Secret here
				    $gs_rtok = get_option('piotnet-addons-for-elementor-pro-google-sheets-refresh-token'); // Enter your OAuth Refresh Token here
				    $gs_atok = false;
				    $gs_url = 'https://sheets.googleapis.com/v4/spreadsheets/' . $gs_sid . '/values/A1:append?includeValuesInResponse=false&insertDataOption=INSERT_ROWS&responseDateTimeRenderOption=SERIAL_NUMBER&responseValueRenderOption=FORMATTED_VALUE&valueInputOption=USER_ENTERED';
				    $gs_body = '{"majorDimension":"ROWS", "values":[[' . $row . ']]}';

				    // HTTP Request Token Refresh

				    $google_sheets_request = [
						'body' => [],
						'headers' => array(
					        'Content-type' => 'application/x-www-form-urlencoded',
					    ),
					];

					$google_sheets = wp_remote_post( 'https://www.googleapis.com/oauth2/v4/token?client_id=' . $gs_clid . '&client_secret=' . $gs_clis . '&refresh_token=' . $gs_rtok . '&grant_type=refresh_token', $google_sheets_request );
					$google_sheets = json_decode( wp_remote_retrieve_body( $google_sheets) );

					if (!empty($google_sheets->access_token)) {
						$gs_atok = $google_sheets->access_token;
						$google_sheets_request_send = [
							'body' => $gs_body,
							'headers' => array(
								'Content-length' => strlen( $gs_body ),
						        'Content-type' => 'application/json',
						        'Authorization' => 'OAuth ' . $gs_atok,
						    ),
						];
						$google_sheets_send = wp_remote_post( $gs_url, $google_sheets_request_send );
					}
				}

				// Recaptcha

				$recaptcha_check = 1;

				if (!empty($_POST['recaptcha'])) {

					// Build POST request:
				    $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
				    $recaptcha_secret = get_option('piotnet-addons-for-elementor-pro-recaptcha-secret-key');
				    $recaptcha_response = $_POST['recaptcha'];

					$recaptcha_request = [
						'body' => [
							'secret' => $recaptcha_secret,
							'response' => $recaptcha_response,
							'remoteip' => $_POST['remote_ip'],
						],
					];

					$recaptcha = wp_remote_post( 'https://www.google.com/recaptcha/api/siteverify', $recaptcha_request );

					$recaptcha = json_decode( wp_remote_retrieve_body( $recaptcha ) );

				    // Take action based on the score returned:
				    if ($recaptcha->score >= 0.5) {
				        // Verified - send email
				    } else {
				        // Not verified - show form error
				        $recaptcha_check = 0;
				    }
				}

				// Honeypot

				foreach ($fields as $key_field=>$field) {
					if ($fields[$key_field]['name'] == 'honeypot') {
						if (!empty($fields[$key_field]['value'])) {
							$recaptcha_check = 0;
						}
					}
				}

				if ($recaptcha_check == 1) {

					// Add to Form Database

					$my_post = array(
						'post_title'    => wp_strip_all_tags( 'Piotnet Addons Form Database ' . $form_id ),
						'post_status'   => 'publish',
						'post_type'		=> 'pafe-form-database',
					);

					$form_database_post_id = wp_insert_post( $my_post );

					if (!empty($form_database_post_id)) {

						$my_post_update = array(
							'ID'           => $form_database_post_id,
							'post_title'   => '#' . $form_database_post_id,
						);
						wp_update_post( $my_post_update );

						update_post_meta( $form_database_post_id, 'form_id', $form['settings']['form_id'] );
						update_post_meta( $form_database_post_id, 'form_id_elementor', $form_id );
						update_post_meta( $form_database_post_id, 'post_id', $post_id );

						foreach ($fields as $field) {
							update_post_meta( $form_database_post_id, $field['name'], $field['value'] );
						}

						if (!empty($charge)) {
							update_post_meta( $form_database_post_id, 'payment_id', $charge->id );
							update_post_meta( $form_database_post_id, 'payment_customer_id', $charge->customer );
							update_post_meta( $form_database_post_id, 'payment_description', $charge->description );
							update_post_meta( $form_database_post_id, 'payment_amount', $charge->amount );
							update_post_meta( $form_database_post_id, 'payment_currency', $charge->currency );
							update_post_meta( $form_database_post_id, 'payment_status', $charge->status );
						}

					}

					// End add to Form Database

					// repeater

					$fields_array = array();

					foreach ($fields as $field) {
						$repeater_id = $field['repeater_id'];
						$repeater_index = $field['repeater_index'];
						$repeater_label = $field['repeater_label'];

						if (!empty($repeater_id)) {
							$repeater_id_array = array_reverse( explode(',', rtrim($repeater_id, ',')) );
							$repeater_id_array_new = array();

							if (strpos(rtrim($repeater_id, ','), ',') !== false) {
								for ($i=0; $i < count($repeater_id_array); $i++) { 
									if ($i != count($repeater_id_array) - 1) {
										$repeater_id_array_new[] = str_replace('|' . $field['name'], '', $repeater_id_array[$i]);
									} else {
										$repeater_id_array_new[] = $repeater_id_array[$i];
									}
								}
							} else {
								$repeater_id_array_new = $repeater_id_array;
							}

							$path = join(",",$repeater_id_array_new);
							$path = str_replace('|', ',', $path);
							$path = explode(',',$path);

							set_val($fields_array,$path,$field['value']);
						} else {
							$field['repeater'] = false;
							$fields_array[$field['name']] = $field;
						}
					}

					array_walk($fields_array, function (& $item) {
						foreach ($item as $key => $value) {
							if (strpos($key, 'index') === 0) {
								$key_new = str_replace('index', '', $key);
								$item[$key_new] = $item[$key];
								unset($item[$key]);
							}
						}
					});

					// Submit Post

					if( in_array('submit_post', $form['settings']['submit_actions']) ) {
						$sp_post_type = $form['settings']['submit_post_type'];
						$sp_post_taxonomy = $form['settings']['submit_post_taxonomy'];
						$sp_terms = $form['settings']['submit_post_terms_list'];
						$sp_term_slug = $form['settings']['submit_post_term_slug'];
						$sp_status = $form['settings']['submit_post_status'];
						$sp_title = get_field_name_shortcode( $form['settings']['submit_post_title'] );
						$sp_content = get_field_name_shortcode( $form['settings']['submit_post_content'] );
						$sp_term = get_field_name_shortcode( $form['settings']['submit_post_term'] );
						$sp_featured_image = get_field_name_shortcode( $form['settings']['submit_post_featured_image'] );
						$sp_custom_fields = $form['settings']['submit_post_custom_fields_list'];

						$post_title = $post_content = $post_tags = $post_term = $post_featured_image = '';

						foreach ($fields as $field) {
							if ($field['name'] == $sp_title) {
								$post_title = $field['value'];
							}
							if ($field['name'] == $sp_content) {
								$post_content = $field['value'];
							}
							if ($field['name'] == $sp_term) {
								$post_term = $field['value'];
							}
							if ($field['name'] == $sp_featured_image) {
								$post_featured_image = $field['value'];
							}
						}

						if ( !empty($post_title) ) {
							$submit_post = array(
								'post_type'		=> $sp_post_type,
								'post_status'   => $sp_status,
								'post_title'    => wp_strip_all_tags( $post_title ),
								'post_content'  => $post_content,
							);

							if (empty($_POST['edit'])) {
								$submit_post_id = wp_insert_post( $submit_post );
							} else {
								$submit_post_id = intval($_POST['edit']);

								$submit_post = array(
									'ID'            => $submit_post_id,
									'post_type'		=> $sp_post_type,
									'post_title'    => wp_strip_all_tags( $post_title ),
									'post_content'  => $post_content,
								);

								wp_update_post( $submit_post );
							}

							if (!empty($post_featured_image)) {
								$post_featured_image_array = explode(',', $post_featured_image);
								$post_featured_image_id = attachment_url_to_postid( $post_featured_image_array[0] );
								if (!empty($post_featured_image_id)) {
									set_post_thumbnail( $submit_post_id, intval( $post_featured_image_id ) );
								} else {
									// Gives us access to the download_url() and wp_handle_sideload() functions
									require_once( ABSPATH . 'wp-admin/includes/file.php' );

									// URL to the WordPress logo
									$url = $post_featured_image_array[0];
									$timeout_seconds = 15;

									// Download file to temp dir
									$temp_file = download_url( $url, $timeout_seconds );

									if ( !is_wp_error( $temp_file ) ) {

										// Array based on $_FILE as seen in PHP file uploads
										$file = array(
											'name'     => basename($url), // ex: wp-header-logo.png
											'type'     => 'image/png',
											'tmp_name' => $temp_file,
											'error'    => 0,
											'size'     => filesize($temp_file),
										);

										$overrides = array(
											// Tells WordPress to not look for the POST form
											// fields that would normally be present as
											// we downloaded the file from a remote server, so there
											// will be no form fields
											// Default is true
											'test_form' => false,

											// Setting this to false lets WordPress allow empty files, not recommended
											// Default is true
											'test_size' => true,
										);

										// Move the temporary file into the uploads directory
										$results = media_handle_sideload( $file, $submit_post_id );

										if ( !is_wp_error($results) ) {
											$post_featured_image_id = $results;
											if (!empty($post_featured_image_id)) {
												set_post_thumbnail( $submit_post_id, intval( $post_featured_image_id ) );
											}
										}

									}
								}
							}

							if (!empty($sp_post_taxonomy) && empty($sp_terms)) {
								$sp_post_taxonomy = explode('-', $sp_post_taxonomy);
								$sp_post_taxonomy = $sp_post_taxonomy[0];
								if (!empty($sp_term_slug)) {
									wp_set_object_terms( $submit_post_id, $sp_term_slug, $sp_post_taxonomy );
								}
								if (!empty($sp_term)) {
									wp_set_object_terms( $submit_post_id, $post_term, $sp_post_taxonomy );
								}
							}

							if (!empty($sp_terms)) {
								foreach ($sp_terms as $sp_terms_item) {
									$sp_post_taxonomy = explode('|', $sp_terms_item['submit_post_taxonomy']);
									$sp_post_taxonomy = $sp_post_taxonomy[0];
									$sp_term_slug = $sp_terms_item['submit_post_terms_slug'];
									$sp_term = get_field_name_shortcode( $sp_terms_item['submit_post_terms_field_id'] );
									$post_term = '';
									foreach ($fields as $field) {
										if ($field['name'] == $sp_term) {
											if (strpos($field['value'], ',') !== false) {
												$post_term = explode(',', $field['value']);
											} else {
												$post_term = $field['value'];
											}
										}
									}
									// if (!empty($sp_term_slug)) {
									// 	wp_set_object_terms( $submit_post_id, $sp_term_slug, $sp_post_taxonomy );
									// }
									if (!empty($post_term)) {
										wp_set_object_terms( $submit_post_id, $post_term, $sp_post_taxonomy );
									}
								}
							}

							foreach ($sp_custom_fields as $sp_custom_field) {
								if ( !empty( $sp_custom_field['submit_post_custom_field'] ) ) {
									$custom_field_value = '';
									$meta_type = $sp_custom_field['submit_post_custom_field_type'];

									foreach ($fields as $field) {
										if ($field['name'] == get_field_name_shortcode( $sp_custom_field['submit_post_custom_field_id'] )) {
											$custom_field_value = $field['value'];
										}
									}

									if ($meta_type == 'repeater') {
										foreach ($fields_array as $field_key => $value) {
											if ($field_key == get_field_name_shortcode( $sp_custom_field['submit_post_custom_field_id'] )) {
												$custom_field_value = $value;
											}
										}

										if (!empty($custom_field_value)) {

											array_walk($custom_field_value, function (& $item) {
												foreach ($item as $key => $value) {
													$field_object = get_field_object(acf_get_field_key( $key, $submit_post_id ));
													if (!empty($field_object)) {
														$field_type = $field_object['type'];

														$item_value = $value;

														if ($field_type == 'image') {
															$image_array = explode(',', $item_value);
															$image_id = attachment_url_to_postid( $image_array[0] );
															if (!empty($image_id)) {
																$item_value = $image_id;
															}
														}

														if ($field_type == 'gallery') {
															$images_array = explode(',', $item_value);
															$images_id = array();
															foreach ($images_array as $images_item) {
																if (!empty($images_item)) {
																	$image_id = attachment_url_to_postid( $images_item );
																	if (!empty($image_id)) {
																		$images_id[] = $image_id;
																	}
																}
															}
															if (!empty($images_id)) {
																$item_value = $images_id;
															}
														}

														if ($field_type == 'select' && strpos($item_value, ',') !== false || $meta_type == 'checkbox') {
															$item_value = explode(',', $item_value);
														}

														if ($field_type == 'date') {
															$time = strtotime( $item_value );
															$item_value = date('Ymd',$time);
														}

														if ($field_type == 'time') {
															$time = strtotime( $item_value );
															$item_value = date('H:i:s',$time);
														}

														$item[$key] = $item_value;
													}
												}
											});
										}
									}

									if (!empty($custom_field_value)) {
										if (function_exists('update_field') && $form['settings']['submit_post_custom_field_source'] == 'acf_field') {

											if ($meta_type == 'image') {
												$image_array = explode(',', $custom_field_value);
												$image_id = attachment_url_to_postid( $image_array[0] );
												if (!empty($image_id)) {
													$custom_field_value = $image_id;
												}
											}

											if ($meta_type == 'gallery') {
												$images_array = explode(',', $custom_field_value);
												$images_id = array();
												foreach ($images_array as $images_item) {
													if (!empty($images_item)) {
														$image_id = attachment_url_to_postid( $images_item );
														if (!empty($image_id)) {
															$images_id[] = $image_id;
														}
													}
												}
												if (!empty($images_id)) {
													$custom_field_value = $images_id;
												}
											}

											if ($meta_type == 'select' && strpos($custom_field_value, ',') !== false || $meta_type == 'checkbox') {
												$custom_field_value = explode(',', $custom_field_value);
											}

											if ($meta_type == 'date') {
												$time = strtotime( $custom_field_value );
												$custom_field_value = date('Ymd',$time);
											}

											if ($meta_type == 'time') {
												$time = strtotime( $custom_field_value );
												$custom_field_value = date('H:i:s',$time);
											}

											update_field( $sp_custom_field['submit_post_custom_field'], $custom_field_value, $submit_post_id );

										} elseif ($form['settings']['submit_post_custom_field_source'] == 'toolset_field') {

											$meta_key = 'wpcf-' . $sp_custom_field['submit_post_custom_field'];

											if ($meta_type == 'image') {
												$image_array = explode(',', $custom_field_value);
												if (!empty($image_array)) {
													update_post_meta( $submit_post_id, $meta_key, $image_array[0] );
												}
											} elseif ($meta_type == 'gallery') {
												$images_array = explode(',', $custom_field_value);
												delete_post_meta( $submit_post_id, $meta_key);
												foreach ($images_array as $images_item) {
													if (!empty($images_item)) {
														add_post_meta( $submit_post_id, $meta_key, $images_item );
													}
												}
											} elseif ($meta_type == 'checkbox') {
												$custom_field_value = explode(',', $custom_field_value);

												$field_toolset = wpcf_admin_fields_get_field($sp_custom_field['submit_post_custom_field']);

												if (isset($field_toolset['data']['options'])){
											        $res = array();
												    foreach ($field_toolset['data']['options'] as $key => $option){
												        if (in_array($option['set_value'], $custom_field_value)){
												            $res[$key] = $option['set_value'];
												        }
												    }   
											        update_post_meta( $submit_post_id, $meta_key , $res );
												}
											} elseif ($meta_type == 'date') {
												$custom_field_value = strtotime( $custom_field_value );
												update_post_meta( $submit_post_id, $meta_key, $custom_field_value );
											} else {

												update_post_meta( $submit_post_id, $meta_key, $custom_field_value );

											}

										} elseif ($form['settings']['submit_post_custom_field_source'] == 'jet_engine_field') {
											if ($meta_type == 'image') {
												$image_array = explode(',', $custom_field_value);
												$image_id = attachment_url_to_postid( $image_array[0] );
												if (!empty($image_id)) {
													$custom_field_value = $image_id;
												}
											}

											if ($meta_type == 'gallery') {
												$images_array = explode(',', $custom_field_value);
												$images_id = '';
												foreach ($images_array as $images_item) {
													if (!empty($images_item)) {
														$image_id = attachment_url_to_postid( $images_item );
														if (!empty($image_id)) {
															$images_id .= $image_id . ',';
														}
													}
												}
												if (!empty($images_id)) {
													$custom_field_value = rtrim($images_id, ',');
												}
											}

											if ($meta_type == 'date') {
												$time = strtotime( $custom_field_value );
												$custom_field_value = date('Y-m-d',$time);
											}

											if ($meta_type == 'select') {
												if (strpos($custom_field_value, ',') !== false) {
													$custom_field_value = explode(',', $custom_field_value);
												}
											}

											if ($meta_type == 'checkbox') {
												$value_array = array();
												$custom_field_value = explode(',', $custom_field_value);
												foreach ($custom_field_value as $item) {
													$value_array[$item] = true;
												}
												$custom_field_value = $value_array;
											}

											if ($meta_type == 'time') {
												$time = strtotime( $custom_field_value );
												$custom_field_value = date('H:i',$time);
											}

											update_post_meta( $submit_post_id, $sp_custom_field['submit_post_custom_field'], $custom_field_value );

										} else {
											update_post_meta( $submit_post_id, $sp_custom_field['submit_post_custom_field'], $custom_field_value );
										}
									}
								}
							}

							update_post_meta( $submit_post_id, '_submit_button_id', $form_id );
							update_post_meta( $submit_post_id, '_submit_post_id', $post_id );

							$post_url = get_permalink( $submit_post_id );
						}							
					}

					// End Submit Post

					// Mailchipm

					if (in_array("mailchimp", $form['settings']['submit_actions'])) {

						$mailchimp_api_key_source = $form['settings']['mailchimp_api_key_source'];

						if ($mailchimp_api_key_source == 'default') {
							$mailchimp_api_key = get_option('piotnet-addons-for-elementor-pro-mailchimp-api-key');
						} else {
							$mailchimp_api_key = $form['settings']['mailchimp_api_key'];
						}

						$mailchimp_audience_id = $form['settings']['mailchimp_audience_id'];

						$mailchimp_field_mapping_list = $form['settings']['mailchimp_field_mapping_list'];

						if (!empty($mailchimp_api_key) && !empty($mailchimp_audience_id) && !empty($mailchimp_field_mapping_list)) {

							$MailChimp = new MailChimp($mailchimp_api_key);
							
							$merge_fields = array();

							foreach ($mailchimp_field_mapping_list as $item) {
								$key = $item['mailchimp_field_mapping_tag_name'];
								$shortcode = $item['mailchimp_field_mapping_field_shortcode'];
								if (!empty($key) && !empty($shortcode)) {
									$merge_fields[$key] = pafe_get_field_value($shortcode,$fields,$payment_status, $payment_id);
									if ($key == 'EMAIL' || $key == 'MERGE0') {
										$mailchimp_email = pafe_get_field_value($shortcode,$fields);
									}
								}
							}

							if (!empty($merge_fields) && !empty($mailchimp_email)) {
								$mailchimp_result = $MailChimp->post("lists/$mailchimp_audience_id/members", [
									'email_address' => $mailchimp_email,
									'merge_fields'  => $merge_fields,
									'status'        => 'subscribed',
								]);

								if ($MailChimp->success()) {
									// print_r($mailchimp_result);	
								} else {
									// echo $MailChimp->getLastError();
								}
							}
						}
					}

					// Replace redirect

					$redirect = '';

					if (in_array("redirect", $form['settings']['submit_actions'])) {
						$redirect = replace_email($form['settings']['redirect_to'], $fields);
					}

					// Woocommerce Add to Cart

					if (in_array("woocommerce_add_to_cart", $form['settings']['submit_actions'])) {
						if ( class_exists( 'WooCommerce' ) ) {  
				        	if (!empty($form['settings']['woocommerce_add_to_cart_product_id']) && !empty($form['settings']['woocommerce_add_to_cart_price'])) {

				        		$product_id = $form['settings']['woocommerce_add_to_cart_product_id'];
				        		$cart_item_data = array();
				        		$cart_item_data['fields'] = array();

			        			foreach ($fields as $key_field=>$field) {
									if ($fields[$key_field]['name'] == get_field_name_shortcode( $form['settings']['woocommerce_add_to_cart_price'] )) {
										$cart_item_data['pafe_custom_price'] = $fields[$key_field]['calculation_results'];
									}

									$cart_item_data['fields'][] = array(
										'label' => $fields[$key_field]['label'],
										'name' => $fields[$key_field]['name'],
										'value' => $fields[$key_field]['value'],
									);
								}

								global $woocommerce;

								$woocommerce->cart->add_to_cart( $product_id, 1, 0, array(), $cart_item_data );

				        	}
				    	}
					}

					// Remote Request

					if (in_array('remote_request', $form['settings']['submit_actions']) && !empty($form['settings']['remote_request_url'])) {

						$wp_args = array();

						if (!empty($form['settings']['remote_request_arguments_list'])) {
							foreach ($form['settings']['remote_request_arguments_list'] as $item) {
								if (!empty($item['remote_request_arguments_parameter']) && !empty($item['remote_request_arguments_value'])) {
									$wp_args[$item['remote_request_arguments_parameter']] = replace_email($item['remote_request_arguments_value'], $fields);
								}
							}
						}

						if (!empty($form['settings']['remote_request_body_list'])) {
							$wp_args['body'] = array();
							foreach ($form['settings']['remote_request_body_list'] as $item) {
								if (!empty($item['remote_request_body_parameter']) && !empty($item['remote_request_body_value'])) {
									$wp_args['body'][$item['remote_request_body_parameter']] = replace_email($item['remote_request_body_value'], $fields);
								}
							}
						}

		    //     		if (!empty($form['settings']['remote_request_header_list'])) {
						// 	$wp_args['headers'] = array();
						// 	foreach ($form['settings']['remote_request_header_list'] as $item) {
						// 		if (!empty($item['remote_request_header_parameter']) && !empty($item['remote_request_header_value'])) {
						// 			$wp_args['headers'][$item['remote_request_header_parameter']] = replace_email($item['remote_request_header_value'], $fields);
						// 		}
						// 	}
						// }

						$res = wp_remote_request($form['settings']['remote_request_url'], $wp_args);

					}

					// Register
					$register_message = '';

					if (in_array("register", $form['settings']['submit_actions'])) {
						if (!empty($form['settings']['register_email']) && !empty($form['settings']['register_username']) && !empty($form['settings']['register_password'])) {
							$register_email = replace_email($form['settings']['register_email'], $fields);
							$register_username = replace_email($form['settings']['register_username'], $fields);
							$register_password = replace_email($form['settings']['register_password'], $fields);
							$register_password_confirm = replace_email($form['settings']['register_password_confirm'], $fields);
							$register_first_name = replace_email($form['settings']['register_first_name'], $fields);
							$register_last_name = replace_email($form['settings']['register_last_name'], $fields);
							$register_message = '';

							if (!empty($register_password_confirm) && $register_password != $register_password_confirm) {
								$register_message = replace_email($form['settings']['register_password_confirm_message'], $fields);
								$failed = true;
							} else {
								if (!empty($register_email) && !empty($register_username) && !empty($register_password)) {
									$register_user = wp_create_user($register_username,$register_password,$register_email);
									if (is_wp_error($register_user)){ // if there was an error creating a new user
										$failed = true;
								        $register_message = $register_user->get_error_message();
								    } else {
								    	wp_update_user( array(
								    		'ID' => $register_user,
								    		'role' => $form['settings']['register_role']
							    		));

								    	if (!empty($register_first_name) && !empty($register_last_name)) {
									    	wp_update_user( array(
									    		'ID' => $register_user,
									    		'first_name' => $register_first_name,
									    		'last_name' => $register_last_name
								    		)); // Update the user with the first name and last name
									    }

									    /* Automatically log in the user and redirect the user to the home page */
										$register_creds = array( // credientials for newley created user
										    'user_login' => $register_username,
										    'user_password' => $register_password,
										    'remember' => true,
										);

										$register_signon = wp_signon($register_creds); //sign in the new user
								    }
								} else {
									$failed = true;
								}
							}
						} else {
							$failed = true;
						}
					}

					if (in_array("login", $form['settings']['submit_actions'])) {
						if (!empty($form['settings']['login_username']) && !empty($form['settings']['login_username']) && !empty($form['settings']['login_password'])) {
							$login_username = replace_email($form['settings']['login_username'], $fields);
							$login_password = replace_email($form['settings']['login_password'], $fields);
							$login_remember = replace_email($form['settings']['login_remember'], $fields);
							$register_message = '';

							if (!empty($login_username) && !empty($login_password)) {
								$login_creds = array(
								    'user_login' => $login_username,
								    'user_password' => $login_password,
								);

								if (!empty($login_remember)) {
									$login_creds['remember'] = true;
								}

								$login_signon = wp_signon($login_creds);

								if (is_wp_error($login_signon)){
									$failed = true;
							        $register_message = $login_signon->get_error_message();
							    }

							} else {
								$failed = true;
							}
						} else {
							$failed = true;
						}
					}

					// Action Hook

					do_action('pafe/form_builder/new_record',$fields);

					// Email

					if (in_array("email", $form['settings']['submit_actions']) && $failed == false) {

						$to = replace_email($form['settings']['email_to'], $fields);

						if ( ! empty( $form['settings']['pafe_stripe_status_succeeded'] ) && ! empty( $form['settings']['pafe_stripe_status_pending'] ) && ! empty( $form['settings']['pafe_stripe_status_failed'] ) ) {
							$to = replace_email( $form['settings']['email_to'], $fields, $payment_status, $payment_id, $form['settings']['pafe_stripe_status_succeeded'], $form['settings']['pafe_stripe_status_pending'], $form['settings']['pafe_stripe_status_failed'] );
						}

						$subject = replace_email($form['settings']['email_subject'], $fields);

						if ( ! empty( $form['settings']['pafe_stripe_status_succeeded'] ) && ! empty( $form['settings']['pafe_stripe_status_pending'] ) && ! empty( $form['settings']['pafe_stripe_status_failed'] ) ) {
							$subject = replace_email($form['settings']['email_subject'], $fields, $payment_status, $payment_id, $form['settings']['pafe_stripe_status_succeeded'], $form['settings']['pafe_stripe_status_pending'], $form['settings']['pafe_stripe_status_failed'] );
						}

						$message = replace_email($form['settings']['email_content'], $fields);

						if ( ! empty( $form['settings']['pafe_stripe_status_succeeded'] ) && ! empty( $form['settings']['pafe_stripe_status_pending'] ) && ! empty( $form['settings']['pafe_stripe_status_failed'] ) ) {
							$message = replace_email($form['settings']['email_content'], $fields, $payment_status, $payment_id, $form['settings']['pafe_stripe_status_succeeded'], $form['settings']['pafe_stripe_status_pending'], $form['settings']['pafe_stripe_status_failed'] );
						}

						$reply_to = $form['settings']['email_reply_to'];
						if (empty($reply_to)) {
							$reply_to = $form['settings']['email_from'];
						}
						$reply_to = replace_email($reply_to, $fields);

						if ( ! empty( $form['settings']['email_from'] ) ) {
							$headers[] = 'From: ' . $form['settings']['email_from_name'] . ' <' . $form['settings']['email_from'] . '>';
							$headers[] = 'Reply-To: ' . $reply_to;
						}

						if ( ! empty( $form['settings']['email_to_cc'] ) ) {
							$headers[] = 'Cc: ' . $form['settings']['email_to_cc'];
						}

						if ( ! empty( $form['settings']['email_to_bcc'] ) ) {
							$headers[] = 'Bcc: ' . $form['settings']['email_to_bcc'];
						}

						$headers[] = 'Content-Type: text/html; charset=UTF-8';

						if (!empty($post_url)) {
							$subject = str_replace( '[post_url]', $post_url, $subject );
							$message = str_replace( '[post_url]', '<a href="' . $post_url . '">' . $post_url . '</a>', $message );
						}

						$status = wp_mail( $to, $subject, $message . $meta_content, $headers, $attachment );

						if ( ! empty( $form['settings']['email_to_bcc'] ) ) {
							$bcc_emails = explode( ',', $form['settings']['email_to_bcc'] );
							foreach ( $bcc_emails as $bcc_email ) {
								wp_mail( trim( $bcc_email ), $subject, $message . $meta_content, $headers, $attachment );
							}
						}

					}

					if (in_array("email2", $form['settings']['submit_actions']) && $failed == false) {

						// $to = replace_email($form['settings']['email_to_2'], $fields);

						// $subject = replace_email($form['settings']['email_subject_2'], $fields);

						// $message = replace_email($form['settings']['email_content_2'], $fields);

						$to = replace_email($form['settings']['email_to_2'], $fields);

						if ( ! empty( $form['settings']['pafe_stripe_status_succeeded'] ) && ! empty( $form['settings']['pafe_stripe_status_pending'] ) && ! empty( $form['settings']['pafe_stripe_status_failed'] ) ) {
							$to = replace_email( $form['settings']['email_to_2'], $fields, $payment_status, $payment_id, $form['settings']['pafe_stripe_status_succeeded'], $form['settings']['pafe_stripe_status_pending'], $form['settings']['pafe_stripe_status_failed'] );
						}

						$subject = replace_email($form['settings']['email_subject_2'], $fields);

						if ( ! empty( $form['settings']['pafe_stripe_status_succeeded'] ) && ! empty( $form['settings']['pafe_stripe_status_pending'] ) && ! empty( $form['settings']['pafe_stripe_status_failed'] ) ) {
							$subject = replace_email($form['settings']['email_subject_2'], $fields, $payment_status, $payment_id, $form['settings']['pafe_stripe_status_succeeded'], $form['settings']['pafe_stripe_status_pending'], $form['settings']['pafe_stripe_status_failed'] );
						}

						$message = replace_email($form['settings']['email_content_2'], $fields);

						if ( ! empty( $form['settings']['pafe_stripe_status_succeeded'] ) && ! empty( $form['settings']['pafe_stripe_status_pending'] ) && ! empty( $form['settings']['pafe_stripe_status_failed'] ) ) {
							$message = replace_email($form['settings']['email_content_2'], $fields, $payment_status, $payment_id, $form['settings']['pafe_stripe_status_succeeded'], $form['settings']['pafe_stripe_status_pending'], $form['settings']['pafe_stripe_status_failed'] );
						}

						$reply_to = $form['settings']['email_reply_to_2'];
						if (empty($reply_to)) {
							$reply_to = $form['settings']['email_from_2'];
						}
						$reply_to = replace_email($reply_to, $fields);

						if ( ! empty( $form['settings']['email_from_2'] ) ) {
							$headers[] = 'From: ' . $form['settings']['email_from_name_2'] . ' <' . $form['settings']['email_from_2'] . '>';
							$headers[] = 'Reply-To: ' . $reply_to;
						}

						if ( ! empty( $form['settings']['email_to_cc_2'] ) ) {
							$headers[] = 'Cc: ' . $form['settings']['email_to_cc_2'];
						}

						if ( ! empty( $form['settings']['email_to_bcc_2'] ) ) {
							$headers[] = 'Bcc: ' . $form['settings']['email_to_bcc_2'];
						}

						$headers[] = 'Content-Type: text/html; charset=UTF-8';

						if (!empty($post_url)) {
							$subject = str_replace( '[post_url]', $post_url, $subject );
							$message = str_replace( '[post_url]', '<a href="' . $post_url . '">' . $post_url . '</a>', $message );
						}

						$status = wp_mail( $to, $subject, $message, $headers, $attachment );

						if ( ! empty( $form['settings']['email_to_bcc_2'] ) ) {
							$bcc_emails = explode( ',', $form['settings']['email_to_bcc_2'] );
							foreach ( $bcc_emails as $bcc_email ) {
								wp_mail( trim( $bcc_email ), $subject, $message, $headers, $attachment );
							}
						}

					}

					foreach ($attachment as $attachment_item) {
						unlink($attachment_item);
					}

					$failed_status = 0;

					if ($failed) {
						$redirect = '';
						$failed_status = 1;
					}

					if ($failed == false && empty($status)) {
						$status = 1;
					}

					$register_message = str_replace(',', '###', $register_message);

					echo $payment_status . ',' . $status . ',' . $payment_id . ',' . $post_url . ',' . $redirect . ',' . $register_message . ',' . $failed_status;

				} // End $recaptcha_check = 1;
			}
		wp_die();
	}
?>