<?php
/**
 * Customizer Control: text.
 *
 * Creates a text
 *
 * @author Jegstudio
 * @since 1.0.0
 * @package jeg-framework
 */

namespace WVT\Form\Field;

/**
 * Slider control (range).
 */
class Deviceheight extends Field_Abstract {

	/**
	 * Form Text Template
	 *
	 * @var string
	 */
	protected $type = 'deviceheight';

	/**
	 * An Underscore (JS) template for this control's content
	 */
	public function js_template() {
		?>
		<div class="widget-wrapper type-deviceheight" data-field="{{ data.fieldID }}">
			<div class="widget-left">
				<label for="{{ data.fieldID }}">{{{ data.title }}}</label>
			</div>
			<div class="widget-right">
				<div class="device-height-list">
					<#
						var devices = ['desktop','tablet','mobile'];
						_.each(devices, function(device){
						#>
						<div class="device-item" data-device="{{device}}">
							<label>{{ device }}</label>
							<div class="wrapper">
								<input class="jeg-number-range device-input"
							        type="range"
						            id="{{ data.fieldID }}"
						            name="{{ data.fieldName }}[{{ device }}]"
						            min="{{ data.options[device].min }}"
						            max="{{ data.options[device].max }}"
						            step="{{ data.options[device].step }}"
						            value="{{ data.value[device] }}"
						            data-reset_value="{{ data.default[device] }}"/>
								<div class="jeg_range_value">
									<span class="value">{{{ data.value[device] }}}</span>
								</div>
								<div class="jeg-slider-reset">
									<span class="dashicons dashicons-image-rotate"></span>
								</div>
							</div>
						</div>
						<#
						});
					#>
				</div>
				<i>{{{ data.description }}}</i>
			</div>
		</div>
		<?php
	}
}
