<?php
/**
 * Customizer Control: text.
 *
 * Creates a text
 *
 * @author Jegstudio
 * @since 1.0.0
 * @package jeg-framework
 */

namespace WVT\Form\Field;

/**
 * Slider control (range).
 */
class Cubemap extends Field_Abstract {

	/**
	 * Form Text Template
	 *
	 * @var string
	 */
	protected $type = 'cubemap';

	/**
	 * An Underscore (JS) template for this control's content
	 */
	public function js_template() {
		?>
		<div class="widget-wrapper type-cubemap" data-field="{{ data.fieldID }}">
			<div class="widget-left">
				<label for="{{ data.fieldID }}">{{{ data.title }}}</label>
			</div>
			<div class="widget-right">
				<div class="cubemap-list">
					<ul>
					<#
						var positions = ['front','back','left','right','top','bottom']
						_.each(positions, function(pos){
							var imageClass = ( '' !== data.value[pos] ) ? 'contain' : ''
						#>
						<li data-position="{{ pos }}" class="{{ imageClass }}">
							<div class="cubemap-img">
								<div class="cubemap-bg" style="background-image: url({{ data.value[pos] }});"></div>
								<div class="remove"></div>
							</div>
							<input type="hidden" class="image-input" name="{{ data.fieldName }}[{{ pos }}]" value="{{ data.value[pos] }}" />
							<label>{{{ pos }}}</label>
						</li>
						<#
						});
					#>
					</ul>
				</div>
				<i>{{{ data.description }}}</i>
			</div>
		</div>
		<?php
	}
}
