<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WPMSUtils
 * Group of utility methods for use by WPMS
 * All methods are static, this is just a sort of namespacing class wrapper.
 */
class WPMSUtils
{
    /**
     * Format the URL to be sure it is okay for using as a redirect url.
     *
     * This method will parse the URL and combine them in one string.
     *
     * @param string $url URL string.
     *
     * @return mixed
     */
    public static function formatUrl($url)
    {
        $parsed_url = parse_url($url);

        $formatted_url = '';
        if (!empty($parsed_url['path'])) {
            $formatted_url = $parsed_url['path'];
        }

        // Prepend a slash if first char != slash.
        if (stripos($formatted_url, '/') !== 0) {
            $formatted_url = '/' . $formatted_url;
        }

        // Append 'query' string if it exists.
        if (isset($parsed_url['query']) && '' !== $parsed_url['query']) {
            $formatted_url .= '?' . $parsed_url['query'];
        }

        return apply_filters('wpms_format_admin_url', $formatted_url);
    }
}
