<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmsGscMapper
 */
class WpmsGscMapper
{
    /**
     * The platforms which can be mapped.
     *
     * @var array
     */
    private static $platforms = array(
        'web'             => 'web',
        'mobile'          => 'mobile',
        'smartphone_only' => 'smartphoneOnly',
        'settings'        => 'settings'
    );

    /**
     * The categories which can be mapped
     *
     * @var array
     */
    private static $categories = array(
        'faulty_redirects' => 'manyToOneRedirect',
        'access_denied'    => 'authPermissions',
        'not_found'        => 'notFound',
        'soft_404'         => 'soft404',
        'other'            => 'other',
        'not_followed'     => 'notFollowed',
        'roboted'          => 'roboted',
        'server_error'     => 'serverError'
    );

    /**
     * Mapping the platform
     *
     * @param string $plat Platform (desktop, mobile, feature phone).
     *
     * @return mixed
     */
    public static function platToApi($plat)
    {
        if (!empty($plat) && isset(self::$platforms[$plat])) {
            return self::$platforms[$plat];
        }
        return false;
    }

    /**
     * Mapping the given category by searching for its key.
     *
     * @param string $cat Issue type.
     *
     * @return mixed
     */
    public static function catToApi($cat)
    {
        if (!empty($cat) && isset(self::$categories[$cat])) {
            return self::$categories[$cat];
        }
        return $cat;
    }

    /**
     * Mapping the given category by value and return its key
     *
     * @param string $cat Issue type.
     *
     * @return false|integer|string
     */
    public static function catFromApi($cat)
    {
        $cat = array_search($cat, self::$categories);
        if (!empty($cat) && $cat) {
            return $cat;
        }
        return $cat;
    }

    /**
     * Mapping the given platform by value and return its key
     *
     * @param string $plat Platform (desktop, mobile, feature phone).
     *
     * @return false|integer|string
     */
    public static function platFromApi($plat)
    {
        $plat = array_search($plat, self::$platforms);
        if (!empty($plat) && $plat) {
            return $plat;
        }
        return $plat;
    }

    /**
     * If there is no platform, just get the first key out of the array and redirect to it.
     *
     * @param string $plat Platform (desktop, mobile, feature phone).
     *
     * @return mixed
     */
    public static function getCurrentPlat($plat)
    {
        $current_plat = filter_input(INPUT_GET, $plat);
        if ($current_plat) {
            return $current_plat;
        }

        $url = add_query_arg($plat, key(self::$platforms));
        wp_redirect($url);
        exit;
    }
}
