<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmsRedirectOptionExporter
 */
class WpmsRedirectOptionExporter implements WpmsRedirectExporter
{
    /**
     * Split the redirects and store them
     *
     * @param array $redirects Redirects list
     *
     * @return boolean
     */
    public function export($redirects)
    {
        $format = array(
            WpmsRedirect::FORMAT_PLAIN => array(),
            WpmsRedirect::FORMAT_REGEX => array(),
        );

        foreach ($redirects as $redirect) {
            $format[$redirect->getFormat()][$redirect->getOrigin()] = $this->format($redirect);
        }

        // Save plain redirects
        update_option(WPMS_OPTION_PLAIN, $format[WpmsRedirect::FORMAT_PLAIN], 'no');
        // Save regex redirects
        update_option(WPMS_OPTION_REGEX, $format[WpmsRedirect::FORMAT_REGEX], 'no');
        return true;
    }

    /**
     * Formats
     *
     * @param WpmsRedirect $redirect WpmsRedirect class
     *
     * @return array
     */
    public function format(WpmsRedirect $redirect)
    {
        $array = array('url' => $redirect->getTarget(), 'type' => $redirect->getType());
        return $array;
    }
}
