<div id='redirect-<?php echo esc_html(md5($url)); ?>' style='display: none;'>
    <form>
        <div class='form-wrap wpms_content_wrapper'>
            <?php
            switch ($view_type) {
                case 'no_wpms_addon':
                    break;

                case 'create':
                    echo '<h3>', esc_html__('Redirect this broken URL and fix the error', 'wp-meta-seo-addon'), '</h3>';
                    ?>
                    <div class='form-field form-required'>
                        <label for='wpms-current-url'><?php esc_html_e('Current URL:', 'wp-meta-seo-addon'); ?></label>
                        <input type='text' id='wpms-current-url' name='current_url' value='<?php echo esc_attr($url); ?>'
                               disabled='disabled'>
                    </div>
                    <div class='form-field form-required'>
                        <label for='wpms-new-url'><?php esc_html_e('New URL:', 'wp-meta-seo-addon'); ?></label>
                        <input type='text' id='wpms-new-url' name='new_url' autofocus value=''>
                    </div>
                    <div class='form-field form-required'>
                        <label for='wpms-mark-as-fixed'
                               class='clear'><?php esc_html_e('Mark as fixed:', 'wp-meta-seo-addon'); ?></label>
                        <input type='checkbox' checked value='1' id='wpms-mark-as-fixed' name='mark_as_fixed'
                               class='clear wpms-checkbox'>
                        <p><?php
                            echo sprintf(
                                esc_html__('Mark this issue as fixed in %1$s.', 'wp-meta-seo-addon'),
                                'Google Search Console'
                            );
                            ?></p>
                    </div>
                    <p class='submit'>
                        <input type='button' name='submit' id='submit' class='ju-button orange-button wpms-small-btn'
                               value='<?php esc_attr_e('Create redirect', 'wp-meta-seo-addon'); ?>'
                               onclick='wpms_gsc_post_redirect( jQuery( this ) );'/>
                    </p>
                    <?php
                    break;

                case 'already_exists':
                    echo '<h3>', esc_html__('Error: a redirect for this URL already exists', 'wp-meta-seo-addon'), '</h3>';
                    echo '<p>';
                    echo sprintf(
                        esc_html__('You do not have to create a redirect for URL %1$s because
                         a redirect already exists. The existing redirect points to %2$s.
                          If this is fine you can mark this issue as fixed. If not,
                           please go to the redirects page and change the target URL.', 'wp-meta-seo-addon'),
                        '<code>' . esc_html($url) . '</code>',
                        '<code>' . esc_html($current_redirect->getTarget()) . '</code>'
                    );
                    echo '</p>';
                    break;
            }
            ?>
        </div>
    </form>
</div>
