<?php
echo '<div id="search_console" class="content-box">';
echo '<div class="ju-settings-option p-lrb-20 wpms_width_100">';
echo '<div class="wpms_row_full">';
// Check if there is an access token.
if (null === $this->service->getClient()->getAccessToken()) {
    // Print auth screen.
    echo '<h2 style="font-weight: 400;">
' . esc_html__('Google authentication with code', 'wp-meta-seo-addon') . '</h2>';
    echo '<a href="' . esc_url($this->service->getClient()->createAuthUrl()) . '"
             target="_blank" class="wpmsbtn wpmsbtn_small wpmsbtn_secondary ju-button orange-button">
             ' . esc_html__('Get Google Authorization Code', 'wp-meta-seo-addon') . '</a>';
    echo '<p class="ju-description">' . esc_html__('Please enter the Google Authorization Code in the field below
             and press the Authenticate button.', 'wp-meta-seo-addon') . "</p>\n";
    echo "\n";
    echo "<input type='text' class='wpms_input_material' name='gsc[authorization_code]' value='' style='width: 100%; max-width: 560px; margin-right: 10px'/>";
    echo "<input type='hidden' name='gsc[gsc_nonce]' value='" . esc_attr(wp_create_nonce('wpms-gsc_nonce')) . "' />";
    echo "<input type='submit' name='gsc[Submit]' value='" . esc_attr__('Authenticate', 'wp-meta-seo-addon') . "'
             class='wpmsbtn wpmsbtn_small ju-button orange-button' />";
    echo "\n";
    ?>
        <h2 style="font-weight: 400;"><?php esc_html_e('Google account authentication', 'wp-meta-seo-addon') ?></h2>
        <table class="form-table">
            <tbody>
            <tr>
                <th scope="row"><label
                        for="googleClientId"><?php esc_html_e('Google Client ID', 'wp-meta-seo-addon') ?></label>
                </th>
                <td>
                    <label>
                        <input name="gscapi[googleClientId]" type="text" class="regular-text"
                               value="<?php echo esc_attr($googleClientId) ?>">
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row"><label
                        for="googleClientSecret">
                        <?php esc_html_e('Google Client Secret', 'wp-meta-seo-addon') ?></label>
                </th>
                <td>
                    <label>
                        <input name="gscapi[googleClientSecret]" type="text" class="regular-text"
                               value="<?php echo esc_attr($googleClientSecret) ?>">
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="googleClientSecret"></label></th>
                <td>
                    <input name="gscapi[save]" type="submit" class="wpmsbtn ju-button orange-button"
                           value="<?php esc_attr_e('Save Changes', 'wp-meta-seo-addon') ?>">
                </td>
            </tr>
            </tbody>
        </table>
    <?php
} else {
    echo '<h3>', esc_html__('Current profile', 'wp-meta-seo-addon'), '</h3>';
    $profile  = WpmsGsc::getProfile();
    $profiles = $this->service->getSites();
    echo "<input type='hidden' name='wpms-gsc-pf[gsc_pf_nonce]' value='" . esc_attr(wp_create_nonce('gsc_pf_nonce')) . "' />";
    echo '<select name="wpms-gsc-pf[profile]" class="wpms-large-input">';
    echo '<option value="0">' . esc_html__('Select a profile', 'wp-meta-seo-addon') . '</option>';
    foreach ($profiles as $k => $v) {
        $value = trim($k, '/');
        if ($value === $profile) {
            echo '<option selected value="' . esc_attr($value) . '">' . esc_html($v) . '</option>';
        } else {
            echo '<option value="' . esc_attr($value) . '">' . esc_html($v) . '</option>';
        }
    }
    echo '</select>';
    echo '<p class="submit"><button type="submit" name="wpms-gsc-pf[submit]" id="submit" value="1"
 class="ju-button orange-button">' . esc_html__('Save Changes', 'wp-meta-seo-addon') . '</button></p>';
    echo '<button type="submit" name="wpms-gsc-pf[reauthenticate]" id="reauthenticate" value="1" class="ju-button">' .
        esc_html__('Reauthenticate with Google ', 'wp-meta-seo-addon') . '</button>';
}

echo '</div></div></div>';
?>