<ul class="wpmstabs wpms-nav-tab-wrapper" id="wpms-tabs">
    <?php
    // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in the method WpmsGsc::tabHtml and WpmsGsc::tabsHtml
    echo $html_tabs
    ?>
</ul>
<?php

if (defined('WP_DEBUG') && WP_DEBUG && WpmsGsc::getProfile() !== '') {
    ?>
    <form action="" method="post">
        <div style="width: 100%;float: left;">
            <input type='hidden' name='reload-crawl-issues-nonce'
                   value='<?php echo esc_attr(wp_create_nonce('reload-crawl-issues')); ?>'/>
            <button type="submit" name="reload-crawl-issues" id="reload-crawl-issue" class="ju-button orange-button waves-effect waves-light m-tb-20"
                    ><?php esc_html_e('Reload crawl issues', 'wp-meta-seo-addon'); ?></button>
        </div>
    </form>

<?php } ?>


<?php
switch ($current_tab) {
    case 'settings':
        // Check if there is an access token.
        if (null === $this->service->getClient()->getAccessToken()) {
            // Print auth screen.
            echo '<h2 style="font-weight: 400;">
' . esc_html__('Google authentication with code', 'wp-meta-seo-addon') . '</h2>';
            echo '<a href="' . esc_url($this->service->getClient()->createAuthUrl()) . '"
             target="_blank" class="wpmsbtn wpmsbtn_small wpmsbtn_secondary">
             ' . esc_html__('Get Google Authorization Code', 'wp-meta-seo-addon') . '</a>';
            echo '<p class="ju-description">' . esc_html__('Please enter the Google Authorization Code in the field below
             and press the Authenticate button.', 'wp-meta-seo-addon') . "</p>\n";
            echo "<form action='' method='post'>\n";
            echo "<input type='text' class='wpms_input_material' name='gsc[authorization_code]' value='' />";
            echo "<input type='hidden' name='gsc[gsc_nonce]' value='" . esc_attr(wp_create_nonce('wpms-gsc_nonce')) . "' />";
            echo "<input type='submit' name='gsc[Submit]' value='" . esc_attr__('Authenticate', 'wp-meta-seo-addon') . "'
             class='wpmsbtn wpmsbtn_small' />";
            echo "</form>\n";
            ?>
            <form action="" method="post">
                <h2 style="font-weight: 400;"><?php esc_html_e('Google account authentication', 'wp-meta-seo-addon') ?></h2>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row"><label
                                    for="googleClientId"><?php esc_html_e('Google Client ID', 'wp-meta-seo-addon') ?></label>
                        </th>
                        <td>
                            <label>
                                <input name="gscapi[googleClientId]" type="text" class="regular-text"
                                       value="<?php echo esc_attr($googleClientId) ?>">
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label
                                    for="googleClientSecret">
                                <?php esc_html_e('Google Client Secret', 'wp-meta-seo-addon') ?></label>
                        </th>
                        <td>
                            <label>
                                <input name="gscapi[googleClientSecret]" type="text" class="regular-text"
                                       value="<?php echo esc_attr($googleClientSecret) ?>">
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="googleClientSecret"></label></th>
                        <td>
                            <input name="gscapi[save]" type="submit" class="wpmsbtn"
                                   value="<?php esc_attr_e('Save Changes', 'wp-meta-seo-addon') ?>">
                        </td>
                    </tr>
                    </tbody>
                </table>
            </form>
            <?php
        } else {
            echo '<h3>', esc_html__('Current profile', 'wp-meta-seo-addon'), '</h3>';
            $profile  = WpmsGsc::getProfile();
            $profiles = $this->service->getSites();
            echo '<form action="options.php" method="post">';
            settings_fields('wpms_gsc_options');
            echo '<select name="wpms-gsc[profile]" class="wpms-large-input">';
            echo '<option value="0">' . esc_html__('Select a profile', 'wp-meta-seo-addon') . '</option>';
            foreach ($profiles as $k => $v) {
                $value = trim($k, '/');
                if ($value === $profile) {
                    echo '<option selected value="' . esc_attr($value) . '">' . esc_html($v) . '</option>';
                } else {
                    echo '<option value="' . esc_attr($value) . '">' . esc_html($v) . '</option>';
                }
            }
            echo '</select>';
            echo '<p class="submit"><button type="submit" name="submit" id="submit"
 class="ju-button orange-button">' . esc_html__('Save Changes', 'wp-meta-seo-addon') . '</button></p>';
            echo '<a class="ju-button" href="' . esc_url(add_query_arg('gsc_reset', 1)) . '">
            ' . esc_html__('Reauthenticate with Google ', 'wp-meta-seo-addon') . '</a>';
            echo '</form>';
        }
        break;
    default:
        $form_action_url = add_query_arg('page', esc_attr(filter_input(INPUT_GET, 'page')));
        echo "<form id='wpms-crawl-issues-table-form' class='wpms-form-table' action='" . esc_attr($form_action_url) . "' method='post'>\n";
        echo "<input type='hidden' class='wpms-gsc-ajax-security'
         value='" . esc_attr(wp_create_nonce('wpms-gsc-ajax-security')) . "' />\n";
        $this->displayTable();
        echo "</form>\n";
        break;
}

?>
<br class="clear"/>