<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div id="local_business" class="content-box">
    <div class="local-business-bar">
        <?php
        $LogoId        = !empty($local_business['logo']) ? absint($local_business['logo']) : null;
        $organizeImage = '<i class="material-icons business-img-default">photo</i>';
        $imgInfo       = null;
        if ($LogoId) {
            $organizeImage = wp_get_attachment_image($LogoId, 'thumbnail');
            $imgData       = wp_get_attachment_metadata($LogoId);
            $url           = wp_get_attachment_url($LogoId);
            $width         = !empty($imgData['width']) ? absint($imgData['width']) : 0;
            $height        = !empty($imgData['height']) ? absint($imgData['height']) : 0;
            $imgInfo       .= '<span><strong>URL: </strong>' . esc_url($url) . '</span>';
            $imgInfo       .= '<span><strong>Width: </strong>' . esc_html($width) . 'px</span>';
            $imgInfo       .= '<span><strong>Height: </strong>' . esc_html($height) . 'px</span>';
        }
        ?>
        <div class="wpms-seo-image-preview"><?php echo $organizeImage; // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in the method wp_get_attachment_image ?></div>
        <!--<div class="image-info"><?php /*echo $imgInfo; // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in previous line (same file) */?></div>-->
        <button type="button"
                class="wpms-seoImgAdd ju-button orange-button waves-effect waves-light"><?php esc_html_e('Upload New Picture', 'wp-meta-seo-addon') ?></button>
        <button type="button"
                class="wpms-seoImgRemove <?php echo($LogoId ? null : 'wpms-seo-hidden'); ?> ju-button waves-effect waves-light"><?php esc_html_e('Delete', 'wp-meta-seo-addon') ?></button>
        <input type="hidden" name="wpms_local_business[logo]" id="wpms_local_business_logo"
               value="<?php echo esc_attr($LogoId); ?>">
    </div>

    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text"
                   data-alt="<?php esc_html_e('Add Local Business structured
                 data information to Google', 'wp-meta-seo-addon') ?>">
                <?php esc_html_e('Enable Local Business	', 'wp-meta-seo-addon') ?>
            </label>
            <div class="ju-switch-button">
                <label class="switch">
                    <?php if (isset($local_business['enable']) && (int) $local_business['enable'] === 1) : ?>
                        <input name="wpms_local_business[enable]" type="checkbox" id="local_business_enable"
                               value="1" checked>
                    <?php else : ?>
                        <input name="wpms_local_business[enable]" type="checkbox" id="local_business_enable"
                               value="1">
                    <?php endif; ?>
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
    </div>

    <div class="ju-settings-option wpms_width_100 wpms-no-shadow wpms-no-background">
        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Name', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Name', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_local_business[type_name]" class="wpms_width_100" type="text" id="wpms_local_business_type_name"
                               value="<?php echo esc_attr($local_business['type_name']) ?>" size="50">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Address Country', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Address Country', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <select name="wpms_local_business[country]" class="wpms_width_100" id="wpms_local_business_country">
                            <?php
                            if (!empty($countrys)) {
                                foreach ($countrys as $country) {
                                    if ($local_business['country'] === $country) {
                                        echo '<option selected value="' . esc_attr($country) . '">' . esc_html($country) . '</option>';
                                    } else {
                                        echo '<option value="' . esc_attr($country) . '">' . esc_html($country) . '</option>';
                                    }
                                }
                            }
                            ?>
                        </select>
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Street Address', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Street Address', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_local_business[address]" class="wpms_width_100" type="text" id="wpms_local_business_address"
                               value="<?php echo esc_attr($local_business['address']) ?>" size="50">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Address Locality', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Address Locality', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_local_business[city]" class="wpms_width_100" class="wpms_width_100" type="text" id="wpms_local_business_city"
                               value="<?php echo esc_attr($local_business['city']) ?>" size="50">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Address Region', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Address Region', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_local_business[state]" class="wpms_width_100" type="text" id="wpms_local_business_state"
                               value="<?php echo esc_attr($local_business['state']) ?>" size="50">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Phone', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Phone', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_local_business[phone]" class="wpms_width_100" type="text" id="wpms_local_business_phone"
                               value="<?php echo esc_attr($local_business['phone']) ?>" size="50">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Pricerange', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Pricerange', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_local_business[pricerange]" class="wpms_width_100" type="text" id="wpms_local_business_pricerange"
                               value="<?php echo esc_attr($local_business['pricerange']) ?>" size="50">
                    </label>
                </p>
            </div>
        </div>
    </div>

    <div class="wpms_width_100 wpms_left">
        <button type="button"
                class="wpms_local_business ju-button orange-button waves-effect waves-light"><?php esc_html_e('Save', 'wp-meta-seo-addon') ?></button>
        <span class="message_saved"><?php esc_html_e('Saved', 'wp-meta-seo-addon') ?></span>
    </div>
</div>