<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
wp_enqueue_style('m-style-qtip');
wp_enqueue_script('jquery-qtip');
?>
<div class="content-box">
    <?php
    // phpcs:ignore WordPress.Security.NonceVerification.Missing -- View request, no action
    if (isset($_POST['_metaseo_addon_sendemail'])) {
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/page/saved_info.php');
    }
    ?>
    <h1 class="wpms-top-h1"><?php esc_html_e('Sender Email', 'wp-meta-seo-addon') ?></h1>
    <form method="post" action="">
        <div class="ju-settings-option height_140">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Add the Email identified as sender', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Sender Email', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="_metaseo_addon_sendemail[showEmailSender]" type="text" id="showEmailSender" class="wpms-large-input wpms_width_100"
                               value="<?php echo esc_attr($this->email_settings['showEmailSender']) ?>"/>
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option wpms_right m-r-0">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Add a subject to your report Email', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Email subject', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="_metaseo_addon_sendemail[showEmailTitle]" type="text" id="showEmailTitle" class="wpms-large-input wpms_width_100"
                               value="<?php echo esc_attr($this->email_settings['showEmailTitle']) ?>"/>
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option height_140">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100"
                       data-alt="<?php esc_html_e('Change the frequency of the Email reports, or use the Single Email Report
                 to send only manual reports', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Email frequency', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input type="number" <?php echo(empty($this->email_settings['showEmailFrequency']) ? 'disabled' : '') ?>
                               name="_metaseo_addon_sendemail[numberFrequency]" class="wpms-large-input wpms_width_10" id="numberFrequency"
                               value="<?php echo esc_attr($this->email_settings['numberFrequency']) ?>">
                        <select name="_metaseo_addon_sendemail[showEmailFrequency]" id="showEmailFrequency" class="wpms-large-input">
                            <option <?php selected($this->email_settings['showEmailFrequency'], 0) ?>
                                    value="0"><?php esc_html_e('Single email report', 'wp-meta-seo-addon') ?></option>
                            <option <?php selected($this->email_settings['showEmailFrequency'], 'month') ?>
                                    value="month"><?php esc_html_e('Month', 'wp-meta-seo-addon') ?></option>
                            <option <?php selected($this->email_settings['showEmailFrequency'], 'week') ?>
                                    value="week"><?php esc_html_e('Week', 'wp-meta-seo-addon') ?></option>
                            <option <?php selected($this->email_settings['showEmailFrequency'], 'day') ?>
                                    value="day"><?php esc_html_e('Day', 'wp-meta-seo-addon') ?></option>
                        </select>
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option wpms_right m-r-0">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('The Email of the recipient. Can be several Emails
                 separated by comma', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Send report to', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="_metaseo_addon_sendemail[showEmailSend]" type="email" id="showEmailSend" class="wpms-large-input wpms_width_100"
                               value="<?php echo esc_attr($this->email_settings['showEmailSend']) ?>"/>
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option wpms_width_100">
            <div class="wpms_row_full">
                <label class="ju-setting-label"
                       data-alt="<?php esc_html_e('Before the Google Analytics data you can add a custom
                 content to your Email', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Before text message', 'wp-meta-seo-addon') ?>
                </label>
                <div class="p-lr-20 wpms_width_100 wpms_left">
                    <label>
                        <?php
                        $params = array(
                            'textarea_name' => '_metaseo_addon_sendemail[showEmailContent]',
                            'editor_class'  => 'wpms_sendemail',
                            'media_buttons' => true
                        );
                        wp_editor(stripslashes_deep($this->email_settings['showEmailContent']), 'wpms_sendemail', $params); ?>
                    </label>
                </div>
            </div>
        </div>


        <div class="wrap wrap_sendemail wpms_width_100 wpms_left">
            <div>
                <h1 class="wpms-top-h1"><?php esc_html_e('Google analytics data to include in Report', 'wp-meta-seo-addon') ?></h1>
                <div class="list_add_ga">
                    <?php
                    if (!empty($config)) {
                        foreach ($config as $k => $v) {
                            echo '<p class="row_list_ga" data-value="' . esc_html($k) . '">';
                            echo esc_html__('View: ', 'wp-meta-seo-addon') . esc_html($v[1] . ' / ' . $v[3]);
                            echo '<span class="wpmsemail_remove_list dashicons dashicons-no-alt"></span>';
                            echo '</p>';
                        }
                    }
                    ?>
                </div>
                <div class="wpmsemail-btn-toolbar wpmsemail-btn-toolbar-date">
                    <?php
                    foreach ($toolbar['dateList'] as $k => $v) {
                        echo '<div class="wpmsemail_date" data-value="' . esc_attr($k) . '">' . esc_html($v) . '</div>';
                    }
                    ?>
                </div>

                <div class="wpmsemail-btn-toolbar wpmsemail-btn-toolbar-report">
                    <?php
                    foreach ($toolbar['reportList'] as $k => $v) {
                        echo '<div class="wpmsemail_report" data-value="' . esc_attr($k) . '">' . esc_html($v) . '</div>';
                    }
                    ?>
                </div>
                <button type="button" class="wpmsemail_add_view ju-button orange-button m-tb-20"><?php esc_html_e('Add new analytics view', 'wp-meta-seo-addon') ?></button>
            </div>

            <h2 class="wpms-top-h2"><?php esc_html_e('WP Meta SEO data to include in report', 'wp-meta-seo-addon') ?></h2>
            <div class="wpms_row_full">
                <?php
                foreach ($list_meta_datas as $k => $v) {
                    ?>
                    <div class="ju-settings-option list_meta_datas">
                        <div class="wpms_row_full">
                            <input type="hidden" name="_metaseo_settings[home_meta_active]" value="0">
                            <label class="ju-setting-label text">
                                <?php echo esc_html($v) ?>
                            </label>
                            <label class="wpms_right p-lr-20" style="line-height: 50px">
                                    <?php if (in_array($k, $this->email_settings['wpms_email_meta'])) : ?>
                                        <input type="checkbox" name="_metaseo_addon_sendemail[wpms_email_meta][]"
                                               class="wpms_email_meta wpms-checkbox" value="<?php echo esc_attr($k) ?>" id="<?php echo esc_attr('wpms_email_meta' . $k) ?>" checked>
                                    <?php else : ?>
                                        <input type="checkbox" name="_metaseo_addon_sendemail[wpms_email_meta][]"
                                               class="wpms_email_meta wpms-checkbox" value="<?php echo esc_attr($k) ?>" id="<?php echo esc_attr('wpms_email_meta' . $k) ?>">
                                    <?php endif; ?>

                            </label>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
            <?php
            $text = esc_html__('Send Email and Save report', 'wp-meta-seo-addon');
            ?>
            <p class="submit">
                <button type="submit" name="btn_save_report" id="btn_save_report" class="ju-button orange-button"
                        ><?php esc_html_e('Save report', 'wp-meta-seo-addon') ?></button>
                <button type="button" name="btn_sendemail" id="btn_sendemail" class="ju-button orange-button"
                        ><?php esc_html_e('Send Email now', 'wp-meta-seo-addon') ?></button>
                <span class="spinner wpmsemail_spinner"></span>
                <span class="sendemail_msg_success wpms-msg-success"></span>
                <span class="sendemail_msg_error wpms-msg-error"></span>
            </p>
        </div>
    </form>
</div>