<?php
/**
 * Plugin Name: WP Meta SEO Addon
 * Plugin URI: https://www.joomunited.com/wordpress-products/wp-meta-seo
 * Description: WP Meta SEO Addon brings your website ranking to the next level with advanced tools like SEO Email reports, automatic 404 URL fix and more
 * Version: 1.4.0
 * Text Domain: wp-meta-seo-addon
 * Domain Path: /languages
 * Author: JoomUnited
 * Author URI: http://www.joomunited.com
 * License: GPL2
 */

// Make sure we don't expose any info if called directly
if (!function_exists('add_action')) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

//Check plugin requirements
if (version_compare(PHP_VERSION, '5.3', '<')) {
    if (!function_exists('wpms_addon_disable_plugin')) {
        /**
         * Deactivate plugin
         *
         * @return void
         */
        function wpms_addon_disable_plugin()
        {
            if (current_user_can('activate_plugins') && is_plugin_active(plugin_basename(__FILE__))) {
                deactivate_plugins(__FILE__);
                unset($_GET['activate']);
            }
        }
    }

    if (!function_exists('wpms_addon_show_error')) {
        /**
         * Show notice
         *
         * @return void
         */
        function wpms_addon_show_error()
        {
            echo '<div class="error"><p><strong>WP Meta SEO Addon</strong>
 need at least PHP 5.3 version, please update php before installing the plugin.</p></div>';
        }
    }

    //Add actions
    add_action('admin_init', 'wpms_addon_disable_plugin');
    add_action('admin_notices', 'wpms_addon_show_error');

    //Do not load anything more
    return;
}

if (!class_exists('\Joomunited\WPMSADDON\JUCheckRequirements')) {
    require_once(trailingslashit(dirname(__FILE__)) . 'requirements.php');
}

if (class_exists('\Joomunited\WPMSADDON\JUCheckRequirements')) {
    // Plugins name for translate
    $args = array(
        'plugin_name' => esc_html__('WP Meta SEO Addon', 'wp-meta-seo-addon'),
        'plugin_path' => 'wp-meta-seo-addon/wp-meta-seo-addon.php',
        'plugin_textdomain' => 'wp-meta-seo-addon',
        'requirements' => array(
            'plugins'     => array(
                array(
                    'name' => 'WP Meta SEO',
                    'path' => 'wp-meta-seo/wp-meta-seo.php',
                    'requireVersion' => '4.0.1'
                )
            ),
            'php_version' => '5.3',
            'php_modules' => array(
                'curl' => 'warning'
            )
        )
    );
    $wpmsCheck = call_user_func('\Joomunited\WPMSADDON\JUCheckRequirements::init', $args);

    if (!$wpmsCheck['success']) {
        // Do not load anything more
        unset($_GET['activate']);
        return;
    }
}

/**
 * Get plugin path
 *
 * @return string
 */
function wpmsAddons_getPath()
{
    return 'wp-meta-seo-addon/wp-meta-seo-addon.php';
}

//JUtranslation
add_filter('wp-meta-seo_get_addons', function ($addons) {
    $addon                          = new StdClass();
    $addon->main_plugin_file        = __FILE__;
    $addon->extension_name          = 'WP Meta SEO Addon';
    $addon->extension_slug          = 'wp-meta-seo-addon';
    $addon->text_domain             = 'wp-meta-seo-addon';
    $addon->language_file
                                    = plugin_dir_path(__FILE__) . 'languages' . DIRECTORY_SEPARATOR . 'wp-meta-seo-addon-en_US.mo';
    $addons[$addon->extension_slug] = $addon;
    return $addons;
});

include_once(ABSPATH . 'wp-admin/includes/plugin.php');
if (is_plugin_active('wp-meta-seo/wp-meta-seo.php')) {
    if (!defined('WPMETASEO_ADDON_PLUGIN_URL')) {
        /**
         * URL to WP Meta SEO Addon plugin
         */
        define('WPMETASEO_ADDON_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

    if (!defined('WPMETASEO_ADDON_PLUGIN_DIR')) {
        /**
         * Path to WP Meta SEO Addon plugin
         */
        define('WPMETASEO_ADDON_PLUGIN_DIR', plugin_dir_path(__FILE__));
    }

    if (!defined('WPMSEO_ADDON_VERSION')) {
        /**
         * Plugin version
         */
        define('WPMSEO_ADDON_VERSION', '1.4.0');
    }

    if (!defined('WPMSEO_ADDON_FILE')) {
        /**
         * Path to this file
         */
        define('WPMSEO_ADDON_FILE', __FILE__);
    }

    if (!defined('WPMSEO_ADDON_CLIENT_ID')) {
        /**
         * Default google client id
         */
        define('WPMSEO_ADDON_CLIENT_ID', '88871037466-f69cc506uc55rhgvm0733i2jqlrnq4u2.apps.googleusercontent.com');
    }

    if (!defined('WPMSEO_ADDON_CLIENT_SECRET')) {
        /**
         * Default google client secret
         */
        define('WPMSEO_ADDON_CLIENT_SECRET', 'X2K7KuiE84vOn17q0wq4xCu1');
    }

    if (!defined('WPMS_CSSJS_SUFFIX')) {
        /**
         * Suffix to load css and js file
         */
        define('WPMS_CSSJS_SUFFIX', ((defined('SCRIPT_DEBUG') && true === SCRIPT_DEBUG) ? '' : '.min'));
    }

    if (!defined('WPMS_GSC_LAST_FETCH')) {
        /**
         * Option google search console fetch
         */
        define('WPMS_GSC_LAST_FETCH', 'wpms_gsc_last_fetch');
    }

    if (!defined('WPMS_GSC_COUNTS')) {
        /**
         * Option google search console count issues
         */
        define('WPMS_GSC_COUNTS', 'wpms_gsc_issues_counts');
    }

    if (!defined('WPMS_GSC')) {
        /**
         * Option google search console
         */
        define('WPMS_GSC', 'wpms-gsc');
    }

    if (!defined('WPMS_OPTION_REGEX')) {
        /**
         * Option redirect regex
         */
        define('WPMS_OPTION_REGEX', 'wpms-addon-redirects-export-regex');
    }

    if (!defined('WPMS_OPTION_PLAIN')) {
        /**
         * Option redirect plain
         */
        define('WPMS_OPTION_PLAIN', 'wpms-addon-redirects-export-plain');
    }

    if (!defined('WPMS_OPTION')) {
        /**
         * Option redirect base
         */
        define('WPMS_OPTION', 'wpms-addon-redirects-base');
    }

    if (!defined('WPMS_REDIRECT_PERMANENT')) {
        /**
         * Option redirect permanent
         */
        define('WPMS_REDIRECT_PERMANENT', 301);
    }

    if (!defined('WPMS_REDIRECT_DELETED')) {
        /**
         * Option redirect delete
         */
        define('WPMS_REDIRECT_DELETED', 410);
    }

    if (is_admin()) {
        $classMap = array(
            'MetaSeoAddonSite'       => WPMETASEO_ADDON_PLUGIN_DIR . 'inc/class.metaseo-addon-site.php',
            'WpmsGsc'                => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-gsc.php',
            'WpmsGscAjax'            => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-ajax.php',
            'WpmsGscCategoryFilters' => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-category-filters.php',
            'WpmsGscCount'           => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-count.php',
            'WpmsGscIssue'           => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-issue.php',
            'WpmsGscIssues'          => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-issues.php',
            'WpmsGscMapper'          => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-mapper.php',
            'WpmsGscMarker'          => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-marker.php',
            'WpmsGscService'         => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-service.php',
            'WpmsGscTable'           => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/gsc/class.metaseo-table.php',
            'WPMSUtils'              => WPMETASEO_ADDON_PLUGIN_DIR . '/inc/class.metaseo-utils.php',
        );

        foreach ($classMap as $item) {
            require_once $item;
        }

        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/class.metaseo-addon-admin.php');
        $GLOBALS['metaseo_addon'] = new MetaSeoAddonAdmin;
    } else {
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/class.metaseo-addon-site.php');
        $GLOBALS['metaseo_addon_site'] = new MetaSeoAddonSite;
    }

    /**
     * Load redirect file
     *
     * @return void
     */
    function wpms_redirect_init()
    {
        spl_autoload_register('wpms_redirect_load');
    }

    /**
     * Load redirect source
     *
     * @return void
     */
    function wpms_redirect_load()
    {
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/gsc/redirect/class.metaseo-redirect-option.php');
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/gsc/redirect/class.metaseo-redirect-option-exporter.php');
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/gsc/redirect/class.metaseo-redirect-exporter.php');
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/gsc/redirect/class.metaseo-redirect.php');
        require_once(WPMETASEO_ADDON_PLUGIN_DIR . 'inc/gsc/redirect/class.metaseo-redirect-manager.php');
    }

    add_action('plugins_loaded', 'wpms_redirect_init', 14);
}

//config section
if (!defined('JU_BASE')) {
    /**
     * Joomunited url
     */
    define('JU_BASE', 'https://www.joomunited.com/');
}

$remote_updateinfo = JU_BASE . 'juupdater_files/wp-meta-seo-addon.json';
//end config

require 'juupdater/juupdater.php';
$UpdateChecker = Jufactory::buildUpdateChecker(
    $remote_updateinfo,
    __FILE__
);
