<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmsGscIssue
 */
class WpmsGscIssue
{

    /**
     * URL
     *
     * @var string
     */
    private $url;
    /**
     * First time detected
     *
     * @var DateTime
     */
    private $first_detected;
    /**
     * Last time crawled
     *
     * @var DateTime
     */
    private $last_crawled;
    /**
     * Response code
     *
     * @var string
     */
    private $response_code;

    /**
     * WpmsGscIssue constructor.
     *
     * @param string   $url            URL
     * @param DateTime $first_detected First time detected
     * @param DateTime $last_crawled   Last time crawled
     * @param string   $response_code  Response code
     */
    public function __construct($url, DateTime $first_detected, DateTime $last_crawled, $response_code)
    {
        $this->url            = $url;
        $this->first_detected = $first_detected;
        $this->last_crawled   = $last_crawled;
        $this->response_code  = $response_code;
    }

    /**
     * Converting the date to a timestamp
     *
     * @param DateTime $date Date object instance.
     *
     * @return string
     */
    private function timestamp(DateTime $date)
    {
        $date_convert = $date->format('U');
        return $date_convert;
    }

    /**
     * Converting the date to a date format
     *
     * @param DateTime $date   Date instance.
     * @param string   $format Format string.
     *
     * @return string
     */
    private function dateFormat(DateTime $date, $format = '')
    {
        if (empty($format)) {
            $format = get_option('date_format');
        }
        $date_convert = date_i18n($format, $date->format('U'));
        return $date_convert;
    }

    /**
     * Put the class properties in array
     *
     * @return array
     */
    public function toArray()
    {
        $array = array(
            'url'                => $this->url,
            'first_detected'     => $this->dateFormat($this->first_detected),
            'first_detected_raw' => $this->timestamp($this->first_detected),
            'last_crawled'       => $this->dateFormat($this->last_crawled),
            'last_crawled_raw'   => $this->timestamp($this->last_crawled),
            'response_code'      => $this->response_code,
        );
        return $array;
    }
}
