<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmsGscMarker
 */
class WpmsGscMarker
{
    /**
     * Crawl issues
     *
     * @var object
     */
    private $crawl_issues;
    /**
     * Result
     *
     * @var string
     */
    private $result;
    /**
     * Platform
     *
     * @var string
     */
    private $platform;
    /**
     * URL
     *
     * @var string
     */
    private $url = '';
    /**
     * Category
     *
     * @var string
     */
    private $category;

    /**
     * WpmsGscMarker constructor.
     *
     * @param string $url URL
     */
    public function __construct($url = '')
    {
        $this->url    = $url;
        $this->result = $this->getResult();
    }

    /**
     * Getting the response for the AJAX request
     *
     * @return string
     */
    public function getResponse()
    {
        return $this->result;
    }

    /**
     * Check if request is valid by verifying the posted nonce and return the URL if this one is set
     *
     * @return boolean|string
     */
    private function checkMarkedAsFixed()
    {
        if ($this->url !== '') {
            return $this->url;
        }

        return false;
    }

    /**
     * Setting the result, this method will check if current
     *
     * @return string
     */
    private function getResult()
    {
        $check = $this->checkMarkedAsFixed();
        if ($check) {
            $service            = new WpmsGscService(WpmsGsc::getProfile());
            $check_set_issue    = $this->setCrawlIssues();
            $check_send_mark    = $this->sendMarkAsFixed($service);
            $check_delete_crawl = $this->deleteCrawlIssue();
            if ($check_set_issue && $check_send_mark && $check_delete_crawl) {
                $this->updateCountIssue($service);
                return 'true';
            }
        }

        return 'false';
    }

    /**
     * Sending a request to the Google Search Console API to let them know we marked an issue as fixed.
     *
     * @param WpmsGscService $service Service object instance.
     *
     * @return boolean
     */
    private function sendMarkAsFixed(WpmsGscService $service)
    {
        return $service->markAsFixed($this->url, $this->platform, $this->category);
    }

    /**
     * Getting the counts for current platform - category combination and update the score of it.
     *
     * @param WpmsGscService $service Service object instance.
     *
     * @return void
     */
    private function updateCountIssue(WpmsGscService $service)
    {
        $counts = new WpmsGscCount($service);
        // Get the issues.
        $total_issues = $counts->countIssue($this->platform, $this->category);
        $total_issues --;
        // update count.
        $counts->updateCountIssue($this->platform, $this->category, $total_issues);
    }

    /**
     * Storing the data belonging to the current issue, this data is needed in the 'mark as fixed' flow
     *
     * @return boolean
     */
    private function setCrawlIssues()
    {
        $this->platform = filter_input(INPUT_POST, 'platform');
        $this->category = filter_input(INPUT_POST, 'category');
        if ($this->platform && $this->category) {
            $this->crawl_issues = new WpmsGscIssues($this->platform, $this->category);
            return true;
        }

        return false;
    }

    /**
     * Delete the crawl issue from the database
     *
     * @return mixed
     */
    private function deleteCrawlIssue()
    {
        return $this->crawl_issues->removeIssue($this->url);
    }
}
