<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div id="send_email" class="content-box">
    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text"
                   data-alt="<?php esc_html_e('Enable SMTP send email', 'wp-meta-seo-addon') ?>">
                <?php esc_html_e('Enable SMTP send email', 'wp-meta-seo-addon') ?>
            </label>
            <div class="ju-switch-button">
                <label class="switch">
                    <?php if (isset($email_settings['enable']) && (int) $email_settings['enable'] === 1) : ?>
                        <input name="wpms_email_settings[enable]" type="checkbox" id="showSmtpenable"
                               value="1" checked>
                    <?php else : ?>
                        <input name="wpms_email_settings[enable]" type="checkbox" id="showSmtpenable"
                               value="1">
                    <?php endif; ?>
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
    </div>

    <div class="ju-settings-option wpms_width_100 wpms-no-shadow wpms-no-background">
        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('SMTP Host', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('SMTP Host', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_email_settings[host]" class="wpms_width_100" type="text" id="showSmtpHost"
                               value="<?php echo esc_attr($email_settings['host']) ?>">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('SMTP Port', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('SMTP Port', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_email_settings[port]" class="wpms_width_100" type="text" id="showSmtpPort"
                               value="<?php echo esc_attr($email_settings['port']) ?>">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('SMTP username', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('SMTP username', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_email_settings[username]" class="wpms_width_100" type="text" id="showSmtpUser"
                               value="<?php echo esc_attr($email_settings['username']) ?>">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('SMTP Password', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('SMTP Password', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label>
                        <input name="wpms_email_settings[password]" class="wpms_width_100" type="password"
                               id="showSmtpPass"
                               value="<?php echo esc_attr($email_settings['password']) ?>">
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label wpms_width_100 wpms_left"
                       data-alt="<?php esc_html_e('Type of Encription', 'wp-meta-seo-addon'); ?>">
                    <?php esc_html_e('Type of Encription', 'wp-meta-seo-addon') ?>
                </label>
                <p class="p-d-20">
                    <label class="radio m-r-30">
                        <input type="radio" name="wpms_email_settings[type_encryption]" class="wpms-radio"
                               value="none" <?php checked($email_settings['type_encryption'], 'none') ?>>
                        <span class="outer"><span
                                    class="inner"></span></span><?php esc_html_e(' None', 'wp-meta-seo-addon'); ?>
                    </label>
                    <label class="radio m-r-30">
                        <input type="radio" name="wpms_email_settings[type_encryption]" class="wpms-radio"
                               value="ssl" <?php checked($email_settings['type_encryption'], 'ssl') ?>>
                        <span class="outer"><span
                                    class="inner"></span></span><?php esc_html_e(' SSL', 'wp-meta-seo-addon'); ?>
                    </label>
                    <label class="radio">
                        <input type="radio" name="wpms_email_settings[type_encryption]" class="wpms-radio"
                               value="tls" <?php checked($email_settings['type_encryption'], 'tls') ?>>
                        <span class="outer"><span
                                    class="inner"></span></span><?php esc_html_e(' TLS', 'wp-meta-seo-addon'); ?>
                    </label>
                </p>
            </div>
        </div>

        <div class="ju-settings-option">
            <div class="wpms_row_full">
                <label class="ju-setting-label text"
                       data-alt="<?php esc_html_e('SMTP Authentication', 'wp-meta-seo-addon') ?>">
                    <?php esc_html_e('SMTP Authentication', 'wp-meta-seo-addon') ?>
                </label>
                <div class="ju-switch-button">
                    <label class="switch">
                        <?php if (isset($email_settings['autentication']) && $email_settings['autentication'] === 'yes') : ?>
                            <input name="wpms_email_settings[autentication]" type="checkbox" id="showautentication"
                                   value="yes" checked>
                        <?php else : ?>
                            <input name="wpms_email_settings[autentication]" type="checkbox" id="showautentication"
                                   value="yes">
                        <?php endif; ?>
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="wpms_width_100 wpms_left">
        <button type="button"
                class="wpms_save_settingemail ju-button orange-button waves-effect waves-light"><?php esc_html_e('Save', 'wp-meta-seo-addon') ?></button>
        <span class="message_saved"><?php esc_html_e('Saved', 'wp-meta-seo-addon') ?></span>
    </div>
</div>
