<?php
defined('ABSPATH') || die('No direct script access allowed!');
wp_enqueue_script('wpms_script_link');
?>
<div class="ju-settings-option">
    <div class="wpms_row_full">
        <label class="ju-setting-label text" data-alt="<?php esc_html_e('The automatic URL index will be executed as
             a background task on a defined period', 'wp-meta-seo-addon'); ?>">
            <?php esc_html_e('Run automatic 404 indexation', 'wp-meta-seo-addon') ?>
        </label>
        <div class="ju-switch-button">
            <label class="switch">
                <?php if (isset($link_settings['enable']) && (int) $link_settings['enable'] === 1) : ?>
                    <input name="wpms_link_settings[enable]" type="checkbox" id="scanlinkenable"
                           value="1" checked>
                <?php else : ?>
                    <input name="wpms_link_settings[enable]" type="checkbox" id="scanlinkenable"
                           value="1">
                <?php endif; ?>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
</div>

<div class="ju-settings-option height_140 wpms_right m-r-0">
    <div class="wpms_row_full">
        <label class="ju-setting-label wpms_width_100 wpms_left" data-alt="<?php esc_html_e('How often do you want to run
             the broken link automatic index', 'wp-meta-seo-addon'); ?>">
            <?php esc_html_e('Frequency', 'wp-meta-seo-addon') ?>
        </label>
        <p class="p-d-20">
            <label>
                <input type="number" <?php echo(empty($link_settings['showlinkFrequency']) ? 'disabled' : '') ?>
                       name="wpms_link_settings[numberFrequency]" class="regular-text" id="numberFrequency"
                       value="<?php echo esc_attr($link_settings['numberFrequency']) ?>">
                <select name="wpms_link_settings[showlinkFrequency]" id="showlinkFrequency">
                    <option <?php selected($link_settings['showlinkFrequency'], 'month') ?>
                            value="month"><?php esc_html_e('Month', 'wp-meta-seo-addon') ?></option>
                    <option <?php selected($link_settings['showlinkFrequency'], 'week') ?>
                            value="week"><?php esc_html_e('Week', 'wp-meta-seo-addon') ?></option>
                    <option <?php selected($link_settings['showlinkFrequency'], 'day') ?>
                            value="day"><?php esc_html_e('Day', 'wp-meta-seo-addon') ?></option>
                </select>
            </label>
        </p>
    </div>
</div>