<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div class="links-sitemap-nav">
    <div class="tablenav bottom">
        <div class="alignleft actions"></div>
        <div class="tablenav-pages">
            <span class="displaying-num"><?php echo esc_html($count_items) ?> items</span>
            <span class="pagination-links">
                <?php if ((int) $page === 1) : ?>
                    <a class="wpms-number-page">
                        <i class='material-icons'>first_page</i>
                    </a>
                    <a class="wpms-number-page">
                        <i class='material-icons'>keyboard_backspace</i>
                    </a>
                <?php else : ?>
                    <a class="wpms-number-page first-page wpms_linkcheck_page" data-page="1">
                        <i class='material-icons'>first_page</i>
                    </a>
                    <a class="wpms-number-page prev-page wpms_linkcheck_page" data-page="<?php echo esc_attr($page - 1) ?>">
                        <i class='material-icons'>keyboard_backspace</i>
                    </a>
                <?php endif; ?>

                <span class="paging-input"><label for="current-page-selector"
                                                  class="screen-reader-text"><?php esc_html_e('Current Page', 'wp-meta-seo-addon') ?></label><input
                            class="wpms-current-page-linkcheck current-page" id="current-page-selector" type="text"
                            name="paged" value="<?php echo esc_attr($page) ?>" size="1" aria-describedby="table-paging"><span
                            class="tablenav-paging-text"> of <span class="total-pages">
                            <?php echo esc_html($count_page) ?></span></span></span>

                <?php if ((int) $page === (int) $count_page) : ?>
                    <a class="wpms-number-page">
                        <i class='material-icons'>trending_flat</i>
                    </a>
                    <a class="wpms-number-page">
                        <i class='material-icons'>last_page</i>
                    </a>
                <?php else : ?>
                    <a class="wpms-number-page next-page wpms_linkcheck_page" data-page="<?php echo esc_attr($page + 1) ?>">
                        <span class="screen-reader-text"><?php esc_html_e('Next page', 'wp-meta-seo-addon') ?></span><i class='material-icons'>trending_flat</i>
                    </a>
                    <a class="wpms-number-page last-page wpms_linkcheck_page" data-page="<?php echo esc_attr($count_page) ?>">
                        <i class='material-icons'>last_page</i>
                    </a>
                <?php endif; ?>

            </span>
        </div>
        <br class="clear">
    </div>
</div>