<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div class="wpmseotab wpmseo_gsc_keywords wpms-form-table" id="wpmseo_gsc_keywords">
    <div class="meta-box-top wpms-top-description">
        <span class="wpms-description metaseo_tool">
            <?php esc_html_e('This is the Google Search Console data. Improve your content by targeting existing Google keywords', 'wp-meta-seo-addon') ?>
        </span>
    </div>
    <div class="wpms_left wpms_width_80 gsc_keywords search_gsc_keywords_content">
        <div class="wpms_left label-filter" style="width: 13%;">
            <label class="wpms_width_100"><?php esc_html_e('Search type', 'wp-meta-seo-addon') ?></label>
        </div>
        <div class="wpms_left wpms_width_25 type-filter-input" style="margin-right: 1%">
            <select class="wpms_width_100 filter-type-name" name="filter_type_name">
                <option value="query"><?php esc_html_e('Google search keywords', 'wp-meta-seo-addon') ?></option>
                <option selected="selected" value="page"><?php esc_html_e('Page URL keywords', 'wp-meta-seo-addon') ?></option>
            </select>
        </div>
        <div class="wpms_left search wpms_width_40" style="margin-right: 1%">
            <input type="text" id="wpms-search-input-csl" class="wpms-search-key-csl wpms_width_100 wppms-large-input" name="s" placeholder="<?php esc_html_e('Google Search Console keyword filter', 'wp-meta-seo-addon') ?>">
            <i class="material-icons icons-key-csl-search metaseo_tool" data-alt="<?php esc_html_e('Display the Google Search keywords based on the page URL only', 'wp-meta-seo-addon') ?>">offline_bolt</i>
        </div>
        <div class="wpms_left button-search wpms_width_15">
            <button type="button" id="wpms-csl-search-submit" data-alt="<?php esc_html_e('Search using keywords or page URL', 'wp-meta-seo-addon') ?>"
                    class="wpms_width_100 ju-button orange-button waves-effect waves-light metaseo_tool"><?php esc_html_e('Search', 'wp-meta-seo-addon') ?></button>
        </div>
        <div class="clear"></div>
    </div>
    <div class="wpms_left wpms_width_20 gsc_keywords filter_gsc_keywords_content">
        <div class="gsc_keywords_time_filter wpms_left wpms_width_80" style="margin-left: 3%">
            <select class="wpms_width_100" name="gsc_keywords_time_filter_select">
                <option value="7"><?php esc_html_e('Last Week', 'wp-meta-seo-addon') ?></option>
                <option value="30"><?php esc_html_e('Last Month', 'wp-meta-seo-addon') ?></option>
                <option selected="selected" value="90"><?php esc_html_e('Last 3 Month', 'wp-meta-seo-addon') ?></option>
                <option value="180"><?php esc_html_e('Last 6 Month', 'wp-meta-seo-addon') ?></option>
                <option value="365"><?php esc_html_e('Last Year', 'wp-meta-seo-addon') ?></option>
            </select>
        </div>

        <div class="gsc_keywords_type wpms_left" style="width: 7%">
            <div class="filter-row-wrapper-field">
                <i class="material-icons filter-row">filter_list</i>
                <div class="wpms-popup" id="filter-row-list">
                    <ul>
                        <li>
                            <input type="checkbox" name="filter-row-name" value="4" id="filter-row1" class="filter-row-checkbox"/>
                            <label for="filter-row1"><?php esc_html_e('CTR', 'wp-meta-seo-addon') ?></label>
                        </li>
                        <li>
                            <input type="checkbox" name="filter-row-name" value="5" id="filter-row2" class="filter-row-checkbox"/>
                            <label for="filter-row2"><?php esc_html_e('Position', 'wp-meta-seo-addon') ?></>
                        </li>
                    </ul>
                </div>
            </div>

        </div>
    </div>
    <div class="clear"></div>

    <table class="wp-list-table widefat fixed striped posts" id="gsc_keywords_table">
        <thead>
        <tr>
            <th scope="col"
                class="manage-column column-keyword column-primary" style="width: 75%">
                <label class="gsc-sort-by" data-sort="keys" data-order=""><?php esc_html_e('Keywords', 'wp-meta-seo-addon') ?></label></th>
            <th scope="col" class="manage-column column-click column-primary" style="width: 15%">
                <label class="gsc-sort-by" data-sort="clicks" data-order=""><?php esc_html_e('Click', 'wp-meta-seo-addon') ?></label></th>
            <th scope="col" class="manage-column column-impressions column-primary" style="width: 15%">
                <label class="gsc-sort-by" data-sort="impressions" data-order=""><?php esc_html_e('Impressions', 'wp-meta-seo-addon') ?></label>
            </th>
            <th scope="col" class="manage-column column-ctr column-primary" style="width: 15%">
                <label class="gsc-sort-by" data-sort="ctr" data-order=""><?php esc_html_e('CTR', 'wp-meta-seo-addon') ?></label></th>
            <th scope="col" class="manage-column column-position column-primary" style="width: 15%">
                <label class="gsc-sort-by" data-sort="position" data-order=""><?php esc_html_e('Position', 'wp-meta-seo-addon') ?></label></th>
        </tr>
        </thead>

        <tbody id="the-list" class="wpms_list_gsc_keywords">
        <?php
        $i     = 1;
        $limit = 20;
        $cpage  = 1;
        if (!empty($results_querys['rows'])) {
            $results_query = $results_querys['rows'];
            if (!empty($results_query) && is_array($results_query)) {
                foreach ($results_query as $k => $query) {
                    if (isset($query['keys'][0]) && $query['keys'][0] !== '') {
                        if ($i <= $cpage * $limit) {
                            $link_search = 'https://www.google.com/search?q=' . $query['keys'][0];
                            echo '<tr>';
                            echo '<td>' . esc_html($query['keys'][0]) . '<a target="_blank" class="wpms_open_in_new"
                             href="' . esc_url($link_search) . '">
                             <i class="material-icons wpms_open_in_new_icon">trending_up</i></a></td>';
                            echo '<td>' . esc_html($query['clicks']) . '</td>';
                            echo '<td>' . esc_html($query['impressions']) . '</td>';
                            echo '<td>' . esc_html(round($query['ctr'] * 100, 2)) . '%</td>';
                            echo '<td>' . esc_html(round($query['position'], 1)) . '</td>';
                            echo '</tr>';
                            $i ++;
                        }
                    }
                }
            } else {
                echo '<tr>';
                echo '<td colspan="6">'.esc_html__('No search queries are currently indexed in the search console... Try typing custom keywords.', 'wp-meta-seo-addon').'</td>';
                echo '</tr>';
            }
        }
        ?>
        </tbody>
        <tfoot>
        <tr>
            <td colspan="6">
                <a class="wpms_load_more_keyword"
                   data-page="2"><?php esc_html_e('Load more...', 'wp-meta-seo-addon') ?></a>
            </td>
        </tr>
        </tfoot>
    </table>
</div>