"use strict";
jQuery(document).ready(function ($) {
    var wpms_dash = 0;

    tinyMCE.init({
        mode : "specific_textareas",
        editor_selector : "wpms_sendemail"   //<<<----
    });

    $('.wpms-notice-dismiss').click(function () {
        $(this).closest('.wpms-success').hide();
    });

    $('.wpmsemail_date').click(function () {
        $('.wpmsemail_date').removeClass('orange-button active');
        $(this).addClass('orange-button  active');
    });

    $('.wpmsemail_report').click(function () {
        $('.wpmsemail_report').removeClass('orange-button active');
        $(this).addClass('orange-button  active');
    });

    $('.wpmsemail_add_view').click(function(){
        var $currentdate = $('.wpmsemail_date.active');
        var $currentreport = $('.wpmsemail_report.active');
        var date_value = $currentdate.data('value');
        var date_label = $currentdate.html();
        var report_value = $currentreport.data('value');
        var report_label = $currentreport.html();

        if(typeof date_value !== "undefined" && typeof report_value !== "undefined"){
            var data = [date_value , date_label , report_value , report_label];
            jQuery.ajax({
                url: ajaxurl,
                method: 'POST',
                dataType: 'json',
                data: {
                    action: 'wpmsemail_add',
                    data: data,
                    wpms_nonce: wpms_localize.wpms_nonce
                },
                success: function () {
                    wpmsemail_reload_list();
                }
            });
        }
    });

    $('#btn_sendemail').click(function(){
        $('.wpmsemail_spinner').css('visibility','visible').show();
        wpmsDashMetatitle();
    });

    $('#showEmailSend').change(function(){
        var listemail = $(this).val();
        jQuery.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpmsemail_check_email',
                listemail: listemail,
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function (response) {
                $('.checkemail_msg').remove();
                if(!response.status){
                    $('#btn_save_report').hide();
                    $('#showEmailSend').closest('label').append('<span class="checkemail_msg">' + response.message + '</span>');
                }else{
                    $('#btn_save_report').show();
                }
            }
        });
    });

    $('#showEmailFrequency').change(function(){
        var value = $(this).val();
        if(parseInt(value) === 0){
            $('#numberFrequency').prop('disabled',true);
        }else{
            $('#numberFrequency').prop('disabled',false);
        }
    });



    /* ajax save meta title */
    function wpmsDashMetatitle(){
        jQuery.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpms',
                task: 'dash_metatitle',
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function () {
                wpms_dash++;
                if(wpms_dash === 1){
                    wpmsDashImgsmeta(1,0,0,0);
                }
            }
        });
    }

    /* ajax save images meta */
    function wpmsDashImgsmeta(page,imgs_statis,imgs_meta,imgs_count){
        $.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpms',
                task: 'dash_imgsmeta',
                page : page,
                imgs_statis : imgs_statis,
                imgs_metas_statis : imgs_meta,
                imgs_count : imgs_count,
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function (res) {
                if(typeof res.status === "undefined"){
                    wpmsDashImgsmeta(page+1 , res.imgs_statis[0] , res.imgs_metas_statis[0] , res.imgs_count);
                }else{
                    wpms_dash++;
                    if(wpms_dash === 2){
                        wpmsDashNewcontent();
                    }
                }
            }
        });
    }

    /* ajax save new content updated */
    function wpmsDashNewcontent(){
        jQuery.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpms',
                task: 'dash_newcontent',
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function () {
                wpms_dash++;
                if(wpms_dash === 3){
                    wpmsDashMetadesc();
                }
            }
        });
    }

    function wpmsDashMetadesc(){
        jQuery.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpms',
                task: 'dash_metadesc',
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function () {
                wpms_dash++;
                if(wpms_dash === 4){
                    wpmssendemail();
                }
            }
        });
    }

    /* Ajax send email */
    function wpmssendemail(){
        var showEmailSender = $('#showEmailSender').val();
        var showEmailTitle = $('#showEmailTitle').val();
        var numberFrequency = $('#numberFrequency').val();
        var showEmailFrequency = $('#showEmailFrequency').val();
        var showEmailSend = $('#showEmailSend').val();
        var showEmailContent = tinyMCE.get('wpms_sendemail').getContent();

        var wpms_email_meta = [];
        $('.wpms_email_meta').each(function(i,v){
            if($(this).is(':checked')){
                wpms_email_meta.push($(v).val());
            }
        });
        jQuery.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpmsemail_send',
                showEmailSender : showEmailSender,
                showEmailTitle : showEmailTitle,
                numberFrequency : numberFrequency,
                showEmailFrequency : showEmailFrequency,
                showEmailSend : showEmailSend,
                showEmailContent : showEmailContent,
                wpms_email_meta : wpms_email_meta.join(),
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function (response) {
                wpms_dash = 0;
                if(response.status){
                    $('.sendemail_msg_success').html(response.message).fadeIn(1000).delay(200).fadeOut(3000);
                }else{
                    $('.sendemail_msg_error').html(response.message).fadeIn(1000).delay(200).fadeOut(3000);
                }
                $('.wpmsemail_spinner').hide();
            }
        });
    }

    wpmsemail_event();
    /* some event */
    function wpmsemail_event() {
        $('.wpmsemail_remove_list').click(function () {
            var value = $(this).closest('p').data('value');
            jQuery.ajax({
                url: ajaxurl,
                method: 'POST',
                dataType: 'json',
                data: {
                    action: 'wpmsemail_remove_list',
                    value: value,
                    wpms_nonce: wpms_localize.wpms_nonce
                },
                success: function () {
                    wpmsemail_reload_list();
                }
            });
        });
    }

    /* reload google analytics data to include in report */
    function wpmsemail_reload_list() {
        jQuery.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'wpmsemail_reload_list',
                wpms_nonce: wpms_localize.wpms_nonce
            },
            success: function (response) {
                $('.list_add_ga').html(null);
                $.each(response,function(i,v){
                    var value = v[0] + '-' + v[2];
                    var label = 'View: '+ v[1] + ' / ' + v[3];
                    $('.list_add_ga').append('<p class="row_list_ga" data-value="'+ value +'">'+ label +'<span class="wpmsemail_remove_list dashicons dashicons-no-alt"></span></p>');
                });
                wpmsemail_event();
            }
        });
    }

    jQuery('.ju-setting-label').qtip({
        content: {
            attr: 'data-alt'
        },
        position: {
            my: 'bottom center',
            at: 'center center'
        },
        style: {
            tip: {
                corner: true
            },
            classes: 'metaseo-qtip qtip-rounded'
        },
        show: 'hover',
        hide: {
            fixed: true,
            delay: 10
        }

    });
});
