(function ($) {
    $(document).ready(function () {
        var list_links = [];
        $('.wpms_run_linkcheck').magnificPopup({
            type:'inline',
            midClick: true // Allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source in href.
        });

        $('.wpms_run_linkcheck').on('click', function () {
            $('.wpms_list_links_sitemap').html('');
            wpms_run_linkcheck(1, 0);
        });

        var wpms_run_linkcheck = function (page, subpage) {
            $('.sitemap-link-process').show().addClass('scaning');
            $('.wpms_table_linkchecker, .link-check-msg').hide();
            var datas = {
                action: 'wpms_run_linkcheck',
                page:page,
                subpage: subpage,
                wpms_nonce: wpms_localize.wpms_nonce
            };

            $.ajax({
                url: ajaxurl,
                method: 'POST',
                dataType: 'json',
                data: datas,
                success: function (res) {
                    if(res.status){
                        $('.sitemap-link-process').hide().removeClass('scaning');
                        $('.sitemap-link-process .wpms_process').data('w', 0).html('<span>0%</span>').css('width', '0%');
                        $('.links-sitemap-nav').remove();
                        $('.wpms_table_linkchecker').show().append(res.html);
                        $('.wpms_linkcheck_page').on('click',function () {
                            var thispage = $(this).data('page');
                            $('.wpms-current-page-linkcheck').val(thispage);
                            $('.wpms_list_links_sitemap').html('');
                            wpms_run_linkcheck(thispage, (thispage - 1)*20);
                        });

                        $('.wpms-current-page-linkcheck').on('change',function () {
                            var thispage = $(this).val();
                            $('.wpms_list_links_sitemap').html('');
                            wpms_run_linkcheck(thispage, (thispage - 1)*20);
                        });

                        $(".wpmseotab table").tablesorter({debug: true , cssAsc: "headerSortUp" , cssDesc: "headerSortDown" , cssHeader: "header"})
                        // Open qtip
                        jQuery('.wpms-icon-tooltip').qtip({
                            content: {
                                attr: 'data-alt'
                            },
                            position: {
                                my: 'bottom center',
                                at: 'center center'
                            },
                            style: {
                                tip: {
                                    corner: true
                                },
                                classes: 'metaseo-qtip qtip-rounded'
                            },
                            show: 'hover',
                            hide: {
                                fixed: true,
                                delay: 10
                            }
                        });
                    } else {
                        if (res.msg) {
                            $('.link-check-msg').show();
                            $('.sitemap-link-process').hide().removeClass('scaning');
                            return;
                        }
                        $.each(res.urls, function (i, v) {
                            var lastmod = v.lastmod;
                            var status = v.status;
                            var start  = lastmod.substr(0, 10);
                            var end  = lastmod.substr(11, 5);

                            var type = $('.wpms_sitemap_input_link.checked[value="'+v.url+'"]').first().data('type');
                            if(type === 'menu'){
                                var source = 'Menu';
                            }else if(type === 'post'){
                                source = 'Post';
                            }else if(type === 'page'){
                                source = 'Page';
                            }else if(type === 'custom_post'){
                                source = 'Custom post type';
                            }else if(type === 'custom_url'){
                                source = 'Custom Url';
                            }else{
                                source = 'Other';
                            }

                            var html = '<tr class="wpms_row_sitemap_link" data-url="'+ v.url +'">';
                            html += '<td><a target="_blank" href="'+ v.url +'">'+ v.url +'</a></td>';
                            html += '<td class="wpms_sitemap_linkchecker_source">'+source+'</td>';
                            html += '<td>'+ start +' ' + end + '</td>';
                            html += '<td>'+v.changefreq+'</td>';
                            html += '<td>'+v.priority+'</td>';
                            if (status.indexOf('200 OK') !== '-1') {
                                html += '<td><i class="material-icons wpms-icon-tooltip wpms_ok" data-alt="'+status+'">done</i></td>';
                            } else {
                                html += '<td><i class="material-icons wpms-icon-tooltip wpms_warning" data-alt="'+status+'">warning</i></td>';
                            }
                            html += '</tr>';
                            console.log(html);
                            console.log($('.wpms_list_links_sitemap'));
                            $('.wpms_list_links_sitemap').append(html);
                        });
                        var wpms_process = jQuery('.sitemap-link-process .wpms_process').data('w');
                        var wpms_process_new = parseFloat(wpms_process) + parseFloat(res.percent);
                        if (wpms_process_new > 100)
                            wpms_process_new = 100;
                        jQuery('.sitemap-link-process .wpms_process').data('w', wpms_process_new).html('<span>' + parseInt(wpms_process_new) + '%</span>').css('width', wpms_process_new + '%').show();

                        //
                        wpms_run_linkcheck(page, parseInt(subpage + 1));
                    }
                }
            });
        };
    });
}(jQuery));