<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class MetaSeoAddonSite
 * Class that holds most of the frontend functionality for Meta SEO Addon.
 */
class MetaSeoAddonSite
{
    /**
     * MetaSeoAddonSite constructor.
     */
    public function __construct()
    {
        add_action('wp_footer', array($this, 'loadSchema'), 1);
    }

    /**
     * Get json encode
     *
     * @param array $data Data list
     *
     * @return null|string
     */
    public function getJsonEncode($data = array())
    {
        $html = null;
        if (!empty($data) && is_array($data)) {
            $html .= '<script type="application/ld+json">';
            // phpcs:ignore PHPCompatibility.Constants.NewConstants.json_pretty_printFound, PHPCompatibility.Constants.NewConstants.json_unescaped_slashesFound -- Wrong business structure data
            $html .= json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
            $html .= '</script>';
        }

        return $html;
    }

    /**
     * Sanitize outPut
     *
     * @param string $value Value
     * @param string $type  Element type
     *
     * @return mixed|null|string
     */
    public function sanitizeOutPut($value, $type = 'text')
    {
        $newValue = null;
        if ($value) {
            if ($type === 'text') {
                $newValue = esc_html(stripslashes($value));
            } elseif ($type === 'url') {
                $newValue = esc_url(stripslashes($value));
            } elseif ($type === 'textarea') {
                $newValue = esc_textarea(stripslashes($value));
            } else {
                $newValue = esc_html(stripslashes($value));
            }
        }

        return $newValue;
    }

    /**
     * Load local business
     *
     * @return void
     */
    public function loadSchema()
    {
        $html = null;
        // get all local business settings
        $opts = array(
            'enable'     => 0,
            'logo'       => '',
            'type_name'  => '',
            'country'    => '',
            'address'    => '',
            'city'       => '',
            'state'      => '',
            'phone'      => '',
            'site_image' => '',
            'pricerange' => '$$'
        );

        $business = get_option('wpms_local_business');
        if (is_array($business)) {
            $opts = array_merge($opts, $business);
        }

        if ((int) $opts['enable'] === 1) {
            if (is_home() || is_front_page()) {
                $metaData                    = array();
                $metaData['@context']        = 'http://schema.org/';
                $metaData['@type']           = 'WebSite';
                $metaData['url']             = get_home_url();
                $metaData['potentialAction'] = array(
                    '@type'       => 'SearchAction',
                    'target'      => get_home_url() . '/?s={query}',
                    'query-input' => 'required name=query'
                );
                $html                        .= $this->getJsonEncode($metaData);
            }
            $webMeta             = array();
            $webMeta['@context'] = 'http://schema.org';
            $siteType            = 'LocalBusiness';
            $webMeta['@type']    = $siteType;

            $imgID = absint($opts['site_image']);
            if (!empty($opts['site_image']) && $imgID) {
                $image_url        = wp_get_attachment_url($imgID);
                $webMeta['image'] = $this->sanitizeOutPut($image_url, 'url');
            } else {
                $webMeta['image'] = null;
            }

            $webMeta['priceRange'] = !empty($opts['pricerange']) ? $this->sanitizeOutPut($opts['pricerange']) : null;
            $webMeta['telephone']  = !empty($opts['phone']) ? $this->sanitizeOutPut($opts['phone']) : null;

            $sitename        = get_bloginfo('name');
            $webMeta['name'] = !empty($opts['type_name']) ? $this->sanitizeOutPut($opts['type_name']) : $sitename;

            $imgID = absint($opts['logo']);
            if (!empty($opts['logo']) && $imgID) {
                $image_url        = wp_get_attachment_url($imgID);
                $webMeta['image'] = $this->sanitizeOutPut($image_url, 'url');
            } else {
                $webMeta['image'] = null;
            }

            if (!empty($opts['web_url'])) {
                $webMeta['url'] = $this->sanitizeOutPut($opts['web_url'], 'url');
            } else {
                $webMeta['url'] = $this->sanitizeOutPut(get_home_url(), 'url');
            }

            if (!empty($opts['social']) && is_array($opts['social'])) {
                $link = array();
                foreach ($opts['social'] as $socialD) {
                    if ($socialD['link']) {
                        $link[] = $socialD['link'];
                    }
                }
                if (!empty($link)) {
                    $webMeta['sameAs'] = $link;
                }
            }

            $webMeta['address'] = array(
                '@type'           => 'PostalAddress',
                'addressCountry'  => !empty($opts['country']) ? $this->sanitizeOutPut($opts['country']) : null,
                'addressLocality' => !empty($opts['city']) ? $this->sanitizeOutPut($opts['city']) : null,
                'addressRegion'   => !empty($opts['state']) ? $this->sanitizeOutPut($opts['state']) : null,
                'streetAddress'   => !empty($opts['address']) ? $this->sanitizeOutPut($opts['address']) : null
            );

            if ($webMeta['@type']) {
                $html .= $this->getJsonEncode($webMeta);
            }

            // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in the method sanitizeOutPut
            echo $html;
        }
    }
}
