<?php
/**
 * Prohibit direct script loading
 */
defined('ABSPATH') || die('No direct script access allowed!');

/*
 * class Wpms_Api_Google
 */

class Wpms_Api_Google
{

    /**
     * Loaded google api class
     */
    public function __construct()
    {
        spl_autoload_register(array($this, 'autoload_api_google_files'));
    }

    /**
     * Autoload the API Google class
     */
    private function autoload_api_google_files($class_name)
    {
        $path        = dirname(__FILE__);
        $class_name  = strtolower($class_name);
        $oauth_files = array(
            'wpms_google_client'             => 'google/Google_Client',
            'wpms_google_collection'         => 'google/Collection',
            'wpms_api_google_client'         => 'class-api-google-client',
            'wpms_google_auth'               => 'google/auth/Google_Auth',
            'wpms_google_assertion'          => 'google/auth/Google_AssertionCredentials',
            'wpms_google_signer'             => 'google/auth/Google_Signer',
            'wpms_google_p12signer'          => 'google/auth/Google_P12Signer',
            'wpms_google_authnone'           => 'google/auth/Google_AuthNone',
            'wpms_google_oauth2'             => 'google/auth/Google_OAuth2',
            'wpms_google_verifier'           => 'google/auth/Google_Verifier',
            'wpms_google_loginticket'        => 'google/auth/Google_LoginTicket',
            'wpms_google_pemverifier'        => 'google/auth/Google_PemVerifier',
            'wpms_google_model'              => 'google/service/Google_Model',
            'wpms_google_service'            => 'google/service/Google_Service',
            'wpms_google_service_webmasters' => 'google/service/Google_Service_Webmasters',
            'wpms_google_serviceresource'    => 'google/service/Google_ServiceResource',
            'wpms_google_utils'              => 'google/service/Google_Utils',
            'wpms_google_batchrequest'       => 'google/service/Google_BatchRequest',
            'wpms_google_mediafileupload'    => 'google/service/Google_MediaFileUpload',
            'wpms_google_uritemplate'        => 'google/external/URITemplateParser',
            'wpms_google_cache'              => 'google/cache/Google_Cache',
            'wpms_google_cacheparser'        => 'google/io/Google_CacheParser',
            'wpms_google_io'                 => 'google/io/Google_IO',
            'wpms_google_httprequest'        => 'google/io/Google_HttpRequest',
            'wpms_google_rest'               => 'google/io/Google_REST',
            'wpms_google_wpio'               => 'google/io/Google_WPIO',
            'wpms_google_wpcache'            => 'google/cache/Google_WPCache'
        );

        if (!empty($oauth_files[$class_name])) {
            if (file_exists($path . '/' . $oauth_files[$class_name] . '.php')) {
                require_once($path . '/' . $oauth_files[$class_name] . '.php');
            }
        }
    }
}
