<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div id="menu_custom_url" class="wpms_source wpms_source_customUrl content-box">
    <h1 class="h1_top"><?php esc_html_e('Custom URL', 'wp-meta-seo-addon') ?></h1>
    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left" data-alt="<?php echo esc_attr('All the custom URLs list block title, in HTML sitemap', 'wp-meta-seo-addon') ?>">
                <?php esc_html_e('Custom URLs block title', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <input type="text" class="wpms-large-input wpms_width_100 public_name_customUrl"
                           value="<?php echo esc_attr($sitemap->settings_sitemap['wpms_public_name_customUrl']) ?>">
                </label>
            </p>
        </div>
    </div>

    <div class="ju-settings-option wpms_xmp_custom_column">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left" data-alt="<?php echo esc_attr('Column selection if you’re using the HTML sitemap', 'wp-meta-seo-addon') ?>">
                <?php esc_html_e('HTML Sitemap column', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <select class="wpms_display_column wpms_display_column_customUrl wpms-large-input wpms_width_100">
                        <?php
                        for ($i = 1; $i <= $sitemap->settings_sitemap['wpms_html_sitemap_column']; $i ++) {
                            if ((int) $sitemap->settings_sitemap['wpms_display_column_customUrl'] === (int) $i) {
                                echo '<option selected value="' . esc_attr($i) . '">' . esc_html($sitemap->columns[$i]) . '</option>';
                            } else {
                                echo '<option value="' . esc_attr($i) . '">' . esc_html($sitemap->columns[$i]) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </label>
            </p>
        </div>
    </div>

    <div class="ju-settings-option wpms_xmp_order">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left">
                <?php esc_html_e('Order', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <select class="wpms_display_order_urls wpms-large-input wpms_width_100">
                        <?php
                        for ($i = 1; $i <= 4; $i ++) {
                            if ((int) $sitemap->settings_sitemap['wpms_display_order_urls'] === (int) $i) {
                                echo '<option selected value="' . esc_attr($i) . '">' . esc_html($i) . '</option>';
                            } else {
                                echo '<option value="' . esc_attr($i) . '">' . esc_html($i) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </label>
            </p>
        </div>
    </div>

    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left">
                <?php esc_html_e('URL', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <input name="custom_url_link" type="text" id="custom_url_link" value="" class="wpms-large-input wpms_width_100">
                </label>
            </p>
        </div>
    </div>

    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left">
                <?php esc_html_e('Title', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <input name="custom_url_title" type="text" id="custom_url_title" value="" class="wpms-large-input wpms_width_100">
                </label>
            </p>
        </div>
    </div>

    <div class="wpms_width_100 wpms_left m-tb-20">
        <button type="button" class="wpms_add_customurl orange-button ju-button wpms-no-background"><?php esc_html_e('Add', 'wp-meta-seo-addon') ?></button>
        <span class="spinner wpms_customurl_spinner"></span>
        <span class="message_saved"><?php esc_html_e('Saved', 'wp-meta-seo-addon') ?></span>
    </div>

    <div id="wrap_sitemap_option_customUrl" class="wrap_sitemap_option">
        <?php
        $customUrls = get_option('wpms_customUrls_list');
        if (!empty($customUrls)) {
            foreach ($customUrls as $key => $customUrl) {
                if (empty($sitemap->settings_sitemap['wpms_sitemap_customUrl'][$key]['frequency'])) {
                    $pagefrequency = 'monthly';
                } else {
                    $pagefrequency = $sitemap->settings_sitemap['wpms_sitemap_customUrl'][$key]['frequency'];
                }
                if (empty($sitemap->settings_sitemap['wpms_sitemap_customUrl'][$key]['priority'])) {
                    $pagepriority = '1.0';
                } else {
                    $pagepriority = $sitemap->settings_sitemap['wpms_sitemap_customUrl'][$key]['priority'];
                }
                $slpr = $sitemap->viewPriority(
                    'priority_customUrl_' . $key,
                    '_metaseo_settings_sitemap[wpms_sitemap_customUrl][' . $key . '][priority]',
                    $pagepriority
                );
                $slfr = $sitemap->viewFrequency(
                    'frequency_customUrl_' . $key,
                    '_metaseo_settings_sitemap[wpms_sitemap_customUrl][' . $key . '][frequency]',
                    $pagefrequency
                );
                echo '<div class="wpms_row wpms_row_record" data-id="' . esc_attr($key) . '">';
                echo '<div>';
                if (isset($customUrl['title']) && $customUrl['title'] !== '') {
                    $link_title = '<a target="_blank" class="wpms-text" href="' . esc_attr($customUrl['link']) . '">' . esc_html($customUrl['title']) . '</a>';
                } else {
                    $link_title = '<a target="_blank" class="wpms-text" href="' . esc_attr($customUrl['link']) . '">' . esc_html($customUrl['link']) . '</a>';
                }

                if (isset($sitemap->settings_sitemap['wpms_sitemap_customUrl'][$key]['customUrl_id'])
                    && (int) $sitemap->settings_sitemap['wpms_sitemap_customUrl'][$key]['customUrl_id'] === (int) $key) {
                    echo '<input class="wpms_sitemap_input_link checked" type="hidden"
                     data-type="custom_url" value="' . esc_attr($customUrl['link']) . '">';
                    echo '<div class="pure-checkbox">';
                    echo '<input class="cb_sitemaps_customUrl wpms_xmap_customUrl"
                     id="' . esc_attr('wpms_sitemap_customUrl' . $key) . '" type="checkbox"
                      name="' . esc_attr('_metaseo_settings_sitemap[wpms_sitemap_customUrl][' . $key . '][customUrl_id]') . '"
                       value="' . esc_attr($key) . '" checked>';
                    // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in previous line (same file)
                    echo '<label for="wpms_sitemap_customUrl' . esc_attr($key) . '" class="wpms-text ju-setting-label">' . $link_title . '</label>';
                    echo '</div>';
                } else {
                    echo '<input class="wpms_sitemap_input_link" type="hidden" data-type="custom_url"
                     value="' . esc_attr($customUrl['link']) . '">';
                    echo '<div class="pure-checkbox">';
                    echo '<input class="cb_sitemaps_customUrl wpms_xmap_customUrl"
                     id="' . esc_attr('wpms_sitemap_customUrl' . $key) . '" type="checkbox"
                      name="' . esc_attr('_metaseo_settings_sitemap[wpms_sitemap_customUrl][' . $key . '][customUrl_id]') . '"
                       value="' . esc_attr($key) . '">';
                    // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in previous line (same file)
                    echo '<label for="' . esc_attr('wpms_sitemap_customUrl' . $key) . '" class="wpms-text ju-setting-label">' . $link_title . '</label>';
                    echo '</div>';
                }
                echo '<div class="wpms_right">';
                // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in the method MetaSeoSitemap::viewPriority and MetaSeoSitemap::viewFrequency
                echo $slpr . $slfr;
                echo '<i class="material-icons wpms_clear_customUrl">clear</i></div>';
                echo '</div>';
                echo '</div>';
            }
        }
        ?>
    </div>
    <div class="holder holder_custom_url"></div>
</div>