<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div id="menu_source_<?php echo esc_html($post_type) ?>"
     class="<?php echo esc_attr('wpms_source content-box wpms_source_' . $post_type) ?>"
     >
    <h1 class="h1_top"><?php echo esc_html($post_type) ?></h1>
    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text" data-alt="<?php echo esc_attr('Include all elements in the sitemap', 'wp-meta-seo-addon') ?>">
                <?php esc_html_e('Check all posts', 'wp-meta-seo-addon') ?>
            </label>
            <div class="ju-switch-button">
                <label class="switch">
                    <input type="checkbox" class="sitemap_check_all" data-type="<?php echo esc_attr($post_type) ?>"
                           id="<?php echo esc_attr('wpms_check_all_' . $post_type) ?>"
                           value="1">
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
    </div>

    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text">
                <?php esc_html_e('Check all posts in current page', 'wp-meta-seo-addon') ?>
            </label>
            <div class="ju-switch-button">
                <label class="switch">
                    <input type="checkbox" class="sitemap_check_all_posts_in_page" data-type="<?php echo esc_attr($post_type) ?>"
                           id="<?php echo esc_attr('wpms_check_all_posts_in_page_' . $post_type) ?>"
                           value="1">
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
    </div>

    <div class="ju-settings-option">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left">
                <?php esc_html_e('Public name', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <input type="text" class="<?php echo esc_attr('wpms-large-input wpms_width_100 public_name_' . $post_type) ?>"
                           value="<?php echo esc_attr($sitemap->settings_sitemap['wpms_public_name_' . $post_type]) ?>">
                </label>
            </p>
        </div>
    </div>

    <div class="ju-settings-option wpms_xmp_custom_column">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left" data-alt="<?php echo esc_attr('Column selection if you’re using the HTML sitemap', 'wp-meta-seo-addon') ?>">
                <?php esc_html_e('HTML Sitemap column', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <select class="<?php echo esc_attr('wpms-large-input wpms_width_100 wpms_display_column wpms_display_column_' . $post_type) ?>">
                        <?php
                        for ($i = 1; $i <= $sitemap->settings_sitemap['wpms_html_sitemap_column']; $i ++) {
                            if ((int) $sitemap->settings_sitemap['wpms_display_column_' . $post_type] === (int) $i) {
                                echo '<option selected value="' . esc_attr($i) . '">' . esc_html($sitemap->columns[$i]) . '</option>';
                            } else {
                                echo '<option value="' . esc_attr($i) . '">' . esc_html($sitemap->columns[$i]) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </label>
            </p>
        </div>
    </div>

    <div class="ju-settings-option wpms_xmp_order">
        <div class="wpms_row_full">
            <label class="ju-setting-label text wpms_width_100 wpms_left">
                <?php esc_html_e('Order', 'wp-meta-seo-addon') ?>
            </label>
            <p class="p-d-20">
                <label>
                    <select class="wpms_display_order_posts wpms-large-input wpms_width_100">
                        <?php
                        for ($i = 1; $i <= 4; $i ++) {
                            if ((int) $sitemap->settings_sitemap['wpms_display_order_posts'] === (int) $i) {
                                echo '<option selected value="' . esc_attr($i) . '">' . esc_html($i) . '</option>';
                            } else {
                                echo '<option value="' . esc_attr($i) . '">' . esc_html($i) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </label>
            </p>
        </div>
    </div>

    <div id="<?php echo esc_attr('wrap_sitemap_option_' . $post_type) ?>" class="wrap_sitemap_option">
        <?php
        $listposts = $sitemap->getPostsCustom($post_type);
        foreach ($listposts as $value) {
            if (in_array($value->cat_ID, $sitemap->settings_sitemap['wpms_category_link'])) {
                $checked = 'checked';
            } else {
                $checked = '';
            }

            ?>
            <div class="wpms_row_full" style="margin-top: 30px">
                <div class="ju-settings-option wpms_row">
                    <div class="wpms_row_full">
                        <label class="ju-setting-label text">
                            <?php esc_html_e('Select all', 'wp-meta-seo-addon') ?>
                        </label>
                        <div class="ju-switch-button">
                            <label class="switch">
                                <input class="xm_cb_all" data-category="<?php echo esc_attr($value->taxo . $value->slug) ?>"
                                       id="<?php echo esc_attr('xm_cb_all' . $post_type . $value->slug) ?>" type="checkbox">
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <?php

            foreach ($value->results as $p) {
                $category = get_the_terms($p, $value->taxo);
                if ((int) $category[0]->term_id === (int) $value->cat_ID) {
                    if (empty($sitemap->settings_sitemap['wpms_sitemap_' . $post_type][$p->ID]['frequency'])) {
                        $fr = 'monthly';
                    } else {
                        $fr = $sitemap->settings_sitemap['wpms_sitemap_' . $post_type][$p->ID]['frequency'];
                    }
                    if (empty($sitemap->settings_sitemap['wpms_sitemap_' . $post_type][$p->ID]['priority'])) {
                        $pr = '1.0';
                    } else {
                        $pr = $sitemap->settings_sitemap['wpms_sitemap_' . $post_type][$p->ID]['priority'];
                    }
                    $slpr      = $sitemap->viewPriority(
                        'priority_' . $post_type . '_' . $p->ID,
                        '_metaseo_settings_sitemap[wpms_sitemap_' . $post_type . '][' . $p->ID . '][priority]',
                        $pr
                    );
                    $slfr      = $sitemap->viewFrequency(
                        'frequency_' . $post_type . '_' . $p->ID,
                        '_metaseo_settings_sitemap[wpms_sitemap_' . $post_type . '][' . $p->ID . '][frequency]',
                        $fr
                    );
                    $permalink = get_permalink($p->ID);
                    echo '<div class="wpms_row wpms_row_record">';
                    echo '<div style="float:left;line-height:30px">';
                    if (isset($sitemap->settings_sitemap['wpms_sitemap_' . $post_type][$p->ID]['post_id'])
                        && (int) $sitemap->settings_sitemap['wpms_sitemap_' . $post_type][$p->ID]['post_id'] === (int) $p->ID) {
                        echo '<input class="wpms_sitemap_input_link checked" type="hidden"
                         data-type="custom_post" value="' . esc_attr($permalink) . '">';
                        echo '<div class="pure-checkbox">';
                        echo '<input type="checkbox" id="' . esc_attr('cb_sitemaps_' . $post_type . $p->ID) . '"
                         class="' . esc_attr('cb_sitemaps_' . $post_type . ' wpms_xmap_' . $post_type . ' ' . $value->taxo . $value->slug) . '"
                          name="' . esc_attr('_metaseo_settings_sitemap[wpms_sitemap_' . $post_type . '][' . $p->ID . '][post_id]') . '"
                           value="' . esc_attr($p->ID) . '" data-category="' . esc_attr($value->cat_ID) . '" checked>';
                        echo '<label for="' . esc_attr('cb_sitemaps_' . $post_type . $p->ID) . '" class="wpms-text">' . esc_html($p->post_title) . '</label>';
                        echo '</div>';
                    } else {
                        echo '<input class="wpms_sitemap_input_link" type="hidden"
                         data-type="custom_post" value="' . esc_attr($permalink) . '">';
                        echo '<div class="pure-checkbox">';
                        echo '<input type="checkbox" id="cb_sitemaps_' . esc_attr($post_type . $p->ID) . '"
                         class="' . esc_attr('cb_sitemaps_' . $post_type . ' wpms_xmap_' . $post_type . ' ' . $value->taxo . $value->slug) . '"
                          name="' . esc_attr('_metaseo_settings_sitemap[wpms_sitemap_' . $post_type . '][' . $p->ID . '][post_id]') . '"
                           value="' . esc_attr($p->ID) . '" data-category="' . esc_attr($value->cat_ID) . '">';
                        echo '<label for="' . esc_attr('cb_sitemaps_' . $post_type . $p->ID) . '" class="wpms-text">' . esc_html($p->post_title) . '</label>';
                        echo '</div>';
                    }

                    echo '</div>';
                    // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in the method MetaSeoSitemap::viewPriority and MetaSeoSitemap::viewFrequency
                    echo '<div class="wpms_right">' . $slpr . $slfr . '</div>';
                    echo '</div>';
                }
            }
        }
        ?>
    </div>
    <div class="holder holder_<?php echo esc_attr($post_type) ?>"></div>
</div>