<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<li>
    <div class="collapsible-header"><?php esc_html_e('Source: posts', 'wp-meta-seo-addon') ?></div>
    <div class="collapsible-body"><span>
<?php
echo '<div id="menu_source_posts" class="wpms_sitemap_posts">';
echo '<ul>';

//Categories
$ids = array(0);
if (!empty($this->settings_sitemap['wpms_sitemap_posts'])) {
    foreach ((array) $this->settings_sitemap['wpms_sitemap_posts'] as $k => $v) {
        if (!empty($v['post_id'])) {
            $ids[] = $k;
        }
    }
}

$arr_posts = array();
$cats = get_categories(array('taxonomy' => 'category', 'hide_empty' => true));
foreach ($cats as $value) {
    if (in_array($value->cat_ID, $this->settings_sitemap['wpms_category_link'])) {
        $cat_link = '<a href="' . esc_url(get_term_link($value)) . '">' . esc_html($value->cat_name) . '</a>';
    } else {
        $cat_link = esc_html($value->cat_name);
    }

    // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in previous line (same file)
    echo '<li class="wpms_li_cate"><div class="cat_name">' . $cat_link . '</div>';
    if (!empty($this->settings_sitemap['wpms_sitemap_posts'])) {
        echo '<ul>';
        query_posts(array('post__in' => $ids, 'posts_per_page' => - 1, 'cat' => $value->cat_ID));
        while (have_posts()) {
            the_post();
            if ((get_post_meta(get_the_ID(), '_yoast_wpseo_meta-robots-noindex', true) === '1'
                 && get_post_meta(get_the_ID(), '_yoast_wpseo_sitemap-include', true) !== 'always')
                || (get_post_meta(get_the_ID(), '_yoast_wpseo_sitemap-include', true) === 'never')
                || (get_post_meta(get_the_ID(), '_yoast_wpms_redirect', true) !== '')) {
                continue;
            }

            $category = get_the_category();
            // Only display a post link once, even if it's in multiple categories
            if ((int) $category[0]->cat_ID === (int) $value->cat_ID) {
                //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Get wordpress title
                echo '<li><a href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a></li>';
            }
        }
        wp_reset_query();
        echo '</ul>';
    }
    echo '</li>';
}
echo '</ul></div>';
echo '<div class="holder holder_sitemaps_posts"></div>';


if (is_plugin_active(WPMSEO_ADDON_FILENAME)) {
    $custom_post_types = get_post_types(array('public' => true, 'exclude_from_search' => false, '_builtin' => false));
    if (!empty($custom_post_types)) {
        foreach ($custom_post_types as $post_types => $label) {
            //=====================================================================================
            if (isset($this->settings_sitemap['wpms_public_name_' . $post_types])
                && $this->settings_sitemap['wpms_public_name_' . $post_types] !== '') {
                $postTitle = $this->settings_sitemap['wpms_public_name_' . $post_types];
            } else {
                $postTitle = get_post_type_object($post_types);
                $postTitle = $postTitle->label;
            }

            echo '<div id="sitemap_posts" class="wpms_sitemap_posts"><h4>';
            echo esc_html($postTitle);
            echo '</h4><ul>';

            global $wpdb;
            $taxonomy_objects = get_object_taxonomies($post_types, 'names');
            $ids              = array(0);
            if (!empty($this->settings_sitemap['wpms_sitemap_' . $post_types])) {
                foreach ((array) $this->settings_sitemap['wpms_sitemap_' . $post_types] as $k => $v) {
                    if (!empty($v['post_id'])) {
                        $ids[] = $k;
                    }
                }
            }
            $list_links = array();
            if (!empty($taxonomy_objects)) {
                foreach ($taxonomy_objects as $taxo) {
                    $categorys = get_categories(array('hide_empty' => true, 'taxonomy' => $taxo));
                    foreach ($categorys as $cate) {
                        $results = $wpdb->get_results($wpdb->prepare('SELECT p.ID as ID,p.post_title as post_title   
FROM ' . $wpdb->posts . ' AS p
INNER JOIN ' . $wpdb->term_relationships . ' AS tr ON (p.ID = tr.object_id)
INNER JOIN ' . $wpdb->term_taxonomy . ' AS tt ON (tr.term_taxonomy_id = tt.term_taxonomy_id)
INNER JOIN ' . $wpdb->terms . ' AS t ON (t.term_id = tt.term_id)
WHERE   p.post_status = %s 
    AND p.post_type = %s
    AND tt.taxonomy = %s AND t.slug = %s AND ID IN (' . implode(',', esc_sql($ids)) . ')   
ORDER BY p.post_date DESC', array('publish', $post_types, $taxo, $cate->slug)));
                        if (!empty($results)) {
                            if (in_array($cate->cat_ID, $this->settings_sitemap['wpms_category_link'])) {
                                $cat_link = '<a href="' . esc_url(get_term_link($cate)) . '">' . esc_html($cate->cat_name) . '</a>';
                            } else {
                                $cat_link = esc_html($cate->cat_name);
                            }
                            // phpcs:ignore WordPress.Security.EscapeOutput -- Content escaped in previous line (same file)
                            echo '<li class="wpms_li_cate"><div class="cat_name">' . $cat_link . '</div>';

                            if (!empty($this->settings_sitemap['wpms_sitemap_' . $post_types])) {
                                echo '<ul>';
                                foreach ($results as $p) {
                                    $k = $cate->cat_ID . '-' . $p->ID;
                                    if (isset($this->settings_sitemap['wpms_sitemap_' . $post_types][$k])) {
                                        $perlink = get_permalink($p->ID);
                                        if (!in_array($perlink, $list_links)) {
                                            $list_links[] = $perlink;
                                            echo '<li><a href="' . esc_url($perlink) . '">' . esc_html($p->post_title) . '</a></li>';
                                        }
                                    }
                                }
                                echo '</ul>';
                            }
                            echo '</li>';
                        }
                    }
                }
            } else {
                $results = $wpdb->get_results($wpdb->prepare('SELECT ID, post_title FROM ' . $wpdb->posts . ' WHERE   post_status = %s AND post_type = %s AND ID IN (' . implode(',', esc_sql($ids)) . ') ORDER BY post_date DESC', array('publish', $post_types)));
                if (!empty($results)) {
                    if (!empty($this->settings_sitemap['wpms_sitemap_' . $post_types])) {
                        echo '<ul>';
                        foreach ($results as $p) {
                            $perlink = get_permalink($p->ID);
                            if (!in_array($perlink, $list_links)) {
                                $list_links[] = $perlink;
                                echo '<li><a href="' . esc_url($perlink) . '">' . esc_html($p->post_title) . '</a></li>';
                            }
                        }
                        echo '</ul>';
                    }
                }
            }

            echo '</ul></div>';

            //======================================================================================
        }
    }
}
?>
</span></div>
</li>
