<?php
/*
Ad Overlay Anything - PHP version
License: http://codecanyon.net/licenses/faq
Any attempt to redistribute or resell will be considered a breach of this license.

Be sure to include javaScript and CSS files in your file before using this function. Example:

<script src="http://www.google.com/jsapi" type="text/javascript"></script>
<script type="text/javascript">google.load("jquery", "1.3.2");</script>
<script type='text/javascript' src='http://www.yoursite.com/ad-overlay-anything/js/aoa-functions.js?ver=4.4.1'></script>
<link href='http://www.yoursite.com/ad-overlay-anything/css/style.css' rel='stylesheet' type='text/css'/>

*/

////////////////////////////////////////////////////////////////////////////////////////////

function aoa_wrap( $ad = array(), $wrap = null )
{
		if ( ! is_array( $ad ) ) return $wrap;
		if ( empty( $ad['content'] ) ) return $wrap;
		if ( isset( $ad['percent'] ) && $ad['percent'] < 100 && mt_rand( 1, 100 ) > $ad['percent'] ) return $wrap;
		if ( isset( $_COOKIE['aoa'] ) ) return $wrap;

		if ( ! isset( $ad['class'] ) ) $ad['class'] = '';
		if ( ! isset( $ad['close'] ) ) $ad['close'] = '';

		if ( isset( $ad['cookie'] ) ) {
			setcookie( 'aoa', '1', time() + (3600 * (int)$ad['cookie']) );
		}

		$m = microtime(true);
		$unique = sprintf( "aoa%05x", ($m-floor($m))*1000000 );

		$str = "\n";

		$str .= '<div id="wrap_' . $unique . '" class="aoa_wrap ' . $ad['class'] . '">' . "\n";
		$str .= '  ' . $wrap . "\n";
		$str .= '    <div id="' . $unique . '" class="aoa_overlay">' . "\n";
		$str .= '        <div class="aoa_content">' . $ad['content'] . '</div>' . "\n";
		$str .= '        <span id="close_' . $unique . '" class="aoa_close">' . $ad['close'] . '</span>' . "\n";
		$str .= '        <a id="close_btn_' . $unique . '" class="aoa_close_btn" onclick="setVisibility(\'' . $unique . '\', \'none\');">&times;</a>' . "\n";	
		$str .= '    </div>' . "\n";
		$str .= '</div>' . "\n";
		return $str;
}

////////////////////////////////////////////////////////////////////////////////////////////
?>
