jQuery(function($) {
    var $el     = $('.gsdFastEdit')
        options = Joomla.getOptions('gsd_fastedit')
        baseURL = options.base_url + "/index.php?option=com_gsd&view=gsd&format=raw"
        thing   = options.thing_id
        plugin  = options.plugin
        $modal  = $el.find(".modal");

    // Load Items on page load only if we are editing an exiting item
    $(window).on("load", function() {
        if (thing) {
            get();
        }      
    });

    // Open Add/Edit Modal Event
    $(document).on("click", "a[href='#gsdModal']", function() {
        var isAdd = !$(this).hasClass("btn-secondary");

        // Change Modal Title
        var modalHeader = isAdd ? Joomla.JText._('GSD_ADD_SNIPPET') : Joomla.JText._('GSD_EDIT_SNIPPET');
        $modal.find(".modal-header h3").html(modalHeader);

        if (isAdd) {
            var iFrameURL = $(this).closest(".gsdFastEdit").attr('data-src') + "&contenttype=" + $(this).attr("data-contenttype");
        } else {
            var iFrameURL = $(this).attr("data-src");
        }

        // Change IFrame URL and make sure it has been fully loaded before updating the snippets list.
        $modal.find('iframe').attr('src', iFrameURL).on("load", function() {
            get();
        });
    })

    // Remove Item Event
    $(document).on("click", ".gsdRemove", function() {
        if (confirm(Joomla.JText._('NR_ARE_YOU_SURE'))) {
            remove($(this).closest("tr").data("pk"));
        }
        return false;
    })

    /**
     *  Load items
     */
    function get() {
        fetch("&plugin=" + plugin + "&thing=" + thing + "&assignment=" + options.plugin_assignment_name, function(response) {
            $el.find(".items").html(response);
        })
    }

    /**
     *  Remove an item
     */
    function remove(pk) {
        fetch("&do=delete&pk=" + pk, function() {
            get();
        })
    }

    /**
     *  AJAX Request
     *
     *  @param   String      url       The AJAX URL
     *  @param   Function    callback  The success callback function
     *
     *  @return  void
     */
    function fetch(url, callback) {
        $.ajax({ 
            url: baseURL + url,
            cache: false,
            success: function(response) {
                callback(response);
            },
            beforeSend: function() {
                $el.addClass("working");
            },
            complete: function() {
                $el.removeClass("working");
            }
        });
    }
})