<h3><?php echo esc_html( $this->valid_filters[ 'filter_custom_taxonomies' ] ); ?></h3>
<?php
if ( $this->valid_custom_taxonomies ) {
	$custom_tax_labels = $this->get_custom_taxonomies_labels();
	$args = array(
		'orderby'       => 'name', 
		'order'         => 'ASC',
		'hide_empty'    => false, 
		'hierarchical'  => true, 
	);
	foreach ( $this->valid_custom_taxonomies as $custom_tax ) {
		$options = array();
		$terms = get_terms( $custom_tax, $args );
		if ( is_wp_error( $terms ) ) {
			printf( '<p>%s<p>', $terms->get_error_message() );
			continue;
		}
		if ( 0 < count( $terms ) ) {
			foreach ( $terms as $term ) {
				$options[ $term->term_id ] = $term->name;
			}
			if ( isset( $this->selected_custom_taxonomies[ $custom_tax ] ) ) {
				$selected_tax = $this->selected_custom_taxonomies[ $custom_tax ];
			} else {
				$selected_tax = '';
			}
?>
<p>
	<label for="<?php printf( 'qfi_%s', $custom_tax ); ?>"><?php printf( esc_html__( 'Registered terms of the taxonomy &#8220;%s&#8221;', 'quick-featured-images-pro' ), $custom_tax_labels[ $custom_tax ] ); ?></label><br />
	<select id="<?php printf( 'qfi_%s', $custom_tax ); ?>" name="custom_taxonomies[<?php echo $custom_tax; ?>]">
<?php
			echo $this->get_html_empty_option();
			foreach ( $options as $key => $label ) {
				printf( '<option value="%s" %s>%s</option>', $key, selected( $selected_tax == $key, true, false ), esc_html( $label ) );
			}

?>
	</select>
</p>
<?php
		} else {
?>
<p>
<?php
			printf( esc_html__( 'There are no terms of the taxonomy &#8220;%s&#8221;.', 'quick-featured-images-pro' ), $custom_tax_labels[ $custom_tax ] );
?>
</p>
<?php
		} // if( count(terms) )
	}
?>
<h4><?php esc_html_e( 'Strange search result with custom taxonomies?', 'quick-featured-images-pro' ); ?></h4>
<p><?php esc_html_e( 'The search for custom taxonomy terms could lead to surprising results. The reason is custom taxonomies can be used in many different ways. It is not possible to catch them all in one single code expression. If you should be unsatisfied with the result try other filters to get the result you want.', 'quick-featured-images-pro' ); ?></p>
<?php
} else {
?>
<p><?php esc_html_e( 'There are no custom taxonomies.', 'quick-featured-images-pro' ); ?></p>
<?php
} // if( valid_custom_taxonomies )
