<h3><?php echo esc_html( $this->valid_filters[ 'filter_time' ] ); ?></h3>
<h4><?php esc_html_e( 'Date range', 'quick-featured-images-pro' ); ?>:</h4>
<p><?php esc_html_e( 'To define a time segment select both the start date and the end date.', 'quick-featured-images-pro' ); ?></p>
<p><?php esc_html_e( 'You can also define a time period by selecting only one date as the limiting value of the period.', 'quick-featured-images-pro' ); ?></p>
<p><?php esc_html_e( 'The listed dates are the date of the publication of stored posts.', 'quick-featured-images-pro' ); ?></p>

<div class="qfi_wrapper">
<?php 
foreach ( array( 'after', 'before' ) as $key ) { 
	$label = $this->valid_date_queries[ $key ];
?>
	<div class="qfi_w50percent">
		<p>
			<label for="<?php printf( 'qfi_%s', $key ); ?>"><?php echo esc_html( $label ); ?></label><br>
			<select id="<?php printf( 'qfi_%s', $key ); ?>" name="date_queries[<?php echo $key; ?>]">
<?php 
	echo $this->get_html_date_options( $key );
?>
			</select>
		</p>
	</div><!-- .qfi_w50percent -->
<?php 
} // foreach('after', 'before')
?>
</div><!-- .qfi_wrapper -->
<p><?php esc_html_e( 'You can limit the filter to the exact day within the months. The day options are optional and only work if a month has been selected.', 'quick-featured-images-pro' ); ?></p>
<div class="qfi_wrapper">
<?php 
foreach ( array( 'day_after', 'day_before' ) as $key ) { 
	$label = $this->valid_date_queries[ $key ];
?>
	<div class="qfi_w50percent">
		<p>
			<label for="<?php printf( 'qfi_%s', $key ); ?>"><?php echo esc_html( $label ); ?></label><br>
			<select id="<?php printf( 'qfi_%s', $key ); ?>" name="date_queries[<?php echo $key; ?>]">
<?php 
	echo $this->get_html_days_options( $key );
?>
			</select>
		</p>
	</div><!-- .qfi_w50percent -->
<?php 
} // foreach('day_after', 'day_before')
?>
</div><!-- .qfi_wrapper -->
<?php
$key = 'inclusive';
$label = $this->valid_date_queries[ $key ];
?>
<p>
	<input type="checkbox" id="<?php printf( 'qfi_%s', $key ); ?>" name="date_queries[<?php echo $key; ?>]" value="1" <?php checked( isset( $this->selected_date_queries[ $key ] ) ); ?> />
	<label for="<?php printf( 'qfi_%s', $key ); ?>"><?php echo esc_html( $label ); ?></label><br>
</p>
