<?php 
if ( ! current_theme_supports( 'post-thumbnails' ) ) {
?>
<h2><?php esc_html_e( 'Notice', 'quick-featured-images-pro' ); ?></h2>
<div class="qfi_content_inside">
	<p class="failure"><?php esc_html_e( 'The current theme does not support featured images. Anyway you can use this plugin. The effects are stored and will be visible in a theme which supports featured images.', 'quick-featured-images-pro' ); ?></p>
</div>
<?php 
}
// set translated strings
$text = 'Next &raquo;';
$next_label = __( $text );
?>
<form method="post" action="<?php echo esc_url( admin_url( sprintf( 'admin.php?page=%s&step=select', $this->page_slug ) ) ); ?>">
	<h2 class="no-bottom"><?php esc_html_e( 'What do you want to do?', 'quick-featured-images-pro' ); ?></h2>
	<div class="qfi_page_description">
		<p><?php esc_html_e( 'Here you can add, replace and delete featured images to your posts. Select one of the following actions and, if necessary, one or more images.', 'quick-featured-images-pro' ); ?></p>
		<p><?php esc_html_e( 'Whatever you select: You can refine your choice on the next page.', 'quick-featured-images-pro' ); ?></p>
	</div>
	<h3><?php esc_html_e( 'Important advice', 'quick-featured-images-pro' ); ?></h3>
	<p><strong><?php esc_html_e( 'There is no undo function! It is strongly recommended that you make a backup of the WordPress database before you perform mass changes.', 'quick-featured-images-pro' ); ?></strong></p>
	<fieldset>
		<legend class="screen-reader-text"><span><?php esc_html_e( 'Select action', 'quick-featured-images-pro' ); ?></span></legend>
		<h3><?php esc_html_e( 'Actions with a single image', 'quick-featured-images-pro' ); ?></h3>
		<p><?php esc_html_e( 'These actions require to select an image with the following button.', 'quick-featured-images-pro' ); ?></p>
<?php 
foreach ( $this->valid_actions as $name => $label ) {
?>
		<p>
			<input type="radio" id="<?php echo $name; ?>" name="action" value="<?php echo $name; ?>" <?php checked( 'assign' == $name ); ?> />
			<label for="<?php echo $name; ?>"><strong><?php echo esc_html( $label ); ?></strong></label>
		</p>
<?php
} // foeach( valid_actions )
?>
		<div class="qfi_wrapper">
			<div class="qfi_w50percent">
				<p><?php esc_html_e( 'Select the image you want to add to, replace or delete from posts and pages by clicking on the following button.', 'quick-featured-images-pro' ); ?></p>
				<p>
<?php
// default values for image element
$blank_img_url = includes_url() . 'images/blank.gif';
$img_url = $blank_img_url;
$img_class = '';
$img_style = '';
// if an image id was given
if ( $this->selected_image_id ) {
	$arr_image = wp_get_attachment_image_src( $this->selected_image_id );
	// and if there is a valid image
	if ( $arr_image ) {
		// show the image and set the id as param value
		$img_url = $arr_image[0];
		$img_class = 'attachment-thumbnail';
		$img_style = sprintf( 'width:%dpx', $this->used_thumbnail_width );
	}
}
?>
					<input type="hidden" id="image_id" name="image_id" value="<?php echo $this->selected_image_id; ?>">
					<img id="selected_image" src="<?php echo $img_url; ?>" alt="<?php $text = 'Featured Image'; echo esc_attr( _x( $text, 'post' ) ); ?>" class="<?php echo $img_class; ?>" style="<?php echo $img_style; ?>" /><br />
					<input type="button" id="upload_image_button" class="button qfi_select_image" value="<?php esc_attr_e( 'Choose Image', 'quick-featured-images-pro' ); ?>" />
				</p>
			</div>
			<div class="qfi_w50percent">
				<p><strong><?php esc_html_e( 'If the button does not work, read this:', 'quick-featured-images-pro' ); ?></strong></p>
				<p><?php esc_html_e( 'Some users reported that this button would not work in some WordPress installations. If this should be the case you can take another way:', 'quick-featured-images-pro' ); ?></p>
				<p><?php esc_html_e( '1. Go to the media library. 2. Move the mouse over the desired image. Further links are appearing, among them the link &quot;Bulk set as featured image&quot;. 3. After a click on it you can move on in this plugin.', 'quick-featured-images-pro' ); ?></p>
			</div>
		</div>

		<h3><?php esc_html_e( 'Actions with multiple images', 'quick-featured-images-pro' ); ?></h3>
		<p><?php esc_html_e( 'These actions require at least one selected image with the following button.', 'quick-featured-images-pro' ); ?></p>
<?php
foreach ( $this->valid_actions_multiple_images as $name => $label ) {
?>
		<p>
			<input type="radio" id="<?php echo $name; ?>" name="action" value="<?php echo $name; ?>" <?php checked( 'assign' == $name ); ?> />
			<label for="<?php echo $name; ?>"><strong><?php echo esc_html( $label ); ?></strong></label>
		</p>
<?php
} // foreach( valid_actions_multiple_images )
$img_ids = is_array( $this->selected_multiple_image_ids ) ? implode( ',', $this->selected_multiple_image_ids ) : '';
?>
<p><?php esc_html_e( 'To select multiple images click on the button and use the CTRL key while clicking on the images.', 'quick-featured-images-pro' ); ?></p>
<p>
	<input type="hidden" id="multiple_image_ids" name="multiple_image_ids" value="<?php echo $img_ids; ?>">
	<img id="blank_image" src="<?php echo $blank_img_url; ?>" alt="" /><br />
	<input type="button" id="select_images_multiple" class="button" value="<?php esc_attr_e( 'Choose Images', 'quick-featured-images-pro' ); ?>" />
</p>
<?php
if ( $this->selected_multiple_image_ids ) {
?>
<ul class="selected_images">
<?php
	$size = array( 60, 60 );
	foreach( $this->selected_multiple_image_ids as $attachment_id ) {
?>	<li><?php echo wp_get_attachment_image( $attachment_id, $size ); ?></li>
<?php
	} // foreach()
?>
</ul>
<?php
} // if ( $this->selected_multiple_image_ids )
?>
		<h3><?php esc_html_e( 'Actions without any selected image', 'quick-featured-images-pro' ); ?></h3>
		<p><?php esc_html_e( 'These actions do not require a selected image.', 'quick-featured-images-pro' ); ?></p>
<?php
foreach ( $this->valid_actions_without_image as $name => $label ) {
	if ( 'assign_first_img' == $name ) {
		$desc = '.<br />' . esc_html__( 'The plugin will try to find the first image embedded in the content, or in a WordPress standard gallery, or attached to a post.', 'quick-featured-images-pro' );
		$desc .= ' ' . esc_html__( 'It will also search in NextGen galleries if the NextGen plugin is activated.', 'quick-featured-images-pro' );
	}
?>
		<p>
			<input type="radio" id="<?php echo $name; ?>" name="action" value="<?php echo $name; ?>" />
			<label for="<?php echo $name; ?>"><strong><?php echo esc_html( $label ); ?></strong></label><?php echo $desc; ?>
		</p>
<?php
}
?>
		<h3><?php esc_html_e( 'Actions with an external image', 'quick-featured-images-pro' ); ?></h3>
		<p><?php esc_html_e( 'If one of the following plugins is installed and activated, you can use external images as featured images:', 'quick-featured-images-pro' ); ?></p>
<?php 
$text = 'Plugin <strong>activated</strong>.';
$disabled = ' disabled="disabled"';
if ( $this->is_external_capable ) {
	$disabled = '';
}
?>
		<ul>
			<li><a href="https://wordpress.org/plugins/featured-image-by-url/" target="_blank">Featured Image By URL at wordpress.org</a> <?php if ( $this->is_knawatfibu ) { _e( $text ); } ?></li>
			<li><a href="https://wordpress.org/plugins/featured-image-from-url/" target="_blank">Featured Image From URL at wordpress.org</a> <?php if ( $this->is_fifu ) { _e( $text ); } ?></li>
		</ul>
<?php 
foreach ( $this->valid_actions_external_images as $name => $label ) {
?>
		<p>
			<input type="radio" <?php echo $disabled; ?> id="<?php echo $name; ?>" name="action" value="<?php echo $name; ?>" />
			<label for="<?php echo $name; ?>"><strong><?php echo esc_html( $label ); ?></strong></label>
		</p>
		<p>
			<label for="<?php echo $name; ?>_url"><?php $text = 'Image URL'; esc_html_e( $text ); ?></label>
			<input type="text" id="<?php echo $name; ?>_url" class="qfi_full_width" name="external_image_url" value="<?php if ( $this->selected_external_image_url ) { echo esc_url( $this->selected_external_image_url ); } ?>" />
			<em><?php /* Enter the URL of the image */ esc_html_e( 'The URL must begin either with http or with https, otherwise the value is not accepted.', 'quick-featured-images-pro' );?></em><?php
			if ( 'assign_external_img' == $name ) { ?><br>
			<?php esc_html_e( 'If an URL is specified, an alternative text should also be entered for the specifications to be accepted.', 'quick-featured-images-pro' ); ?><br />
			<label for="<?php echo $name; ?>_alt"><?php $text = 'Alternative Text'; esc_html_e( $text ); ?></label>
			<input type="text" id="<?php echo $name; ?>_alt" class="qfi_full_width" name="external_image_alt" value="<?php if ( $this->selected_external_image_alt ) { echo esc_attr( $this->selected_external_image_alt ); } ?>" /><br>
			<em><?php $text = 'Describe the purpose of the image'; esc_html_e( $text ); ?></em><?php
			} ?>
		</p>
<?php
} // foeach( valid_actions_external_images )
?>	</fieldset>
<?php 
wp_nonce_field( 'quickfipro', $this->plugin_slug . '_nonce' );
submit_button( $next_label, 'secondary' );
?>
	<input type="hidden" id="selection_advice" name="selection_advice" value="<?php esc_attr_e( 'Use CTRL for multiple choice', 'quick-featured-images-pro' ); ?>" />
</form>
<form method="post" action="<?php echo esc_url( admin_url( sprintf( 'admin.php?page=%s&step=confirm', $this->page_slug ) ) ); ?>">
	<h2 class="no-bottom"><?php esc_html_e( 'Presets', 'quick-featured-images-pro' ); ?></h2>
	<div class="qfi_page_description">
		<p><?php esc_html_e( 'You can reuse previous settings using presets. Select one of the following presets.', 'quick-featured-images-pro' ); ?></p>
	</div>
<?php
// if there are presets
if ( ! empty( $this->current_settings[ 'presets' ] ) and is_array( $this->current_settings[ 'presets' ] ) ) {
	// for higher legibility
	$presets = $this->current_settings[ 'presets' ];
	// display preset names in a dropdown list to select
?>
	<p>
		<label for="presets_list"><?php esc_html_e( 'Select a preset', 'quick-featured-images-pro' ); ?></label>
		<select name="preset_name" id="presets_list">
<?php
	echo $this->get_html_empty_option();
?>
<?php
	// print presets sorted alphabetically by key names
	$keynames = array_keys( $presets );
	// sort naturally and case-independent
	natcasesort( $keynames );
	foreach ( $keynames as $key ) {
		if ( ! empty( $presets[ $key ][ 'preset_name' ] ) ) {
?>
			<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( stripslashes( $presets[ $key ][ 'preset_name' ] ) ); ?></option>
<?php
		} // if (preset_name)
	} // foreach(keynames)
?>
		</select>
	</p>
<?php
	wp_nonce_field( 'quickfipro', $this->plugin_slug . '_nonce' );
	submit_button( $next_label, 'secondary' );
?>
	<p><?php 
	$qfi_settings_instance  = Quick_Featured_Images_Pro_Settings::get_instance();
	printf( 
		esc_html__( 'Manage the presets on page %s.', 'quick-featured-images-pro' ),
		sprintf(
			'<a href="%s">%s</a>',
			esc_url( admin_url( sprintf( 'admin.php?page=%s', $qfi_settings_instance->get_page_slug() ) ) ),
			esc_html( $qfi_settings_instance->get_page_headline() )
		)
	)
	?></p>
<?php
} else {
?>
	<p><?php 
	printf( 
		esc_html__( 'There are no presets. You can add a preset at the end of the process in &#8220;%s&#8221;.', 'quick-featured-images-pro' ),
		esc_html( $this->get_page_headline() )
	)
	?></p>
<?php
}
?>
</form>
