<h2><?php esc_html_e( 'Your selection', 'quick-featured-images-pro' ); ?></h2>
<?php
$two_columns = false;
$is_single_selected = ( in_array( $this->selected_action, array_keys( $this->valid_actions ) ) and $this->selected_image_id );
$is_single_external = ( in_array( $this->selected_action, array_keys( $this->valid_actions_external_images ) ) );
$is_multiple_selected = ( in_array( $this->selected_action, array_keys( $this->valid_actions_multiple_images ) ) and $this->selected_multiple_image_ids );

if ( $is_single_selected or $is_single_external ) {
	$two_columns = true;
	if ( $is_single_selected ) {
		$img_html = wp_get_attachment_image( $this->selected_image_id, 'thumbnail' );
		$img_title_html = get_the_title( $this->selected_image_id );
	} else {
		// if available external image: display it
		if ( $this->selected_external_image_size ) {
			$image_height = $this->selected_external_image_size[ 1 ] / $this->selected_external_image_size[ 0 ] * $this->used_thumbnail_width;
			$img_html = sprintf(
				'<img width="%s" height="%s" src="%s" class="attachment-thumbnail size-thumbnail" alt="">',
				absint( $this->used_thumbnail_width ),
				absint( $image_height ),
				$this->selected_external_image_url
			);
			$img_title_html = $this->selected_external_image_alt;
		} else {
			$img_html = $this->selected_external_image_url;
			$text = 'Image URL'; $img_title_html = esc_html__( $text );
		}
	}
?>
<div class="qfi_wrapper">
	<div class="qfi_w50percent">
		<h3><?php esc_html_e( 'Your selected thumbnail', 'quick-featured-images-pro' ); ?></h3>
		<p><?php echo $img_html; ?><br>
			<strong><?php esc_html_e( 'Image title', 'quick-featured-images-pro' ); ?>:</strong> <?php echo $img_title_html; ?>
		</p>
		<p><a class="button" href="<?php echo esc_url( admin_url( sprintf( 'admin.php?page=%s', $this->page_slug ) ) ); ?>"><?php esc_html_e( 'If wrong image start again', 'quick-featured-images-pro' ); ?></a></p>
	</div><!-- .qfi_w50percent -->
	<div class="qfi_w50percent">
<?php
} elseif ( $is_multiple_selected ) {
	$two_columns = true;
?>
<div class="qfi_wrapper">
	<div class="qfi_w50percent">
		<h3><?php esc_html_e( 'Your selected thumbnails', 'quick-featured-images-pro' ); ?></h3>
		<ul class="selected_images">
<?php
	$size = array( 60, 60 );
	$attr = array( 'class' => 'attachment-thumbnail' );
	foreach( $this->selected_multiple_image_ids as $attachment_id ) {
?>			<li><?php echo wp_get_attachment_image( $attachment_id, $size, false, $attr ); ?></li>
<?php
	} // foreach()
?>
		</ul>
<?php
?>
		<p><a class="button" href="<?php echo esc_url( admin_url( sprintf( 'admin.php?page=%s', $this->page_slug ) ) ); ?>"><?php esc_html_e( 'If wrong image start again', 'quick-featured-images-pro' ); ?></a></p>
	</div><!-- .qfi_w50percent -->
	<div class="qfi_w50percent">
<?php
}
?>
		<h3><?php esc_html_e( 'Your selected action', 'quick-featured-images-pro' ); ?></h3>
<?php
if ( isset( $this->valid_actions[ $this->selected_action ] ) ) {
	$selected_action = $this->valid_actions[ $this->selected_action ];
} elseif ( isset( $this->valid_actions_without_image[ $this->selected_action ] ) ) {
	$selected_action = $this->valid_actions_without_image[ $this->selected_action ];
} elseif ( isset( $this->valid_actions_multiple_images[ $this->selected_action ] ) ) {
	$selected_action = $this->valid_actions_multiple_images[ $this->selected_action ];
} elseif ( isset( $this->valid_actions_external_images[ $this->selected_action ] ) ) {
	$selected_action = $this->valid_actions_external_images[ $this->selected_action ];
} else {
	$selected_action = __( 'You have not selected an action.', 'quick-featured-images-pro' );
}
?>
		<p><?php echo esc_html( $selected_action ); ?></p>
		<p><a class="button" href="<?php echo esc_url( admin_url( sprintf( 'admin.php?page=%s', $this->page_slug ) ) ); ?>"><?php esc_html_e( 'If wrong action start again', 'quick-featured-images-pro' ); ?></a></p>
<?php
if ( $this->selected_approach ) {
?>
		<h3><?php esc_html_e( 'Your selected approach', 'quick-featured-images-pro' ); ?></h3>
		<p><?php echo esc_html( $this->valid_approaches_first_image[ $this->selected_approach ] ); ?></p>
<?php
}
if ( $two_columns ) {
?>
	</div><!-- .qfi_w50percent -->
</div><!-- .qfi_wrapper -->
<?php
}
// don't show on selection page
if ( 'select' != $this->selected_step ) {
?>
<div class="qfi_wrapper">
	<div class="qfi_w50percent">
		<h3><?php esc_html_e( 'Your selected options', 'quick-featured-images-pro' ); ?></h3>
<?php 
	if ( $this->selected_options ) {
?>
		<ul>
<?php 
		foreach ( $this->selected_options as $option ) {
?>
			<li><?php echo $this->valid_options[ $option ]; ?></li>
<?php 
		}
?>
		</ul>
<?php 
	} else {
?>
		<p><?php esc_html_e( 'No selected options', 'quick-featured-images-pro' ); ?></p>
<?php 
}
?>
	</div><!-- .qfi_w50percent -->
	<div class="qfi_w50percent">
		<h3><?php esc_html_e( 'Your selected filters', 'quick-featured-images-pro' ); ?></h3>
<?php 
	if ( $this->selected_filters ) {
?>
		<ul>
<?php 
		foreach ( $this->selected_filters as $filter ) {
?>
			<li><?php echo $this->valid_filters[ $filter ]; ?></li>
<?php 
		}
?>
		</ul>
<?php 
	} else {
?>
		<p><?php esc_html_e( 'No selected filters', 'quick-featured-images-pro' ); ?></p>
<?php 
	}
?>
	</div><!-- .qfi_w50percent -->
</div><!-- .qfi_wrapper -->
<?php
} // if ( 'select' != $this->selected_step )
