/**
 * WordPress dependencies
 */
const {
	dispatch,
} = wp.data;

/**
 * Fetches existing notice data and generates the corresponding notice.
 */
export default function generateNotices() {
	const { createNotice } = dispatch( 'core/notices' );
	window.tastyRecipesBlockEditor.editorNotices.forEach( ( notice ) => {
		createNotice( notice.type, notice.content, {
			isDismissible: notice.dismissible || false,
			actions: notice.actions || [],
		} );
	} );
}
