const {
	registerBlockType,
} = wp.blocks;

/**
 * Internal dependencies
 */
import generateNotices from './admin-notices';
import blockRegistration from './recipe-block';

registerBlockType( 'wp-tasty/tasty-recipe', blockRegistration );

window.addEventListener( 'load', () => {
	generateNotices();
	// Removes the conversion success query string on browsers that support it.
	if ( window.history ) {
		let newLocation = window.location.href;
		newLocation = newLocation.replace( '&tasty_recipes_message=converted_recipe_success', '' );
		if ( newLocation !== window.location.href ) {
			window.history.replaceState( '', '', newLocation );
		}
	}
} );
