/**
 * WordPress dependencies
 */
const {
	TextControl,
	CheckboxControl,
	PanelBody,
	ServerSideRender,
} = wp.components;

const {
	InspectorAdvancedControls,
} = wp.editor;

const {
	Fragment,
} = wp.element;

const {
	__,
} = wp.i18n;

const handleEditorModalUpdate = ( props, response ) => {
	const date = new Date();
	window.tastyRecipesBlockEditor.recipeDataStore[ response.recipe.id ] = response.recipe;
	props.setAttributes(
		{
			id: response.recipe.id,
			lastUpdated: date.getTime(),
		}
	);
};

const edit = ( props ) => {
	const handleModalClose = ( response ) => {
		handleEditorModalUpdate( props, response );
	};

	const defaultOnClickHandler = () => {
		window.tastyRecipesEditorModal.open( {
			author_name: window.tastyRecipesEditorModalData.defaultAuthorName,
		}, handleModalClose );
	};

	if ( typeof props.attributes.id === 'undefined' || 0 === props.attributes.id ) {
		if ( typeof props.attributes.id === 'undefined' ) {
			window.tastyRecipesEditorModal.open( {
				author_name: window.tastyRecipesEditorModalData.defaultAuthorName,
				title: wp.data.select( 'core/editor' ).getEditedPostAttribute( 'title' ),
			}, handleModalClose );
			props.setAttributes( { id: 0 } );
		}
		return (
			<div role="button" tabIndex={ 0 } onClick={ defaultOnClickHandler } onKeyDown={ defaultOnClickHandler }>
				<p>{ __( 'No Tasty Recipe created yet. Click here to start one.', 'tasty-recipes' ) }</p>
			</div>
		);
	}

	const existingOnClickHandler = () => {
		if ( typeof window.tastyRecipesBlockEditor.recipeDataStore[ props.attributes.id ] === 'undefined' ) {
			return;
		}
		window.tastyRecipesEditorModal.open( window.tastyRecipesBlockEditor.recipeDataStore[ props.attributes.id ], handleModalClose );
	};

	return (
		<Fragment>
			<div role="button" tabIndex={ 0 } onClick={ existingOnClickHandler } onKeyDown={ existingOnClickHandler }>
				<ServerSideRender block="wp-tasty/tasty-recipe" attributes={ props.attributes } />
			</div>
			<InspectorAdvancedControls>
				<PanelBody
					title={ __( 'Recipe options', 'tasty-recipes' ) }
					initialOpen={ true }
				>
					<CheckboxControl
						label={ __( 'This is a non-food recipe (craft, cleaning product, etc)', 'tasty-recipes' ) }
						checked={ props.attributes.disableJSON }
						onChange={ () => {
							props.setAttributes( {
								disableJSON: ! props.attributes.disableJSON,
							} );
						} }
					/>
					<TextControl
						label={ __( 'Override Author Link', 'tasty-recipes' ) }
						value={ props.attributes.author_link }
						onChange={ ( value ) => {
							props.setAttributes( {
								author_link: value,
							} );
						} }
					/>
				</PanelBody>
			</InspectorAdvancedControls>
		</Fragment>
	);
};

// Renders dynamically on the frontend.
const save = () => {
	return null;
};

const blockRegistration = {
	title: window.tastyRecipesBlockEditor.recipeBlockTitle,
	icon: 'carrot',
	category: 'common',
	html: false,
	attributes: {
		id: {
			type: 'number',
		},
		lastUpdated: {
			type: 'number',
		},
		author_link: {
			type: 'string',
			default: '',
		},
		disableJSON: {
			type: 'boolean',
			default: false,
		},
	},
	edit,
	save,
	transforms: {
		from: [
			{
				type: 'shortcode',
				tag: 'tasty-recipe',
				attributes: {
					id: {
						type: 'number',
						shortcode: ( props ) => {
							if ( typeof props.named.id === 'undefined' ) {
								return 0;
							}
							return parseInt( props.named.id );
						},
					},
				},
			},
		],
	},
};

export default blockRegistration;
