(function(wp, $, editorModalData){
	var updateCallback = null,
		container = null;
	$(document).ready(function(){
		container = $('.tasty-recipes-modal-container');
		window.tastyRecipesEditorModal.initEvents();
	});

	var editorModal = {

		/**
		 * Initializes events within the editor modal.
		 */
		initEvents: function() {
			$('.tasty-recipes-button-insert', container).on('click', $.proxy( function( event ){
				this.close( true );
			}, this ));
			$('.tasty-recipes-button-update', container).on('click', $.proxy( function( event ){
				this.close( true );
			}, this ));
			$('.tasty-recipes-modal-close', container).on('click', $.proxy( function( event ){
				this.close( false );
			}, this ));
		},

		/**
		 * Opens the editor modal.
		 */
		open: function( data = null, callback = null ) {
			var template = wp.template( 'tasty-recipes-recipe-editor' );
			updateCallback = callback;
			$( '.tasty-recipes-frame-content', container ).html( template( null !== data ? data : {} ) );
			if ( typeof data === 'object' && typeof data.id !== 'undefined' ) {
				container.addClass('tasty-recipes-state-editing');
			} else {
				container.addClass('tasty-recipes-state-creating');
			}
			$('body').addClass('tasty-recipes-modal-open');
			$(document).on('keydown.tasty-recipes-escape', $.proxy( function( event ){
				if ( 27 === event.keyCode ) {
					this.close( false );
					event.stopImmediatePropagation();
				}
			}, this ));
			$('form', container).on('submit', $.proxy(function( event ){
				event.preventDefault();
				this.close( true );
			}, this ));
			$('.tasty-recipes-image-preview', container ).on('click', $.proxy( this.handleClickSelectImage, this ));
			$('.tasty-recipes-select-image', container ).on('click', $.proxy( this.handleClickSelectImage, this ));
			$('.tasty-recipes-remove-image', container ).on('click', $.proxy(function( event ){
				$( 'input[name="image_id"]', container ).val('');
				this.renderThumbnailPreview();
			}, this ) );
			if ( 'object' === typeof data.image_sizes && 'object' === typeof data.image_sizes.thumbnail ) {
				this.renderThumbnailPreview( data.image_sizes.thumbnail );
			} else {
				this.renderThumbnailPreview();
			}
			// Allows Tasty Links to set up its data.
			$(document).trigger('tasty-recipes-pre-modal-show', data );
			container.show();
			$('.tasty-recipes-frame-content', container ).focus();
			if ( typeof tinyMCE !== 'undefined' ) {
				var settings = tinyMCEPreInit.mceInit['tasty-recipes-editor'];
				settings.selector = '.tasty-recipes-tinymce';
				var vis = $('.mce-toolbar-grp.mce-inline-toolbar-grp.mce-container.mce-panel:visible');
				if ( vis.length ) {
					vis.addClass('tr-temp-hide');
				}
				setTimeout( function(){
					tinyMCE.init( settings );
				}, 1 );
			}
		},

		/**
		 * Closes the editor modal.
		 */
		close: function( save ) {
			$('body').removeClass('tasty-recipes-modal-open');
			$(document).unbind('keydown.tasty-recipes-escape');
			var hideContainer = function(){
				if ( typeof tinyMCE !== 'undefined' ) {
					$('.tasty-recipes-tinymce').each(function(){
						tinymce.EditorManager.execCommand( 'mceRemoveEditor', true, $(this).attr('id') );
					});
				}
				var hid = $('.mce-toolbar-grp.mce-inline-toolbar-grp.mce-container.mce-panel.tr-temp-hide');
				if ( hid.length ) {
					hid.removeClass('tr-temp-hide');
				}
				container.hide();
				container.removeClass('tasty-recipes-state-creating tasty-recipes-state-editing');
				$( '.tasty-recipes-frame-content', container ).empty();
			};
			if ( save ) {
				if ( typeof tinyMCE !== 'undefined' ) {
					tinyMCE.triggerSave();
				}
				var paramObj = {};
				$.each( $('form', container ).serializeArray(), function(_, kv) {
					if (paramObj.hasOwnProperty(kv.name)) {
						paramObj[kv.name] = $.makeArray(paramObj[kv.name]);
						paramObj[kv.name].push(kv.value);
					} else {
						paramObj[kv.name] = kv.value;
					}
				});
				wp.ajax.post( 'tasty_recipes_modify_recipe', {
					post_id: editorModalData.currentPostId,
					nonce: tastyRecipesEditor.modifyNonce,
					recipe: paramObj
				} ).done( function( response ) {
					hideContainer();
					if ( updateCallback ) {
						updateCallback( response );
					}
				} )
				.fail( function( response ) {
					hideContainer();
					if ( updateCallback ) {
						updateCallback( response );
					}
				} );
			} else {
				hideContainer();
			}
		},

		/**
		 * Handles the event for selecting an image.
		 */
		handleClickSelectImage:function( event ) {
			var imageId = $( 'input[name="image_id"]', container );
			event.preventDefault();
			var frame = wp.media({
				title: editorModalData.i18n.frameTitle,
				multiple: false,
				library: {
					type: 'image'
				},
				button: {
					text: editorModalData.i18n.frameButton,
				}
			});

			frame.on( 'open', function(){
				var selection = frame.state().get('selection');
				var selected = imageId.val();
				if ( selected ) {
					attachment = wp.media.model.Attachment.get( selected );
					attachment.fetch();
					selection.add( attachment );
				}
			});

			// Handle results from media manager.
			frame.on('select',$.proxy( function( ) {
				var attachments = frame.state().get('selection').toJSON();
				if ( attachments.length ) {
					imageId.val( attachments[0].id );
					this.renderThumbnailPreview( attachments[0].sizes.thumbnail );
				}
			}, this ));

			frame.open();
		},

		/**
		 * Handles the event of rendering the placeholder image.
		 */
		renderThumbnailPreview: function( imageSize = null ) {
			var imageContainer = $('.tasty-recipes-image-preview', container );
			imageContainer.html('');
			$('.tasty-recipes-image', container ).removeClass('tasty-recipes-image-with-placeholder');
			if ( null !== imageSize ) {
				var img = $('<img />');
				img.attr( 'src', imageSize.url );
				imageContainer.prepend( img );
			} else {
				var placeholder = $('<div/>');
				placeholder.addClass('tasty-recipes-image-preview-placeholder');
				imageContainer.addClass('tasty-recipes-image-with-placeholder');
				$('.tasty-recipes-image', container ).addClass('tasty-recipes-image-with-placeholder');
				imageContainer.prepend( placeholder );
			}
		},
	};

	window.tastyRecipesEditorModal = editorModal;
}(window.wp, window.jQuery, window.tastyRecipesEditorModalData))
