(function(){
	var buttonClass = 'tasty-recipes-scale-button',
		buttonActiveClass = 'tasty-recipes-scale-button-active',
		buttons = document.querySelectorAll('.tasty-recipes-scale-button');
	if ( ! buttons ) {
		return;
	}
	/* frac.js (C) 2012-present SheetJS -- http://sheetjs.com */
	/* bothEquals() avoids use of &&, which gets prettified by WordPress. */
	var bothEquals = function( d1, d2, D ) {
		var ret = 0;
		if (d1<=D) {
			ret++;
		}
		if (d2<=D) {
			ret++;
		}
		return ret === 2;
	};
	var frac=function frac(x,D,mixed){var n1=Math.floor(x),d1=1;var n2=n1+1,d2=1;if(x!==n1)while(bothEquals(d1,d2,D)){var m=(n1+n2)/(d1+d2);if(x===m){if(d1+d2<=D){d1+=d2;n1+=n2;d2=D+1}else if(d1>d2)d2=D+1;else d1=D+1;break}else if(x<m){n2=n1+n2;d2=d1+d2}else{n1=n1+n2;d1=d1+d2}}if(d1>D){d1=d2;n1=n2}if(!mixed)return[0,n1,d1];var q=Math.floor(n1/d1);return[q,n1-q*d1,d1]};frac.cont=function cont(x,D,mixed){var sgn=x<0?-1:1;var B=x*sgn;var P_2=0,P_1=1,P=0;var Q_2=1,Q_1=0,Q=0;var A=Math.floor(B);while(Q_1<D){A=Math.floor(B);P=A*P_1+P_2;Q=A*Q_1+Q_2;if(B-A<5e-8)break;B=1/(B-A);P_2=P_1;P_1=P;Q_2=Q_1;Q_1=Q}if(Q>D){if(Q_1>D){Q=Q_2;P=P_2}else{Q=Q_1;P=P_1}}if(!mixed)return[0,sgn*P,Q];var q=Math.floor(sgn*P/Q);return[q,sgn*P-q*Q,Q]};
	buttons.forEach(function(button){
		button.addEventListener('click', function(event){
			event.preventDefault();
			var recipe = event.target.closest('.tasty-recipes');
			if ( ! recipe ) {
				return;
			}
			var otherButtons = recipe.querySelectorAll('.' + buttonClass);
			otherButtons.forEach(function(bt){
				bt.classList.remove(buttonActiveClass);
			});
			button.classList.add(buttonActiveClass);

			/* Scales all scalable amounts. */
			var scalables = recipe.querySelectorAll('span[data-amount]');
			var buttonAmount = parseFloat( button.dataset.amount );
			scalables.forEach(function(scalable){
				var amount = parseFloat( scalable.dataset.amount ) * buttonAmount;
				if ( parseFloat( amount ) !== parseInt( amount ) ) {
					var amountArray = frac.cont( amount, 9, true );
					var newAmount = '';
					if ( amountArray[1] !== 0 ) {
						newAmount = amountArray[1] + '/' + amountArray[2];
					}
					if ( newAmount ) {
						newAmount = ' ' + newAmount;
					}
					if ( amountArray[0] ) {
						newAmount = amountArray[0] + newAmount;
					}
					amount = newAmount;
				}
				if ( typeof scalable.dataset.unit !== 'undefined' ) {
					amount += ' ' + scalable.dataset.unit;
				}
				scalable.innerText = amount;
			});
			/* Appends " (x2)" indicator. */
			var nonNumerics = recipe.querySelectorAll('[data-has-non-numeric-amount]');
			nonNumerics.forEach(function(nonNumeric){
				var indicator = nonNumeric.querySelector('span[data-non-numeric-label]');
				if ( indicator ) {
					nonNumeric.removeChild(indicator);
				}
				if ( 1 !== buttonAmount ) {
					var indicator = document.createElement('span');
					indicator.setAttribute('data-non-numeric-label', true);
					var text = document.createTextNode(' (x' + buttonAmount + ')');
					indicator.appendChild(text);
					nonNumeric.appendChild(indicator);
				}
			});
		});
	});
}());
