<?php
/**
 * Functions you can use in your theme
 *
 * @package Tasty_Recipes
 */

use \Tasty_Recipes\Content_Model;

/**
 * Whether or not the recipe is being displayed for print.
 *
 * @return boolean
 */
function tasty_recipes_is_print() {
	return (bool) get_query_var( Content_Model::get_print_query_var() );
}

/**
 * Get the print link for a recipe embedded within a given post.
 *
 * @param integer $post_id   ID for the post with the recipe.
 * @param integer $recipe_id ID for the recipe to display.
 * @return string
 */
function tasty_recipes_get_print_url( $post_id, $recipe_id ) {
	global $wp_rewrite;
	$permalink = get_permalink( $post_id );
	if ( ! empty( $wp_rewrite->permalink_structure ) && ! is_preview() ) {
		$permalink = trailingslashit( $permalink ) . Content_Model::get_print_query_var() . '/' . $recipe_id;
		if ( '/' === substr( $wp_rewrite->permalink_structure, -1 ) ) {
			$permalink .= '/';
		}
	} else {
		$permalink = add_query_arg( Content_Model::get_print_query_var(), $recipe_id, $permalink );
	}
	return $permalink;
}
