<?php
/**
 * Integrates Tasty Recipes with Yoast SEO's Open Graph.
 *
 * @package Tasty_Recipes
 */

namespace Tasty_Recipes\Integrations;

/**
 * Integrates Tasty Recipes with Yoast SEO's Open Graph.
 */
class Recipe_Graph_Piece implements \WPSEO_Graph_Piece {

	/**
	 * A value object with context variables.
	 *
	 * @var WPSEO_Schema_Context
	 */
	private $context;

	/**
	 * Recipe associated with this instance.
	 *
	 * @var array
	 */
	private $recipe;

	/**
	 * Recipe_Graph_Piece constructor.
	 *
	 * @param \WPSEO_Schema_Context $context A value object with context variables.
	 */
	public function __construct( \WPSEO_Schema_Context $context ) {
		$this->context = $context;
	}

	/**
	 * Determines whether or not a piece should be added to the graph.
	 *
	 * @return boolean
	 */
	public function is_needed() {
		if ( ! is_singular() ) {
			return false;
		}
		$recipes = \Tasty_Recipes::get_recipes_for_post(
			$this->context->id,
			array(
				'disable-json-ld' => false,
			)
		);
		if ( empty( $recipes ) ) {
			return false;
		}
		$this->recipe = array_shift( $recipes );
		return true;
	}

	/**
	 * Returns Recipe Schema data.
	 *
	 * @return array|boolean Recipe data on success, false on failure.
	 */
	public function generate() {
		return \Tasty_Recipes\Distribution_Metadata::get_enriched_google_schema_for_recipe( $this->recipe, get_post( $this->context->id ) );
	}

}
