<?php
/**
 * Bold recipe card template.
 *
 * @package Tasty_Recipes
 */

?>
<?php
echo $recipe_styles;
$ext           = is_feed() ? '.png' : '.svg';
$other_details = '';
?>

<header class="tasty-recipes-entry-header">
	<?php if ( ! empty( $recipe_image ) ) : ?>
		<div class="tasty-recipes-image">
			<?php echo $recipe_image; ?>
		</div>
	<?php endif; ?>
	<h2><?php echo $recipe_title; ?></h2>
	<hr>
	<?php if ( ! empty( $recipe_rating_icons ) || ! empty( $recipe_rating_label ) ) : ?>
		<div class="tasty-recipes-rating">
			<?php if ( Tasty_Recipes\Ratings::is_enabled() ) : ?>
				<a href="#respond">
			<?php endif; ?>
				<?php if ( ! empty( $recipe_rating_icons ) ) : ?>
					<p><?php echo $recipe_rating_icons; ?></p>
				<?php endif; ?>
				<?php if ( ! empty( $recipe_rating_label ) ) : ?>
					<p><?php echo $recipe_rating_label; ?></p>
				<?php endif; ?>
			<?php if ( Tasty_Recipes\Ratings::is_enabled() ) : ?>
				</a>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if ( ! empty( $recipe_details ) ) : ?>
		<div class="tasty-recipes-details">
			<ul>
				<?php foreach ( $recipe_details as $key => $detail ) : ?>
						<?php
						$icons = array(
							'cook_time'  => 'icon-clock',
							'prep_time'  => 'icon-clock',
							'total_time' => 'icon-clock',
							'method'     => 'icon-squares',
							'cuisine'    => 'icon-flag',
							'category'   => 'icon-folder',
							'yield'      => 'icon-cutlery',
						);
						if ( ! in_array( $key, array( 'method', 'cuisine', 'category' ), true ) ) :
							?>
						<li class="<?php echo esc_attr( $detail['class'] ); ?>"><span class="tasty-recipes-label">
							<?php
							if ( isset( $icons[ $key ] ) ) {
								if ( '.svg' === $ext ) {
									echo '<svg viewBox="0 0 24 24" class="detail-icon"><use xlink:href="' . esc_url( plugins_url( 'images/' . $icons[ $key ] . $ext, __FILE__ ) ) . '#icon"></use></svg>';
								} else {
									echo '<img nopin="nopin" data-pin-nopin="1" class="detail-icon" src="' . esc_url( plugins_url( 'images/' . $icons[ $key ] . $ext, __FILE__ ) ) . '">';
								}
							}
							?>
							<?php echo $detail['label']; ?>:</span> <?php echo $detail['value']; ?>
						</li>
							<?php
					else :
						$other_details .= '<li class="' . esc_attr( $detail['class'] ) . '"><span class="tasty-recipes-label">';
						if ( isset( $icons[ $key ] ) ) {
							if ( '.svg' === $ext ) {
								$other_details .= '<svg viewBox="0 0 24 24" class="detail-icon"><use xlink:href="' . esc_url( plugins_url( 'images/' . $icons[ $key ] . $ext, __FILE__ ) ) . '#icon"></use></svg>';
							} else {
								$other_details .= '<img nopin="nopin" data-pin-nopin="1" class="detail-icon" src="' . esc_url( plugins_url( 'images/' . $icons[ $key ] . $ext, __FILE__ ) ) . '">';
							}
						}
						$other_details .= $detail['label'] . ':</span> ' . $detail['value'] . '</li>';
					endif;
					?>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
</header>

<div class="tasty-recipes-entry-content">

	<?php if ( ! tasty_recipes_is_print() ) : ?>
	<div class="tasty-recipes-buttons">
		<?php
			$print_button = '<div class="tasty-recipes-button-wrap"><a class="button tasty-recipes-print-button tasty-recipes-no-print"';
			$current_post = get_post();
			$print_link   = '#';
		if ( $current_post ) {
			$print_link = tasty_recipes_get_print_url( $current_post->ID, $recipe->get_id() );
		}
			$print_button .= ' href="' . esc_url( $print_link ) . '" target="_blank"><img class="svg-print" data-pin-nopin="true" src="' . esc_url( plugins_url( 'images/icon-print.png', __FILE__ ) ) . '">' . esc_html__( 'Print Recipe', 'tasty-recipes' ) . '</a></div>';
			echo $print_button;

			$permalink = '#';
		if ( $current_post ) {
			$permalink = get_permalink( $current_post->ID );
		}
		?>
		<div class="tasty-recipes-button-wrap">
			<a class="share-pin button" data-pin-custom="true" href="<?php echo esc_url( add_query_arg( 'url', rawurlencode( $permalink ), 'https://www.pinterest.com/pin/create/button/' ) ); ?>"><img class="svg-pinterest" data-pin-nopin="true" src="<?php echo esc_url( plugins_url( 'images/icon-pinterest.png', __FILE__ ) ); ?>"><?php esc_html_e( 'Pin Recipe', 'tasty-recipes' ); ?></a>
		</div>
	</div>
	<?php endif; ?>

	<?php
	$show_hr = false;
	if ( ! empty( $recipe_description ) && '<div itemprop="description"></div>' !== $recipe_description ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-description">
			<h3><?php esc_html_e( 'Description', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_description; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_ingredients ) ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-ingredients">
			<?php if ( ! empty( $recipe_scalable ) ) : ?>
				<span class="tasty-recipes-scale-container">
					<span class="tasty-recipes-scale-label"><?php esc_html_e( 'Scale', 'tasty-recipes' ); ?></span>
					<?php echo $recipe_scalable; ?>
				</span>
			<?php endif; ?>
			<h3><?php esc_html_e( 'Ingredients', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_ingredients; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_instructions ) ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-instructions">
			<h3><?php esc_html_e( 'Instructions', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_instructions; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_video_embed ) ) :
		$show_hr = false;
		?>
		<div class="tasty-recipe-video-embed">
			<?php echo $recipe_video_embed; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_equipment ) ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-equipment">
			<h3><?php esc_html_e( 'Equipment', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_equipment; ?>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_notes ) ) : ?>
		<div class="tasty-recipes-notes">
			<h3><?php esc_html_e( 'Notes', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_notes; ?>
		</div>
	<?php endif; ?>

	<?php if ( $other_details ) : ?>
		<div class="tasty-recipes-other-details">
			<ul>
				<?php echo $other_details; ?>
			</ul>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_nutrifox_embed ) ) : ?>
		<div class="tasty-recipes-nutrifox">
			<?php echo $recipe_nutrifox_embed; ?>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_nutrition ) ) : ?>
			<div class="tasty-recipes-nutrition">
			<h3><?php esc_html_e( 'Nutrition', 'tasty-recipes' ); ?></h3>
			<ul>
				<?php foreach ( $recipe_nutrition as $nutrition ) : ?>
					<li><strong class="tasty-recipes-label"><?php echo $nutrition['label']; ?>:</strong> <?php echo $nutrition['value']; ?></li>
				<?php endforeach; ?>
			</ul>
			</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_keywords ) ) : ?>
		<div class="tasty-recipes-keywords">
			<p><span class="tasty-recipes-label"><?php esc_html_e( 'Keywords', 'tasty-recipes' ); ?>:</span> <?php echo $recipe_keywords; ?></p>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $instagram_handle ) ) : ?>
	<footer class="tasty-recipes-entry-footer">
		<div class="tasty-recipes-footer-content">
			<img class="svg-instagram" data-pin-nopin="true" src="<?php echo esc_url( plugins_url( 'images/icon-instagram.png', __FILE__ ) ); ?>">
			<h3><?php esc_html_e( 'Did you make this recipe?', 'tasty-recipes' ); ?></h3>
			<p><?php esc_html_e( 'Tag', 'tasty-recipes' ); ?> <a href="<?php echo esc_url( 'https://www.instagram.com/' . $instagram_handle ); ?>" target="_blank">@<?php echo $instagram_handle; ?></a> <?php esc_html_e( 'on Instagram', 'tasty-recipes' ); ?>
				<?php if ( ! empty( $instagram_hashtag ) ) : ?>
					<?php esc_html_e( 'and hashtag it', 'tasty-recipes' ); ?> <a href="<?php echo esc_url( 'https://www.instagram.com/explore/tags/' . $instagram_hashtag ); ?>" target="_blank">#<?php echo $instagram_hashtag; ?></a>
				<?php endif; ?>
			</p>
		</div>
	</footer>
	<?php endif; ?>
</div>

<?php if ( tasty_recipes_is_print() && get_post() ) : ?>
<div class="tasty-recipes-source-link">
	<p><strong class="tasty-recipes-label"><?php esc_html_e( 'Find it online', 'tasty-recipes' ); ?></strong>: <a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo esc_url( get_permalink( get_the_ID() ) ); ?></a></p>
</div>
<?php endif; ?>

<?php echo $recipe_scripts; ?>
