<?php
/**
 * Fresh recipe card template.
 *
 * @package Tasty_Recipes
 */

?>
<?php echo $recipe_styles; ?>

<header class="tasty-recipes-entry-header">
	<?php if ( ! empty( $recipe_image ) ) : ?>
		<div class="tasty-recipes-image">
			<?php echo $recipe_image; ?>
		</div>
	<?php else : ?>
		<div class="tasty-recipes-image">
			<?php echo '<img class="detail-icon" data-pin-nopin="true" src="' . esc_url( plugins_url( 'images/placeholder.png', __FILE__ ) ) . '">'; ?>
		</div>
	<?php endif; ?>
	<div class="tasty-recipes-header-content clearfix">
		<h2><?php echo $recipe_title; ?></h2>
		<?php if ( ! empty( $recipe_rating_icons ) || ! empty( $recipe_rating_label ) ) : ?>
			<div class="tasty-recipes-rating">
				<div class="tasty-recipes-rating-outer">
					<div class="tasty-recipes-rating-inner">
						<?php if ( Tasty_Recipes\Ratings::is_enabled() ) : ?>
							<a href="#respond">
						<?php endif; ?>
							<?php if ( ! empty( $recipe_rating_icons ) ) : ?>
								<span class="tasty-recipes-rating-stars"><?php echo $recipe_rating_icons; ?></span>
							<?php endif; ?>
							<?php if ( ! empty( $recipe_rating_label ) ) : ?>
								<span class="tasty-recipes-rating-label"><?php echo $recipe_rating_label; ?></span>
							<?php endif; ?>
						<?php if ( Tasty_Recipes\Ratings::is_enabled() ) : ?>
							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<?php if ( ! empty( $recipe_details ) ) : ?>
			<div class="tasty-recipes-details">
				<ul>
					<?php foreach ( $recipe_details as $key => $detail ) : ?>
						<li class="<?php echo esc_attr( $detail['class'] ); ?>"><span class="tasty-recipes-label">
												<?php
												$icons = array(
													'cook_time' => 'icon-clock-gray',
													'prep_time' => 'icon-clock-gray',
													'total_time' => 'icon-clock-gray',
													'method'   => 'icon-squares-gray',
													'cuisine'  => 'icon-flag-gray',
													'category' => 'icon-folder-gray',
													'yield'    => 'icon-cutlery-gray',
												);
												if ( isset( $icons[ $key ] ) ) {
													echo '<img class="detail-icon" data-pin-nopin="true" src="' . esc_url( plugins_url( 'images/' . $icons[ $key ] . '.png', __FILE__ ) ) . '">';
												}
												?>
						<?php echo $detail['label']; ?>:</span> <?php echo $detail['value']; ?></li>
					<?php endforeach; ?>
				</ul>
			</div>
		<?php endif; ?>

		<?php if ( ! tasty_recipes_is_print() ) : ?>
		<div class="tasty-recipes-buttons">
			<?php
				$print_button = '<div class="tasty-recipes-button-wrap"><a class="button tasty-recipes-print-button tasty-recipes-no-print"';
				$current_post = get_post();
				$print_link   = '#';
			if ( $current_post ) {
				$print_link = tasty_recipes_get_print_url( $current_post->ID, $recipe->get_id() );
			}
				$print_button .= ' href="' . esc_url( $print_link ) . '" target="_blank"><img class="svg-print" data-pin-nopin="true" src="' . esc_url( plugins_url( 'images/icon-print-gray.png', __FILE__ ) ) . '">' . esc_html__( 'Print', 'tasty-recipes' ) . '</a></div>';
				echo $print_button;

				$permalink = '#';
			if ( $current_post ) {
				$permalink = get_permalink( $current_post->ID );
			}
			?>
			<div class="tasty-recipes-button-wrap">
				<a class="share-pin button" data-pin-custom="true" href="<?php echo esc_url( add_query_arg( 'url', rawurlencode( $permalink ), 'https://www.pinterest.com/pin/create/button/' ) ); ?>"><img class="svg-pinterest" data-pin-nopin="true" src="<?php echo esc_url( plugins_url( 'images/icon-pinterest-gray.png', __FILE__ ) ); ?>"><?php esc_html_e( 'Pin', 'tasty-recipes' ); ?></a>
			</div>
		</div>
	</div>

	<?php endif; ?>

</header>

<div class="tasty-recipes-entry-content">
	<hr>


	<?php
	$show_hr = false;
	if ( ! empty( $recipe_description ) && '<div itemprop="description"></div>' !== $recipe_description ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-description">
			<h3><?php esc_html_e( 'Description', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_description; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_ingredients ) ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-ingredients">
			<?php if ( ! empty( $recipe_scalable ) ) : ?>
				<span class="tasty-recipes-scale-container">
					<span class="tasty-recipes-scale-label"><?php esc_html_e( 'Scale', 'tasty-recipes' ); ?></span>
					<?php echo $recipe_scalable; ?>
				</span>
			<?php endif; ?>
			<h3><?php esc_html_e( 'Ingredients', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_ingredients; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_instructions ) ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-instructions">
			<h3><?php esc_html_e( 'Instructions', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_instructions; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_video_embed ) ) :
		$show_hr = false;
		?>
		<div class="tasty-recipe-video-embed">
			<?php echo $recipe_video_embed; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php
	if ( ! empty( $recipe_equipment ) ) :
		$show_hr = true;
		?>
		<div class="tasty-recipes-equipment">
			<h3><?php esc_html_e( 'Equipment', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_equipment; ?>
		</div>
	<?php endif; ?>

	<?php
	if ( $show_hr ) :
		$show_hr = false;
		?>
		<hr>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_notes ) ) : ?>
		<div class="tasty-recipes-notes">
			<h3><?php esc_html_e( 'Notes', 'tasty-recipes' ); ?></h3>
			<?php echo $recipe_notes; ?>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_nutrifox_embed ) ) : ?>
		<div class="tasty-recipes-nutrifox">
			<?php echo $recipe_nutrifox_embed; ?>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_nutrition ) ) : ?>
		<?php if ( empty( $recipe_nutrifox_id ) ) : ?>
			<hr>
		<?php endif; ?>
		<div class="tasty-recipes-nutrition">
			<h3><?php esc_html_e( 'Nutrition', 'tasty-recipes' ); ?></h3>
			<ul>
				<?php foreach ( $recipe_nutrition as $nutrition ) : ?>
					<li><strong class="tasty-recipes-label"><?php echo $nutrition['label']; ?>:</strong> <?php echo $nutrition['value']; ?></li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $recipe_keywords ) ) : ?>
		<div class="tasty-recipes-keywords">
			<p><em><strong><?php esc_html_e( 'Keywords', 'tasty-recipes' ); ?>:</strong> <?php echo $recipe_keywords; ?></em></p>
		</div>
	<?php endif; ?>


<?php if ( ! empty( $instagram_handle ) ) : ?>
<footer class="tasty-recipes-entry-footer">
	<div class="tasty-recipes-footer-content">
		<img class="svg-instagram" data-pin-nopin="true" src="<?php echo esc_url( plugins_url( 'images/icon-instagram-black.png', __FILE__ ) ); ?>">
		<h3><?php esc_html_e( 'Did you make this recipe?', 'tasty-recipes' ); ?></h3>
		<p><?php esc_html_e( 'Tag', 'tasty-recipes' ); ?> <a href="<?php echo esc_url( 'https://www.instagram.com/' . $instagram_handle ); ?>" target="_blank">@<?php echo $instagram_handle; ?></a> <?php esc_html_e( 'on Instagram', 'tasty-recipes' ); ?>
			<?php if ( ! empty( $instagram_hashtag ) ) : ?>
				<?php esc_html_e( 'and hashtag it', 'tasty-recipes' ); ?> <a href="<?php echo esc_url( 'https://www.instagram.com/explore/tags/' . $instagram_hashtag ); ?>" target="_blank">#<?php echo $instagram_hashtag; ?></a>
			<?php endif; ?>
		</p>
	</div>
</footer>
<?php endif; ?>
</div>
<?php if ( tasty_recipes_is_print() && get_post() ) : ?>
<div class="tasty-recipes-source-link">
	<p><strong class="tasty-recipes-label"><?php esc_html_e( 'Find it online', 'tasty-recipes' ); ?></strong>: <a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo esc_url( get_permalink( get_the_ID() ) ); ?></a></p>
</div>
<?php endif; ?>

<?php echo $recipe_scripts; ?>
