<?php
/**
 * Template for the editor modal.
 *
 * @package Tasty_Recipes
 */

use Tasty_Recipes\Objects\Recipe;
?>

<script type="text/html" id="tmpl-tasty-recipes-recipe-editor">
	<form>
		<input type="hidden" name="id" value="{{ data.id }}" />

		<div class="tasty-recipes-image">
			<input type="hidden" name="image_id" value="{{ data.image_id }}" />
			<div class="tasty-recipes-image-preview"></div>
			<span class="tasty-recipes-select-image button"><?php esc_html_e( 'Select Image', 'tasty-recipes' ); ?></span>
			<span class="tasty-recipes-remove-image button"><span class="dashicons dashicons-no-alt"></span></span>
		</div>

		<fieldset>
			<label for="title"><?php esc_html_e( 'Title', 'tasty-recipes' ); ?></label>
			<input type="text" name="title" class="regular-text" value="{{ data.title }}" />
		</fieldset>

		<fieldset>
			<label for="author_name"><?php esc_html_e( 'Author Name', 'tasty-recipes' ); ?></label>
			<input type="text" name="author_name" class="regular-text" value="{{ data.author_name }}" />
		</fieldset>

		<?php
		$textareas = array(
			array(
				'name'  => 'description',
				'label' => __( 'Description', 'tasty-recipes' ),
			),
			array(
				'name'  => 'ingredients',
				'label' => __( 'Ingredients', 'tasty-recipes' ),
			),
			array(
				'name'  => 'instructions',
				'label' => __( 'Instructions', 'tasty-recipes' ),
			),
			array(
				'name'  => 'notes',
				'label' => __( 'Notes', 'tasty-recipes' ),
			),
		);
		foreach ( $textareas as $textarea ) {
			?>
			<fieldset>
				<label for="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $textarea['name'] ); ?>"><?php echo esc_html( $textarea['label'] ); ?></label>
				<textarea id="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $textarea['name'] ); ?>" name="<?php echo sanitize_key( $textarea['name'] ); ?>" class="tasty-recipes-tinymce">{{{ data.<?php echo sanitize_key( $textarea['name'] ); ?> }}}</textarea>
			</fieldset>
		<?php } ?>

		<div class="tasty-recipes-details">
			<h3><?php esc_html_e( 'Details', 'tasty-recipes' ); ?></h3>
		<?php
		$cooking_attributes = Recipe::get_cooking_attributes();
		// Add Keywords to this set of editable fields.
		$general_attributes             = Recipe::get_general_attributes();
		$cooking_attributes['keywords'] = $general_attributes['keywords'];
		foreach ( $cooking_attributes as $name => $field ) {
			$placeholder = isset( $field['placeholder'] ) ? $field['placeholder'] : '';
			$value_key   = 'total_time' === $name ? 'total_time_raw' : $name;
			?>
			<fieldset class="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>-container">
				<label for="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>"><?php echo esc_html( $field['label'] ); ?></label>
				<input id="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>" type="text" placeholder="<?php echo esc_attr( $placeholder ); ?>" name="<?php echo sanitize_key( $name ); ?>" class="inline-field" value="{{ data.<?php echo sanitize_key( $value_key ); ?> }}" />
			</fieldset>
		<?php } ?>
		</div>

		<div class="tasty-recipes-video-url">
			<h3><?php esc_html_e( 'Video URL', 'tasty-recipes' ); ?></h3>
			<?php
			$video_attributes              = array();
			$video_attributes['video_url'] = $general_attributes['video_url'];
			foreach ( $video_attributes as $name => $field ) {
				$placeholder = isset( $field['placeholder'] ) ? $field['placeholder'] : '';
				$value_key   = $name;
				?>
				<fieldset class="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>-container">
					<input id="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>" type="text" placeholder="<?php echo esc_attr( $placeholder ); ?>" name="<?php echo sanitize_key( $name ); ?>" class="inline-field" value="{{ data.<?php echo sanitize_key( $value_key ); ?> }}" />
				</fieldset>
			<?php } ?>
		</div>

		<?php do_action( 'tasty_recipes_editor_after_video_url' ); ?>

		<div class="tasty-recipes-nutrition">
			<h3><?php esc_html_e( 'Nutrition', 'tasty-recipes' ); ?></h3>
		<?php
		$nutrition_attributes = Recipe::get_nutrition_attributes();
		$nutrition_attributes = array_reverse( $nutrition_attributes, true );
		// Add Nutrifox ID to the beginning of this set of attributes.
		$nutrition_attributes['nutrifox_id'] = $general_attributes['nutrifox_id'];
		$nutrition_attributes                = array_reverse( $nutrition_attributes, true );
		foreach ( $nutrition_attributes as $name => $field ) {
			$placeholder = isset( $field['placeholder'] ) ? $field['placeholder'] : '';
			?>
			<fieldset class="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>-container">
				<label for="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>"><?php echo esc_html( $field['label'] ); ?></label>
				<input id="<?php echo sanitize_key( 'tasty-recipes-recipe-' . $name ); ?>" type="text" placeholder="<?php echo esc_attr( $placeholder ); ?>" name="<?php echo sanitize_key( $name ); ?>" class="inline-field" value="{{ data.<?php echo sanitize_key( $name ); ?> }}" />
			</fieldset>
		<?php } ?>
		</div>
	</form>
</script>

<div class="tasty-recipes-modal-container" style="display:none">
	<div class="tasty-recipes-modal wp-core-ui">
		<button type="button" class="tasty-recipes-modal-close"><span class="tasty-recipes-modal-icon"><span class="screen-reader-text"><?php esc_html_e( 'Close Modal', 'tasty-recipes' ); ?></span></span></button>

		<div class="tasty-recipes-modal-content">
			<div class="tasty-recipes-frame wp-core-ui">
				<div class="tasty-recipes-frame-title">
					<h1 class="tasty-recipes-state-creating"><?php echo esc_html( 'Create Recipe' ); ?></h1>
					<h1 class="tasty-recipes-state-editing"><?php echo esc_html( 'Edit Recipe' ); ?></h1>
				</div>
				<div class="tasty-recipes-frame-content" tabindex="-1"></div>

				<div class="tasty-recipes-frame-toolbar">
					<div class="tasty-recipes-toolbar">
						<div class="tasty-recipes-toolbar-primary search-form">
							<button type="button" class="button tasty-recipes-button tasty-recipes-state-creating button-primary button-large tasty-recipes-button-insert"><?php esc_html_e( 'Insert', 'tasty-recipes' ); ?></button>
							<button type="button" class="button tasty-recipes-button tasty-recipes-state-editing button-primary button-large tasty-recipes-button-update"><?php esc_html_e( 'Update', 'tasty-recipes' ); ?></button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="tasty-recipes-modal-backdrop"></div>

</div>
