<?php
/**
 * Backwards-compat template for sites with EasyRecipe styling.
 *
 * @package Tasty_Recipes
 */

?>
<?php echo $recipe_styles; ?>

<?php if ( ! empty( $recipe_rating_label ) ) : ?>
<div class="ERSRatings" itemprop="aggregateRating" itemscope="" itemtype="https://schema.org/AggregateRating">
	<div class="ERSRatingOuter">
		<?php $average_rating = round( (float) $recipe->get_average_rating(), 1 ); ?>
		<div class="ERSRatingInner" style="width: <?php echo round( $average_rating * 2 * 10 ); ?>%"></div>
		<div class="review"><span class="rating"><span class="average" itemprop="ratingValue"><?php echo $average_rating; ?></span> from <span class="count" itemprop="ratingCount"><?php echo $recipe->get_total_reviews(); ?></span> reviews</span></div>
	</div>
</div>
<?php endif; ?>

<div itemprop="name" class="ERSName"><?php echo $recipe_json['title_rendered']; ?></div>

<div class="ERSClear"></div>

<div class="ERSDetails">
	<?php if ( ! empty( $recipe_details['author'] ) ) : ?>
	<div class="ERSAuthor"><?php echo $recipe_details['author']['label']; ?>:&nbsp;<?php echo $recipe_details['author']['value']; ?></div>
	<?php endif; ?>
	<?php
	foreach ( array( 'category', 'cuisine' ) as $detail ) :
		if ( empty( $recipe_details[ $detail ] ) ) {
			continue;
		}
		?>
		<div class="ERSHead"><?php echo $recipe_details[ $detail ]['label']; ?>:&nbsp;<?php echo $recipe_details[ $detail ]['value']; ?></div>
	<?php endforeach; ?>
	<div class="ERSClear"></div>
	<?php
	if ( ! empty( $recipe_details['prep_time'] ) || ! empty( $recipe_details['cook_time'] ) ) :
		?>
		<div class="ERSTimes">
			<?php
			foreach ( array( 'prep_time', 'cook_time', 'total_time' ) as $detail ) :
				if ( empty( $recipe_details[ $detail ] ) ) {
					continue;
				}
				?>
			<div class="ERSHead"><?php echo $recipe_details[ $detail ]['label']; ?>:&nbsp;<?php echo $recipe_details[ $detail ]['value']; ?></div>
		<?php endforeach; ?>
		</div>
		<div class="ERSClear"></div>
	<?php endif; ?>
	<?php if ( ! empty( $recipe_details['yield'] ) ) : ?>
	<div class="ERSHead"><?php echo $recipe_details['yield']['label']; ?>:&nbsp;<?php echo $recipe_details['yield']['value']; ?></div>
	<div class="ERSClear"></div>
	<?php endif; ?>
</div>

<?php if ( ! empty( $recipe_ingredients ) ) : ?>
	<div class="ERSIngredients">
		<div class="ERSIngredientsHeader ERSHeading"><?php esc_html_e( 'Ingredients', 'tasty-recipes' ); ?></div>
		<?php
		$recipe_ingredients = str_replace( '<li', '<li class="ingredient"', $recipe_ingredients );
		echo $recipe_ingredients;
		?>
		<div class="ERSClear"></div>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_instructions ) ) : ?>
	<div class="ERSInstructions">
		<div class="ERSInstructionsHeader ERSHeading"><?php esc_html_e( 'Instructions', 'tasty-recipes' ); ?></div>
		<?php
		$recipe_instructions = str_replace( '<li', '<li class="instruction"', $recipe_instructions );
		echo $recipe_instructions;
		?>
		<div class="ERSClear"></div>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_notes ) ) : ?>
	<div class="ERSNotesDiv">
		<div class="ERSNotesHeader"><?php esc_html_e( 'Notes', 'tasty-recipes' ); ?></div>
		<div class="ERSNotes">
			<?php echo $recipe_notes; ?>
		</div>
		<div class="ERSClear"></div>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_nutrifox_id ) ) : ?>
	<div class="ERSNutrifox">
		<div class="nutrifox-label" data-recipe-id="<?php echo (int) $recipe_nutrifox_id; ?>"></div>
		<script async src="https://nutrifox.com/embed.js" charset="utf-8"></script>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_nutrition ) ) : ?>
	<div class="nutrition" itemscope itemprop="nutrition" itemtype="https://schema.org/NutritionInformation">
		<div class="ERSNutritionHeader"><?php esc_html_e( 'Nutrition', 'tasty-recipes' ); ?></div>
		<div class="ERSNutrionDetails">
			<?php foreach ( $recipe_nutrition as $nutrition ) : ?>
				<?php echo $nutrition['label']; ?>:</strong>&nbsp;<?php echo $nutrition['value']; ?>&nbsp;
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>
