<?php
/**
 * Default recipe template.
 *
 * @package Tasty_Recipes
 */

?>

<?php echo $recipe_styles; ?>

<h2><?php echo $recipe_title; ?></h2>

<?php if ( ! empty( $recipe_image ) ) : ?>
	<div class="tasty-recipes-image">
		<?php echo $recipe_image; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_rating_icons ) || ! empty( $recipe_rating_label ) ) : ?>
	<div class="tasty-recipes-rating">
		<?php if ( Tasty_Recipes\Ratings::is_enabled() ) : ?>
			<a href="#respond">
		<?php endif; ?>
			<?php if ( ! empty( $recipe_rating_icons ) ) : ?>
				<p><?php echo $recipe_rating_icons; ?></p>
			<?php endif; ?>
			<?php if ( ! empty( $recipe_rating_label ) ) : ?>
				<p><?php echo $recipe_rating_label; ?></p>
			<?php endif; ?>
		<?php if ( Tasty_Recipes\Ratings::is_enabled() ) : ?>
			</a>
		<?php endif; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_print_button ) && ! tasty_recipes_is_print() ) : ?>
	<?php echo $recipe_print_button; ?>
<?php endif; ?>

<?php if ( ! empty( $recipe_description ) ) : ?>
	<div class="tasty-recipes-description">
		<?php echo $recipe_description; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_details ) ) : ?>
	<div class="tasty-recipes-details">
		<ul>
			<?php foreach ( $recipe_details as $detail ) : ?>
				<li class="<?php echo esc_attr( $detail['class'] ); ?>"><strong class="tasty-recipes-label"><?php echo $detail['label']; ?>:</strong> <?php echo $detail['value']; ?></li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_ingredients ) ) : ?>
	<div class="tasty-recipe-ingredients">
		<?php if ( ! empty( $recipe_scalable ) ) : ?>
			<span class="tasty-recipes-scale-container">
				<span class="tasty-recipes-scale-label"><?php esc_html_e( 'Scale', 'tasty-recipes' ); ?></span>
				<?php echo $recipe_scalable; ?>
			</span>
		<?php endif; ?>
		<h3><?php esc_html_e( 'Ingredients', 'tasty-recipes' ); ?></h3>
		<?php echo $recipe_ingredients; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_instructions ) ) : ?>
	<div class="tasty-recipe-instructions">
		<h3><?php esc_html_e( 'Instructions', 'tasty-recipes' ); ?></h3>
		<?php echo $recipe_instructions; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_video_embed ) ) : ?>
	<div class="tasty-recipe-video-embed">
		<?php echo $recipe_video_embed; ?>
	</div>
<?php endif; ?>

<?php
if ( ! empty( $recipe_equipment ) ) :
	?>
	<div class="tasty-recipes-equipment">
		<h3><?php esc_html_e( 'Equipment', 'tasty-recipes' ); ?></h3>
		<?php echo $recipe_equipment; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_notes ) ) : ?>
	<div class="tasty-recipes-notes">
		<h3><?php esc_html_e( 'Notes', 'tasty-recipes' ); ?></h3>
		<?php echo $recipe_notes; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_nutrifox_embed ) ) : ?>
	<div class="tasty-recipes-nutrifox">
		<?php echo $recipe_nutrifox_embed; ?>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_nutrition ) ) : ?>
	<div class="tasty-recipes-nutrition">
		<h3><?php esc_html_e( 'Nutrition', 'tasty-recipes' ); ?></h3>
		<ul>
			<?php foreach ( $recipe_nutrition as $nutrition ) : ?>
				<li><strong class="tasty-recipes-label"><?php echo $nutrition['label']; ?>:</strong> <?php echo $nutrition['value']; ?></li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>

<?php if ( ! empty( $recipe_keywords ) ) : ?>
	<div class="tasty-recipes-keywords">
		<p><em><strong><?php esc_html_e( 'Keywords', 'tasty-recipes' ); ?>:</strong> <?php echo $recipe_keywords; ?></em></p>
	</div>
<?php endif; ?>

<?php if ( ! empty( $instagram_handle ) ) : ?>
<footer class="tasty-recipes-entry-footer">
	<h3><?php esc_html_e( 'Did you make this recipe?', 'tasty-recipes' ); ?></h3>
	<p><?php esc_html_e( 'Tag', 'tasty-recipes' ); ?> <a href="<?php echo esc_url( 'https://www.instagram.com/' . $instagram_handle ); ?>" target="_blank">@<?php echo $instagram_handle; ?></a> <?php esc_html_e( 'on Instagram', 'tasty-recipes' ); ?>
		<?php if ( ! empty( $instagram_hashtag ) ) : ?>
			<?php esc_html_e( 'and hashtag it', 'tasty-recipes' ); ?> <a href="<?php echo esc_url( 'https://www.instagram.com/explore/tags/' . $instagram_hashtag ); ?>" target="_blank">#<?php echo $instagram_hashtag; ?></a>
		<?php endif; ?>
	</p>
</footer>
<?php endif; ?>

<?php if ( tasty_recipes_is_print() && get_post() ) : ?>
	<div class="tasty-recipes-source-link">
		<p><strong class="tasty-recipes-label"><?php esc_html_e( 'Find it online', 'tasty-recipes' ); ?></strong>: <a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo esc_url( get_permalink( get_the_ID() ) ); ?></a></p>
	</div>
<?php endif; ?>

<?php echo $recipe_scripts; ?>
