<?php
/**
 * Template for the settings page.
 *
 * @package Tasty_Recipes
 */

?>

<?php

$active_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : 'settings';

?>

<div class="wrap">

	<h1><?php esc_html_e( 'Tasty Recipes', 'tasty-recipes' ); ?></h1>

	<div class="nav-tab-wrapper">
		<p><a class="nav-tab<?php echo 'settings' === $active_tab ? ' nav-tab-active' : ''; ?>" href="<?php menu_page_url( Tasty_Recipes\Admin::PAGE_SLUG, true ); ?>"><?php esc_html_e( 'Settings', 'tasty-recipes' ); ?></a></p>
		<p><a class="nav-tab<?php echo 'about' === $active_tab ? ' nav-tab-active' : ''; ?>" href="<?php echo menu_page_url( Tasty_Recipes\Admin::PAGE_SLUG, false ) . '&tab=about'; ?>"><?php esc_html_e( 'About', 'tasty-recipes' ); ?></a></p>
		<p><a class="nav-tab" target="_blank" href="http://support.wptasty.com"><?php esc_html_e( 'FAQs and Support', 'tasty-recipes' ); ?></a></p>
	</div>

	<?php
	if ( 'about' === $active_tab ) :
		?>
		<?php include dirname( __FILE__ ) . '/about.php'; ?>
	<?php else : ?>

	<form method="POST" action="<?php echo esc_url( admin_url( 'options.php' ) ); ?>">
		<?php
			settings_fields( Tasty_Recipes\Admin::SETTINGS_GROUP_CARD );
			do_settings_sections( Tasty_Recipes\Admin::PAGE_SLUG );
		?>
		<?php submit_button(); ?>
	</form>

	<h2><?php esc_html_e( 'Recipe Converter', 'tasty-recipes' ); ?></h2>

	<div class="tasty-recipes-converter-wrap postbox">
		<div class="tasty-recipes-converter-column">
			<ul class="tasty-recipes-converter-options">
				<?php foreach ( Tasty_Recipes::get_converters() as $converter => $config ) : ?>
					<li><button disabled class="button" data-label="<?php echo esc_attr( $config['label'] ); ?>" data-type="<?php echo esc_attr( $converter ); ?>"><?php echo esc_html( $config['label'] ); ?></button></li>
				<?php endforeach; ?>
			</ul>
		</div>
		<div class="tasty-recipes-converter-column tasty-recipes-converter-panel">
			<div class="tasty-recipes-converter-welcome">
				<h3><?php esc_html_e( 'Convert Existing Recipes', 'tasty-recipes' ); ?></h3>
				<p>
				<?php
				// translators: Link to the conversion page.
				echo sprintf( __( 'Just in case, we recommend backing up your database before converting your recipes in bulk to Tasty Recipes. <a target="_blank" href="%s">Learn more about backing up your database</a>.', 'tasty-recipes' ), 'https://www.wptasty.com/convert-all' );
				?>
				</p>
				<p><?php echo esc_html_e( 'Select an option from the left to start converting recipes.', 'tasty-recipes' ); ?></p>
			</div>
			<div class="tasty-recipes-converter-control"></div>
		</div>
	</div>

</div>

<script type="text/html" id="tmpl-tasty-recipes-convert">
	<button type="button" class="tasty-recipes-converter-close"><span class="tasty-recipes-converter-icon"><span class="screen-reader-text"><?php esc_html_e( 'Close Converter', 'tasty-recipes' ); ?></span></span></button>

	<h3>
			<?php
			// translators: Source of the conversion.
			echo esc_html( sprintf( __( 'Convert recipes from %s', 'tasty-recipes' ), '{{ data.label }}' ) );
			?>
	</h3>

	<# if ( data.loading ) { #>
		<p><?php esc_html_e( 'Determining whether there are any recipes to convert.', 'tasty-recipes' ); ?></p>
	<# } #>
	<# if ( data.converting ) {
		if ( data.converted < data.count ) {
		#>
			<p>
			<?php
			// translators: Source of the conversion.
			echo esc_html( sprintf( __( 'Converting recipes from %s. Leave this window open until the conversion is complete.', 'tasty-recipes' ), '{{ data.label }}' ) );
			?>
			</p>
			<progress value="{{ data.converted }}" max="{{ data.count }}">
		<# } else { #>
			<p>
			<?php
			// translators: Source of the conversion.
			echo esc_html( sprintf( __( '%s conversion complete. You may now close this converter.', 'tasty-recipes' ), '{{ data.label }}' ) );
			?>
			</p>
		<# } #>
	<# } #>
	<# if ( data.errorMessage ) { #>
		<p>{{ data.errorMessage }}</p>
	<# } #>
	<# if ( ! data.loading && ! data.converting && ! data.errorMessage ) {
		if ( data.count ) {
			if ( 1 === data.count ) {
			#>
			<p>
			<?php
			// translators: Singular number of recipes, source.
			echo sprintf( __( '%1$s recipe was found to convert from %2$s.', 'tasty-recipes' ), '{{ data.count }}', '{{ data.label }}' );
			?>
			</p>
			<# } else { #>
			<p>
			<?php
			// translators: Plural number of recipes, source.
			echo sprintf( __( '%1$s recipes were found to convert from %2$s.', 'tasty-recipes' ), '{{ data.count }}', '{{ data.label }}' );
			?>
			</p>
			<# } #>
			<button class="button start-conversion"><?php esc_html_e( 'Start Conversion', 'tasty-recipes' ); ?></button>
		<# } else { #>
			<p>
			<?php
			// translators: Source of the conversion.
			echo esc_html( sprintf( __( 'No %s recipes were found to convert.', 'tasty-recipes' ), '{{ data.label }}' ) );
			?>
			</p>
		<# } #>
	<# } #>

</script>

<?php endif; ?>
