<?php

// [bold_timeline_container]

class Bold_Timeline_Container {
	static function init() {
		add_shortcode( 'bold_timeline_container', array( __CLASS__, 'handle_shortcode' ) );
	}

	static function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( array(
			'line_position'					=> 'left',
			'line_style'					=> 'solid',
			'line_thickness'				=> '',
			'line_color'					=> '',
			
			'item_style'					=> 'outline',
			'item_shape'					=> 'soft_rounded',
			'item_frame_thickness'			=> 'normal',
			'item_connection_type'			=> 'line',
			'item_connection_color'			=> '',
			'item_content_display'			=> 'show',
			'item_marker_type'				=> 'dot',
			'item_marker_color'				=> '',
			'item_title_size'				=> 'normal',
			'item_supertitle_style'			=> 'default',
			'item_sticker_color'			=> '',
			'item_alignment'				=> 'default',
			'item_title_font'				=> 'inherit',
			'item_body_font'				=> 'inherit',
			'item_font_subset'				=> '',
			'item_media_position'			=> 'bottom',
			'item_images_columns'			=> '2',
			'item_animation'				=> 'no_animation',
			'item_frame_color'				=> '',
			'item_background_color'			=> '',
			
			'item_icon_position'			=> 'opposite',
			'item_icon_shape'				=> 'soft_rounded',
			'item_icon_style'				=> 'filled',
			'item_icon_color'				=> '',
			
			'group_frame_thickness'			=> 'normal',
			'group_style'					=> 'outline',
			'group_shape'					=> 'soft_rounded',
			'group_frame_color'				=> '',
			'group_title_size'				=> 'default',
			'group_title_font'				=> 'inherit',
			'group_font_subset'				=> '',
			'group_content_display'			=> 'show',
			
			'button_style'					=> 'outline',
			'button_shape'					=> 'soft_rounded',
			'button_size'					=> 'normal',
			'button_color'					=> '',
			
			'slider_animation'				=> 'slide',
			'slider_height'					=> 'keep-height',
			'slider_gap'					=> 'normal',
			'slider_dots_style'				=> 'show',
			'slider_arrows_style'			=> 'filled',
			'slider_arrows_shape'			=> 'square',
			'slider_arrows_size'			=> 'normal',
			'slider_navigation_color'		=> '',
			'slider_slides_to_show'			=> '2',
			'slider_auto_play'				=> '0',
			
			'el_id'							=> '',
			'el_class'						=> '',
			'el_css'						=> '',
			'el_style'						=> '',
            'responsive'					=> ''
		), $atts, 'bold_timeline_container' ) );
		
		$prefix = 'bold_timeline_container';
		$class = array( $prefix );
		
		wp_register_style( 'bold-timeline', false );
		wp_enqueue_style( 'bold-timeline' );
		
		if ( $el_id == '' ) {
			$el_id = 'id_' . uniqid();
		} else {
			$el_id = 'id_' . $el_id . '_' . uniqid();
		}		
		$id_attr = ' ' . 'id="' . $el_id . '"';
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
                
        if ( $responsive != '' ) {
			$class[] = 'bold_timeline_responsive_' . $responsive;
		}
		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . $el_style . '"';
		}
		
		/* Container properties */
		
		$line_output = '';
		
		if ( $line_style != '' && $line_style != 'none' && $line_position != 'none' ) {
			$class[] = $prefix . '_line_style_' . $line_style;
			$class[] = $prefix . '_has_line_style';
			$line_output = '<div class = "bold_timeline_container_line"></div>';
		}

		if ( $line_thickness != '' ) {
			$class[] = $prefix . '_line_thickness_' . $line_thickness;
		}
		
		if ( $item_style != '' ) {
			$class[] = $prefix . '_item_style_' . $item_style;
		}
		
		if ( $line_position == 'center_overlap' || $line_position == 'center' || $line_position == 'left' || $line_position == 'right' || $line_position == 'none'  ) {
			$class[] = $prefix . '_line_position_vertical';
			$slider = false;
		} else {
			$class[] = $prefix . '_line_position_horizontal';
			$slider = true;
		} 
		
		if ( $line_position == 'center_overlap' ) {
			$class[] = $prefix . '_line_position_overlap';
			$class[] = $prefix . '_line_position_center';
		} else if ( $line_position != '' ) {
			$class[] = $prefix . '_line_position_' . $line_position;
		}
		
		/* Item properties */
		
		if ( $item_frame_thickness != '' ) {
			$class[] = $prefix . '_item_frame_thickness_' . $item_frame_thickness;
		}

		if ( $item_shape != '' ) {
			$class[] = $prefix . '_item_shape_' . $item_shape;
		}
				
		if ( $item_icon_position != '' ) {
			$class[] = $prefix . '_item_icon_position_' . $item_icon_position;
		}
				
		if ( $item_icon_shape != '' ) {
			$class[] = $prefix . '_item_icon_shape_' . $item_icon_shape;
		}
				
		if ( $item_icon_style != '' ) {
			$class[] = $prefix . '_item_icon_style_' . $item_icon_style;
		}
		
		if ( $item_connection_type != '' ) {
			$class[] = $prefix . '_item_connection_type_' . $item_connection_type;
		}
		
		if ( $item_content_display != '' ) {
			$class[] = $prefix . '_item_content_display_' . $item_content_display;
		}
		
		if ( $item_marker_type != '' ) {
			$class[] = $prefix . '_item_marker_type_' . $item_marker_type;
		}

		if ( $item_title_size != '' ) {
			$class[] = $prefix . '_item_title_size_' . $item_title_size;
		}

		if ( $item_supertitle_style != '' ) {
			$class[] = $prefix . '_item_supertitle_style_' . $item_supertitle_style;
		}

		if ( $item_alignment != '' ) {
			$class[] = $prefix . '_item_alignment_' . $item_alignment;
		}
		
		wp_register_style( 'bold-timeline-footer', false );
		
		if ( $item_body_font != '' && $item_body_font != 'inherit' ) {
			bold_timeline_enqueue_google_font( $item_body_font, $item_font_subset );
			$custom_css = '#' . $el_id . ' { font-family:\'' . urldecode( $item_body_font ) . '\' } ';
			wp_add_inline_style( 'bold-timeline-footer', $custom_css );
		}
		
		if ( $item_title_font != '' && $item_title_font != 'inherit' ) {
			bold_timeline_enqueue_google_font( $item_title_font, $item_font_subset );
			$custom_css  = '#' . $el_id . ' .bold_timeline_item h1, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_item h2, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_item h3, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_item h4, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_item h5, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_item h6 ';
			$custom_css .= ' { font-family:\'' . urldecode( $item_title_font ) . '\' } ';
			wp_add_inline_style( 'bold-timeline-footer', $custom_css );
		}
		
		if ( $group_title_font != '' && $group_title_font != 'inherit' ) {
			bold_timeline_enqueue_google_font( $group_title_font, $group_font_subset );
			$custom_css  = '#' . $el_id . ' .bold_timeline_group_header h1, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_group_header h2, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_group_header h3, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_group_header h4, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_group_header h5, ';
			$custom_css .= '#' . $el_id . ' .bold_timeline_group_header h6 ';
			$custom_css .= ' { font-family:\'' . urldecode( $group_title_font ) . '\' } ';
			wp_add_inline_style( 'bold-timeline-footer', $custom_css );
		}
		
		if ( $el_css != '' ) {
			$el_css = str_replace( '#this', '#' . $el_id , $el_css );
			wp_add_inline_style( 'bold-timeline-footer', $el_css );
		}
		
		if ( $item_media_position != '' ) {
			$class[] = $prefix . '_item_media_position_' . $item_media_position;
		}

		if ( $item_images_columns != '' ) {
			$class[] = $prefix . '_item_images_columns_' . $item_images_columns;
		}

		if ( $item_animation != '' && $item_animation != 'no_animation' ) {
			$item_animations = explode( ' ', $item_animation );
			foreach ( $item_animations as $anim) {
				$class[] = $prefix . '_item_animation_' . $anim;
			}
		}
		
		/* Group properties */
		
		if ( $group_style != '' ) {
			$class[] = $prefix . '_group_style_' . $group_style;
		}
		
		if ( $group_shape != '' ) {
			$class[] = $prefix . '_group_shape_' . $group_shape;
		}
		
		if ( $group_frame_thickness != '' ) {
			$class[] = $prefix . '_group_thickness_' . $group_frame_thickness;
		}
		
		if ( $group_content_display != '' ) {
			$class[] = $prefix . '_group_content_display_' . $group_content_display;
		}
		
		if ( $button_style != '' ) {
			$class[] = $prefix . '_button_style_' . $button_style;
		}
		
		if ( $button_shape != '' ) {
			$class[] = $prefix . '_button_shape_' . $button_shape;
		}
		
		if ( $button_size != '' ) {
			$class[] = $prefix . '_button_size_' . $button_size;
		}

		if ( $group_title_size != '' ) {
			$class[] = $prefix . '_group_title_size_' . $group_title_size;
		}
		
		/* Slider properties */
		
		$data_slick = '';
		
		if ( $slider ) {
			
			$data_slick .= ' ' . 'data-slick=\'{ "lazyLoad": "progressive", "cssEase": "ease-in", "speed": "500", "infinite": false';
			
			if ( $slider_animation == 'fade' ) {
				$data_slick .= ', "fade": true';
				$slider_slides_to_show = 1;
			}
			
			if ( $slider_height != 'keep-height' ) {
				$data_slick .= ', "adaptiveHeight": true';
			}
			
			if ( $slider_gap != '' ) {
				$class[] = $prefix . '_gap_' . $slider_gap;
			}
			
			if ( $slider_dots_style != 'hide' ) {
				$data_slick .= ', "dots": true, "dotsClass": "bold_timeline_slick_dots"' ;
				$class[] = $prefix . '_slider_dots_style_' . $slider_dots_style;
			}
			
			if ( $slider_arrows_shape != '' ) {
				$class[] = $prefix . '_slider_arrows_shape_' . $slider_arrows_shape;
			}
			
			if ( $slider_arrows_size != '' ) {
				$class[] = $prefix . '_slider_arrows_size_' . $slider_arrows_size;
			}

			if ( $slider_arrows_style != 'hide' ) {
				$data_slick  .= ', "prevArrow": "&lt;button type=\"button\" class=\"bold_timeline_slick_prev bold_timeline_slick_arrow\"&gt;", "nextArrow": "&lt;button type=\"button\" class=\"bold_timeline_slick_next bold_timeline_slick_arrow\"&gt;"';
				$class[] = $prefix . '_slider_arrows_style_' . $slider_arrows_style;
			} else {
				$data_slick  .= ', "prevArrow": "", "nextArrow": ""';
			}
			
			if ( intval( $slider_slides_to_show ) > 0 ) {
				$data_slick .= ',"slidesToShow": ' . intval( $slider_slides_to_show );
				$class[] = $prefix . '_multiple_slides';
			}
			
			if ( $slider_auto_play != '' && intval( $slider_auto_play ) > 0 ) {
				$data_slick .= ',"autoplay": true, "autoplaySpeed": ' . intval( $slider_auto_play );
			}
			
			if ( is_rtl() ) {
				$data_slick .= ', "rtl": true' ;
			}
			
			if ( $slider_slides_to_show > 1 ) {
				$data_slick .= ', "responsive": [';
				if ( $slider_slides_to_show > 1 ) {
					$data_slick .= '{ "breakpoint": 768, "settings": { "slidesToShow": 1, "slidesToScroll": 2 } }';	
				}
				if ( $slider_slides_to_show > 2 ) {
					$data_slick .= ',{ "breakpoint": 920, "settings": { "slidesToShow": 2, "slidesToScroll": 3 } }';	
				}
				if ( $slider_slides_to_show > 3 ) {
					$data_slick .= ',{ "breakpoint": 1024, "settings": { "slidesToShow": 3, "slidesToScroll": 3 } }';	
				}				
				$data_slick .= ']';
			}
			
			$data_slick = $data_slick . '}\' ';
	
			wp_enqueue_script( 'bt_bb_slick', plugins_url( '../../assets/js/slick/slick.min.js', __FILE__  ), array( 'jquery' ) );
			wp_enqueue_style( 'bt_bb_slick', plugins_url( '../../assets/js/slick/slick.css', __FILE__ ) );
			wp_enqueue_style( 'bt_bb_slick-theme', plugins_url( '../../assets/js/slick/slick-theme.css', __FILE__ ) );			
			
		}

		$css_override = '';
		Bold_Timeline::$crush_vars = array();
		
		if ( $line_color != '' ) {
			Bold_Timeline::$crush_vars['defaultLineColor'] = $line_color;
			$css_override_temp = $css_override;
			require( dirname(__FILE__) . '/../../css-override-container.php' );
			$css_override = $css_override_temp . $css_override;
		}
		
		if ( $group_frame_color != '' ) {
			Bold_Timeline::$crush_vars['defaultGroupColor'] = $group_frame_color;
			$css_override_temp = $css_override;
			require( dirname(__FILE__) . '/../../css-override-group.php' );
			$css_override = $css_override_temp . $css_override;

		}
		
		if ( $item_background_color != '' || $item_frame_color != '' || $item_icon_color != '' || $item_marker_color != '' || $item_connection_color != '' || $item_sticker_color != '' ) {
			if ( $item_background_color != '' ) {
				Bold_Timeline::$crush_vars['defaultItemBackgroundColor'] = $item_background_color;		
			}
			if ( $item_frame_color != '' ) {
				Bold_Timeline::$crush_vars['defaultFrameColor'] = $item_frame_color;		
			}
			if ( $item_connection_color != '' ) {
				Bold_Timeline::$crush_vars['defaultConnectionColor'] = $item_connection_color;	
			} else {
				Bold_Timeline::$crush_vars['defaultConnectionColor'] = '';
			}
			if ( $item_sticker_color != '' ) {
				Bold_Timeline::$crush_vars['defaultStickerColor'] = $item_sticker_color;	
			} else {
				Bold_Timeline::$crush_vars['defaultStickerColor'] = '';
			}
			if ( $item_icon_color != '' ) {
				Bold_Timeline::$crush_vars['defaultIconColor'] = $item_icon_color;	
			} else {
				Bold_Timeline::$crush_vars['defaultIconColor'] = '';
			}
			if ( $item_marker_color != '' ) {
				Bold_Timeline::$crush_vars['defaultMarkerColor'] = $item_marker_color;
			} else {
				Bold_Timeline::$crush_vars['defaultMarkerColor'] = '';
			}
			
			$css_override_temp = $css_override;
			require( dirname(__FILE__) . '/../../css-override-item.php' );
			$css_override = $css_override_temp . $css_override;
		}
		
		if ( $slider_navigation_color != '' ) {
			
			if ( $slider_navigation_color != '' ) {
				Bold_Timeline::$crush_vars['defaultSliderNavigationColor'] = $slider_navigation_color;
			} else {
				Bold_Timeline::$crush_vars['defaultSliderNavigationColor'] = '';
			}
			
			$css_override_temp = $css_override;
			require( dirname(__FILE__) . '/../../css-override-slider.php' );
			$css_override = $css_override_temp . $css_override;
		}
		
		if ( $button_color != '' ) {
			if ( $button_color != '' ) Bold_Timeline::$crush_vars['defaultButtonColor'] = $button_color;	
			$css_override_temp = $css_override;
			require( dirname(__FILE__) . '/../../css-override-button.php' );
			$css_override = $css_override_temp . $css_override;
		}
		
		/* Output */
		
		$output = '<div class="' . implode( ' ', $class ) . '"' . $id_attr . $style_attr . ' data-css-override="' . $css_override . '">';
			$output .= $line_output;
			$output .= '<div class="bold_timeline_container_content"' . $data_slick . '>';
				$output .= wptexturize( do_shortcode( $content ) );
			$output .= '</div>';
		$output .= '</div>';

		return $output;
	}
}

Bold_Timeline_Container::init();

// Map shortcode

function bold_timeline_map_container() {
	
	require( dirname(__FILE__) . '/../../content_elements_misc/fonts.php' );
	
	$bold_timeline_container_params = array(
		array( 'param_name' => 'line_position', 'type' => 'dropdown', 'default' => 'left', 'heading' => esc_html__( 'Line position', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Left', 'bold-timeline' ) 							=> 'left',
				esc_html__( 'Right', 'bold-timeline' ) 							=> 'right',
				esc_html__( 'Center', 'bold-timeline' ) 						=> 'center',
				esc_html__( 'Center overlap', 'bold-timeline' ) 				=> 'center_overlap',
				esc_html__( 'Top (horizontal timeline)', 'bold-timeline' ) 		=> 'top',
				esc_html__( 'Bottom (horizontal timeline)', 'bold-timeline' )	=> 'bottom'
			)
		),
		array( 'param_name' => 'line_style', 'type' => 'dropdown', 'default' => 'solid', 'heading' => esc_html__( 'Line style', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'No line', 'bold-timeline' ) 		=> 'none',
				esc_html__( 'Solid', 'bold-timeline' ) 			=> 'solid',
				esc_html__( 'Dotted', 'bold-timeline' ) 		=> 'dotted',
				esc_html__( 'Dashed', 'bold-timeline' ) 		=> 'dashed'
			)
		),
		array( 'param_name' => 'line_thickness', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Line thickness', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Thin', 'bold-timeline' ) 			=> 'thin',
				esc_html__( 'Normal', 'bold-timeline' ) 		=> 'normal',
				esc_html__( 'Thick', 'bold-timeline' ) 			=> 'thick'
			)
		),
		array( 'param_name' => 'line_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Line color', 'bold-timeline' ), 'preview' => true ),
		array( 'param_name' => 'item_style', 'type' => 'dropdown', 'default' => 'outline', 'heading' => esc_html__( 'Style', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Clear', 'bold-timeline' ) 							=> 'clear',
				esc_html__( 'Outline', 'bold-timeline' ) 						=> 'outline',
				esc_html__( 'Full outline', 'bold-timeline' ) 					=> 'outline_full',
				esc_html__( 'Top border', 'bold-timeline' ) 					=> 'outline_top',
				esc_html__( 'Filled header', 'bold-timeline' ) 					=> 'filled_header',
				esc_html__( 'Filled header with outline', 'bold-timeline' ) 	=> 'filled_header_outline'
			)
		),
		array( 'param_name' => 'item_shape', 'type' => 'dropdown', 'default' => 'soft_rounded', 'heading' => esc_html__( 'Shape', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Square', 'bold-timeline' ) 		=> 'square',
				esc_html__( 'Soft rounded', 'bold-timeline' ) 	=> 'soft_rounded',
				esc_html__( 'Hard rounded', 'bold-timeline' ) 	=> 'hard_rounded'
			)
		),
		array( 'param_name' => 'item_frame_thickness', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Frame thickness', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Thin', 'bold-timeline' ) 			=> 'thin',
				esc_html__( 'Normal', 'bold-timeline' ) 		=> 'normal',
				esc_html__( 'Thick', 'bold-timeline' ) 			=> 'thick'
			)
		),
		array( 'param_name' => 'item_frame_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Frame color', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true ),
		array( 'param_name' => 'item_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ) ),
		array( 'param_name' => 'item_animation', 'type' => 'dropdown', 'default' => 'no_animation', 'heading' => esc_html__( 'Animation', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 
			'value' => array(
				esc_html__( 'No Animation', 'bold-builder' ) => 'no_animation',
				esc_html__( 'Fade In', 'bold-builder' ) => 'fade_in',
				esc_html__( 'Move Up', 'bold-builder' ) => 'move_up',
				esc_html__( 'Move Left', 'bold-builder' ) => 'move_left',
				esc_html__( 'Move Right', 'bold-builder' ) => 'move_right',
				esc_html__( 'Move Down', 'bold-builder' ) => 'move_down',
				esc_html__( 'Zoom in', 'bold-builder' ) => 'zoom_in',
				esc_html__( 'Zoom out', 'bold-builder' ) => 'zoom_out',
				esc_html__( 'Fade In / Move Up', 'bold-builder' ) => 'fade_in move_up',
				esc_html__( 'Fade In / Move Left', 'bold-builder' ) => 'fade_in move_left',
				esc_html__( 'Fade In / Move Right', 'bold-builder' ) => 'fade_in move_right',
				esc_html__( 'Fade In / Move Down', 'bold-builder' ) => 'fade_in move_down',
				esc_html__( 'Fade In / Zoom in', 'bold-builder' ) => 'fade_in zoom_in',
				esc_html__( 'Fade In / Zoom out', 'bold-builder' ) => 'fade_in zoom_out'
			)
		),
		array( 'param_name' => 'item_content_display', 'type' => 'dropdown', 'default' => 'show', 'heading' => esc_html__( 'Content display', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Show', 'bold-timeline' ) 			=> 'show',
				esc_html__( 'Hide', 'bold-timeline' ) 			=> 'hide'
			)
		),
		array( 'param_name' => 'item_connection_type', 'type' => 'dropdown', 'default' => 'line', 'heading' => esc_html__( 'Connector style', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'None', 'bold-timeline' ) 			=> 'none',
				esc_html__( 'Line', 'bold-timeline' ) 			=> 'line',
				esc_html__( 'Triangle', 'bold-timeline' ) 		=> 'triangle'
			)
		),
		array( 'param_name' => 'item_connection_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Connector color', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ) ),
		array( 'param_name' => 'item_marker_type', 'type' => 'dropdown', 'default' => 'dot', 'heading' => esc_html__( 'Marker style', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'None', 'bold-timeline' ) 			=> 'none',
				esc_html__( 'Dot', 'bold-timeline' ) 			=> 'dot',
				esc_html__( 'Circle', 'bold-timeline' ) 		=> 'circle',
				esc_html__( 'Small circle', 'bold-timeline' ) 	=> 'circle_small'
			)
		),
		array( 'param_name' => 'item_marker_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Marker color', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ) ),
		array( 'param_name' => 'item_icon_shape', 'type' => 'dropdown', 'default' => 'soft_rounded', 'heading' => esc_html__( 'Icon shape', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Hard rounded', 'bold-timeline' ) 					=> 'hard_rounded',
				esc_html__( 'Soft rounded', 'bold-timeline' ) 					=> 'soft_rounded',
				esc_html__( 'Square', 'bold-timeline' ) 						=> 'square'
			)
		),
		array( 'param_name' => 'item_icon_style', 'type' => 'dropdown', 'default' => 'filled', 'heading' => esc_html__( 'Icon style', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Outline', 'bold-timeline' ) 						=> 'outline',
				esc_html__( 'Filled', 'bold-timeline' ) 						=> 'filled',
				esc_html__( 'Shadow', 'bold-timeline' ) 						=> 'shadow'
			)
		),
		array( 'param_name' => 'item_icon_position', 'type' => 'dropdown', 'default' => 'opposite', 'heading' => esc_html__( 'Icon position', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'On the line', 'bold-timeline' ) 				=> 'line',
				esc_html__( 'Opposite to the line', 'bold-timeline' ) 		=> 'opposite'
			)
		),
		array( 'param_name' => 'item_icon_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Icon color', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ) ),
		array( 'param_name' => 'item_media_position', 'type' => 'dropdown', 'default' => 'bottom', 'heading' => esc_html__( 'Media position', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Bottom', 'bold-timeline' ) 		=> 'bottom',
				esc_html__( 'Top', 'bold-timeline' ) 			=> 'top',
				esc_html__( 'Left', 'bold-timeline' ) 			=> 'left',
				esc_html__( 'Right', 'bold-timeline' ) 			=> 'right'
			)
		),
		array( 'param_name' => 'item_images_columns', 'type' => 'dropdown', 'default' => '2', 'heading' => esc_html__( 'Media image gallery columns', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 
			'value' => array(
				esc_html__( '1', 'bold-timeline' ) 				=> '1',
				esc_html__( '2', 'bold-timeline' ) 				=> '2',
				esc_html__( '3', 'bold-timeline' ) 				=> '3',
				esc_html__( '4', 'bold-timeline' ) 				=> '4'
			)
		),
		array( 'param_name' => 'item_title_size', 'type' => 'dropdown', 'default' => 'default', 'heading' => esc_html__( 'Title size', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Default', 'bold-timeline' ) 	=> 'default',
				esc_html__( 'Small', 'bold-timeline' ) 		=> 'small',
				esc_html__( 'Normal', 'bold-timeline' ) 	=> 'normal',
				esc_html__( 'Large', 'bold-timeline' ) 		=> 'large'
			)
		),
		array( 'param_name' => 'item_supertitle_style', 'type' => 'dropdown', 'default' => 'inherit', 'heading' => esc_html__( 'Supertitle style', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Inherit', 'bold-timeline' ) 		=> 'inherit',
				esc_html__( 'Default', 'bold-timeline' ) 		=> 'default',
				esc_html__( 'Sticker', 'bold-timeline' ) 		=> 'sticker'
			)
		),
		array( 'param_name' => 'item_sticker_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Sticker color', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ) ),
		array( 'param_name' => 'item_title_font', 'type' => 'dropdown', 'heading' => esc_html__( 'Title font', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array( esc_html__( 'Inherit', 'bold-timeline' ) => 'inherit' ) + $font_arr
		),
		array( 'param_name' => 'item_body_font', 'type' => 'dropdown', 'heading' => esc_html__( 'Body font', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ),
			'value' => array( esc_html__( 'Inherit', 'bold-timeline' ) => 'inherit' ) + $font_arr
		),
		array( 'param_name' => 'item_font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Font subset', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'value' => 'latin,latin-ext', 'description' => 'E.g. latin,latin-ext,cyrillic,cyrillic-ext' ),
		array( 'param_name' => 'item_alignment', 'type' => 'dropdown', 'default' => 'default', 'heading' => esc_html__( 'Item alignment', 'bold-timeline' ), 'group' => esc_html__( 'Items', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Default', 'bold-timeline' ) 		=> 'default',
				esc_html__( 'Left', 'bold-timeline' ) 			=> 'left',
				esc_html__( 'Right', 'bold-timeline' ) 			=> 'right',
				esc_html__( 'Center', 'bold-timeline' ) 		=> 'center'
			)
		),
		array( 'param_name' => 'group_shape', 'type' => 'dropdown', 'default' => 'soft_rounded', 'heading' => esc_html__( 'Group shape', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Square', 'bold-timeline' ) 		=> 'square',
				esc_html__( 'Soft rounded', 'bold-timeline' ) 	=> 'soft_rounded',
				esc_html__( 'Hard rounded', 'bold-timeline' ) 	=> 'hard_rounded',
				esc_html__( 'Circle', 'bold-timeline' ) 		=> 'circle'
			)
		),
		array( 'param_name' => 'group_style', 'type' => 'dropdown', 'default' => 'outline', 'heading' => esc_html__( 'Group style', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Clear', 'bold-timeline' ) 							=> 'clear',
				esc_html__( 'Outline', 'bold-timeline' ) 						=> 'outline',
				esc_html__( 'Filled', 'bold-timeline' ) 						=> 'filled',
				esc_html__( 'Shadow', 'bold-timeline' ) 						=> 'shadow'
			)
		),
		array( 'param_name' => 'group_frame_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Group frame color', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ) ),
		array( 'param_name' => 'group_frame_thickness', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Group frame thickness', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Thin', 'bold-timeline' ) 			=> 'thin',
				esc_html__( 'Normal', 'bold-timeline' ) 		=> 'normal',
				esc_html__( 'Thick', 'bold-timeline' ) 			=> 'thick'
			)
		),
		array( 'param_name' => 'group_title_size', 'type' => 'dropdown', 'default' => 'default', 'heading' => esc_html__( 'Group title size', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Default', 'bold-timeline' ) 	=> 'default',
				esc_html__( 'Small', 'bold-timeline' ) 		=> 'small',
				esc_html__( 'Normal', 'bold-timeline' ) 	=> 'normal',
				esc_html__( 'Large', 'bold-timeline' ) 		=> 'large'
			)
		),
		array( 'param_name' => 'group_title_font', 'type' => 'dropdown', 'heading' => esc_html__( 'Title font', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ),
			'value' => array( esc_html__( 'Inherit', 'bold-timeline' ) => 'inherit' ) + $font_arr
		),
		array( 'param_name' => 'group_font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Font subset', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ), 'value' => 'latin,latin-ext', 'description' => 'E.g. latin,latin-ext,cyrillic,cyrillic-ext' ),
		array( 'param_name' => 'group_content_display', 'type' => 'dropdown', 'default' => 'show', 'heading' => esc_html__( 'Group content display', 'bold-timeline' ), 'group' => esc_html__( 'Groups', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Show', 'bold-timeline' ) 			=> 'show',
				esc_html__( 'Hide', 'bold-timeline' ) 			=> 'hide'
			)
		),
		array( 'param_name' => 'button_style', 'type' => 'dropdown', 'default' => 'outline', 'heading' => esc_html__( 'Buttons style', 'bold-timeline' ), 'group' => esc_html__( 'Buttons', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Outline', 'bold-timeline' ) 		=> 'outline',
				esc_html__( 'Filled', 'bold-timeline' ) 		=> 'filled',
				esc_html__( 'Shadow', 'bold-timeline' ) 		=> 'shadow',
				esc_html__( 'Clear', 'bold-timeline' ) 			=> 'clear'
			)
		),
		array( 'param_name' => 'button_shape', 'type' => 'dropdown', 'default' => 'soft_rounded', 'heading' => esc_html__( 'Buttons shape', 'bold-timeline' ), 'group' => esc_html__( 'Buttons', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Square', 'bold-timeline' ) 		=> 'square',
				esc_html__( 'Soft rounded', 'bold-timeline' ) 	=> 'soft_rounded',
				esc_html__( 'Hard rounded', 'bold-timeline' ) 	=> 'hard_rounded'
			)
		),
		array( 'param_name' => 'button_size', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Buttons size', 'bold-timeline' ), 'group' => esc_html__( 'Buttons', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Small', 'bold-timeline' ) 		=> 'small',
				esc_html__( 'Normal', 'bold-timeline' ) 	=> 'normal',
				esc_html__( 'Large', 'bold-timeline' ) 		=> 'large'
			)
		),
		array( 'param_name' => 'button_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Button color', 'bold-timeline' ), 'group' => esc_html__( 'Buttons', 'bold-timeline' ) ),
		array( 'param_name' => 'slider_height', 'type' => 'dropdown', 'heading' => esc_html__( 'Height', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Auto', 'bold-timeline' ) 			=> 'auto',
				esc_html__( 'Keep height', 'bold-timeline' ) 	=> 'keep-height'
			)
		),
		array( 'param_name' => 'slider_animation', 'type' => 'dropdown', 'heading' => esc_html__( 'Animation', 'bold-timeline' ), 'description' => esc_html__( 'If fade is selected, number of slides to show will be 1', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Default', 'bold-timeline' ) 		=> 'slide',
				esc_html__( 'Fade', 'bold-timeline' ) 			=> 'fade'
			)
		),
		array( 'param_name' => 'slider_arrows_style', 'default' => 'filled', 'type' => 'dropdown', 'heading' => esc_html__( 'Navigation arrows style', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'None', 'bold-timeline' ) 			=> 'none',
				esc_html__( 'Outline', 'bold-timeline' ) 		=> 'outline',
				esc_html__( 'Filled', 'bold-timeline' ) 		=> 'filled',
				esc_html__( 'Shadow', 'bold-timeline' ) 		=> 'shadow'
			)
		),
		array( 'param_name' => 'slider_arrows_shape', 'default' => 'square', 'type' => 'dropdown', 'heading' => esc_html__( 'Navigation arrows shape', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Square', 'bold-timeline' ) 		=> 'square',
				esc_html__( 'Soft rounded', 'bold-timeline' ) 	=> 'soft_rounded',
				esc_html__( 'Hard rounded', 'bold-timeline' ) 	=> 'hard_rounded',
				esc_html__( 'Circle', 'bold-timeline' ) 		=> 'circle'
			)
		),
		array( 'param_name' => 'slider_arrows_size', 'default' => 'normal', 'type' => 'dropdown', 'heading' => esc_html__( 'Navigation arrows size', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Large', 'bold-timeline' ) 			=> 'large',
				esc_html__( 'Normal', 'bold-timeline' ) 		=> 'normal',
				esc_html__( 'Small', 'bold-timeline' ) 			=> 'small',
				esc_html__( 'Hide', 'bold-timeline' ) 			=> 'hide'
			)
		),
		array( 'param_name' => 'slider_dots_style', 'default' => 'show', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots navigation', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'Show', 'bold-timeline' ) 			=> 'show',
				esc_html__( 'Hide', 'bold-timeline' ) 			=> 'hide'
			)
		),
		array( 'param_name' => 'slider_slides_to_show', 'type' => 'textfield', 'default' => '2', 'heading' => esc_html__( 'Number of slides to show', 'bold-timeline' ), 'description' => esc_html__( 'e.g. 2', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ) ),
		array( 'param_name' => 'slider_auto_play', 'type' => 'textfield', 'heading' => esc_html__( 'Slider Autoplay interval (ms)', 'bold-timeline' ), 'default' => '0', 'description' => esc_html__( 'e.g. 2000', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ) ),
		array( 'param_name' => 'slider_gap', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Slider Horizontal Gap', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ),
			'value' => array(
				esc_html__( 'No gap', 'bold-builder' ) => 'no_gap',
				esc_html__( 'Small', 'bold-builder' ) => 'small',
				esc_html__( 'Normal', 'bold-builder' ) => 'normal',
				esc_html__( 'Large', 'bold-builder' ) => 'large'
			)
		),
		array( 'param_name' => 'slider_navigation_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Slider navigation color', 'bold-timeline' ), 'group' => esc_html__( 'Sliders', 'bold-timeline' ) ),
		array( 'param_name' => 'el_id', 'type' => 'textfield', 'heading' => esc_html__( 'Custom Id Attribute', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),
		array( 'param_name' => 'el_class', 'type' => 'textfield', 'heading' => esc_html__( 'Extra Class Name(s)', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),
		array( 'param_name' => 'el_css', 'type' => 'textarea', 'heading' => esc_html__( 'Extra CSS', 'bold-timeline' ), 'description' => esc_html__( 'Use #this to select this element (e.g. #this { color: white; })', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),
		array( 'param_name' => 'el_style', 'type' => 'textfield', 'heading' => esc_html__( 'Inline Style', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),
		array( 'param_name' => 'responsive', 'type' => 'checkbox_group', 'heading' => esc_html__( 'Hide element on screens', 'bold-timeline' ), 'group' => esc_html__( 'Responsive', 'bold-timeline' ), 'preview' => true,
			'value' => array(
				esc_html__( '≤480px', 'bold-timeline' ) 		=> 'hidden_xs',
				esc_html__( '480-767px', 'bold-timeline' ) 		=> 'hidden_ms',
				esc_html__( '768-991px', 'bold-timeline' ) 		=> 'hidden_sm',
				esc_html__( '992-1200px', 'bold-timeline' ) 	=> 'hidden_md',
				esc_html__( '≥1200px', 'bold-timeline' ) 		=> 'hidden_lg',
			)
		)
	);
	Bold_Timeline::$builder->map( 'bold_timeline_container', array( 'name' => esc_html__( 'Timeline', 'bold-timeline' ), 'description' => esc_html__( 'Timeline container', 'bold-timeline' ), 'container' => 'vertical', 'icon' => 'bt_bb_icon_bold_timeline_container', 'accept' => array( 'bold_timeline_group' => true ), 'show_settings_on_create' => true, 'root' => true, 'params' => $bold_timeline_container_params ));
	
}
add_action( 'wp_loaded', 'bold_timeline_map_container' );