<?php

// [bold_timeline_item_button]

class bold_timeline_item_button {
	static function init() {
		add_shortcode( 'bold_timeline_item_button', array( __CLASS__, 'handle_shortcode' ) );
	}

	static function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( array(
			'title'    				=> '',
			'url' 					=> '',
			'style' 				=> 'filled',
			'shape' 				=> 'soft_rounded',
			'width' 				=> 'block',
			'size' 					=> 'normal',
			'color' 				=> '',			
			'el_id'					=> '',
			'el_class'				=> '',
			'el_style'				=> '',
                        'responsive'                            => ''
		), $atts, 'bold_timeline_item_button' ) );
		
		$prefix = 'bold_timeline_item_button';
		$class = array( $prefix );	

		if ( $el_id == '' ) {
			$el_id = 'id_' . uniqid();
		}else{
			$el_id = 'id_' . $el_id . '_' . uniqid();
		}		
		$id_attr = ' ' . 'id="' . $el_id . '"';
                
        if ( $el_class != '' ) {
			$class[] = $el_class;
		}
                
                if ( $responsive != '' ) {
			$class[] = $responsive;
		}

		if ( $style != '' ) {
			$class[] = $prefix . '_style_' . $style;
		}
		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . $el_style . '"';
		}				

		if ( $shape != '' ) {
			$class[] = $prefix . '_shape_' . $shape;
		}		

		if ( $width != '' ) {
			$class[] = $prefix . '_width_' . $width;
		}		

		if ( $size != '' ) {
			$class[] = $prefix . '_size_' . $size;
		}
		
		$css_override = '';
		Bold_Timeline::$crush_vars = array();
		
		Bold_Timeline::$crush_vars['defaultButtonColor'] = '';
		if ( $color != '' ) {
			Bold_Timeline::$crush_vars['defaultButtonColor'] = $color;	
		}
		require( dirname(__FILE__) . '/../../css-override-button.php' );
		
		$output = '<div class="' . implode( ' ', $class ) . '"' . $id_attr . $style_attr . ' data-css-override="' . $css_override . '"><div class="bold_timeline_item_button_inner">';
		if ( $url != '' ) {
			$output .= '<a href="' . $url . '" alt=' . $title . ' class="bold_timeline_item_button_innet_text">' . $title . '</a>';
		} else {
			$output .= '<span class="bold_timeline_item_button_innet_text">' . $title . '</span>';
		}
		$output .= '</div></div>';

		return $output;
	}
}

bold_timeline_item_button::init();

// Map shortcode

function bold_timeline_item_button() {

	Bold_Timeline::$builder->map( 'bold_timeline_item_button', array( 'name' => esc_html__( 'Button', 'bold-builder' ), 'description' => esc_html__( 'Button element', 'bold-builder' ), 'icon' => 'bold_timeline_item_button_icon', 'container' => 'vertical', 'params' => array(), 'toggle' => true, 'show_settings_on_create' => true, 'params' => array(
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'bold-timeline' ), 'preview' => true ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'bold-timeline' ), 'preview' => true ),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'default' => 'inherit', 'heading' => esc_html__( 'Style', 'bold-timeline' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Inherit', 'bold-timeline' ) 			=> 'inherit',
						esc_html__( 'Outline', 'bold-timeline' ) 			=> 'outline',
						esc_html__( 'Filled', 'bold-timeline' ) 			=> 'filled',
						esc_html__( 'Shadow', 'bold-timeline' ) 			=> 'shadow',
						esc_html__( 'Clear', 'bold-timeline' ) 				=> 'clear'
					)
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'default' => 'inherit', 'heading' => esc_html__( 'Shape', 'bold-timeline' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Inherit', 'bold-timeline' ) 			=> 'inherit',
						esc_html__( 'Soft rounded', 'bold-timeline' ) 		=> 'soft_rounded',
						esc_html__( 'Hard rounded', 'bold-timeline' ) 		=> 'hard_rounded',
						esc_html__( 'Square', 'bold-timeline' ) 			=> 'square'
					)
				),
				array( 'param_name' => 'width', 'type' => 'dropdown', 'default' => 'inherit', 'heading' => esc_html__( 'Width', 'bold-timeline' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Inherit', 'bold-timeline' ) 			=> 'inherit',
						esc_html__( 'Full', 'bold-timeline' ) 				=> 'block',
						esc_html__( 'Adapt to title', 'bold-timeline' ) 	=> 'inline'
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'default' => 'inherit', 'heading' => esc_html__( 'Size', 'bold-timeline' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Inherit', 'bold-timeline' ) 			=> 'inherit',
						esc_html__( 'Small', 'bold-timeline' ) 				=> 'small',
						esc_html__( 'Normal', 'bold-timeline' ) 			=> 'normal',
						esc_html__( 'Large', 'bold-timeline' ) 				=> 'large'
					)
				),
				array( 'param_name' => 'color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Color', 'bold-timeline' ), 'group' => esc_html__( 'Properties', 'bold-timeline' ), 'preview' => true ),
				array( 'param_name' => 'el_id', 'type' => 'textfield', 'heading' => esc_html__( 'Custom Id Attribute', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),
				array( 'param_name' => 'el_class', 'type' => 'textfield', 'heading' => esc_html__( 'Extra Class Name(s)', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),
				array( 'param_name' => 'el_style', 'type' => 'textfield', 'heading' => esc_html__( 'Inline Style', 'bold-timeline' ), 'group' => esc_html__( 'Custom', 'bold-timeline' ) ),		
				array( 'param_name' => 'responsive', 'type' => 'checkbox_group', 'heading' => esc_html__( 'Hide element on screens', 'bold-timeline' ), 'group' => esc_html__( 'Responsive', 'bold-timeline' ), 'preview' => true,
					'value' => array(
							esc_html__( '≤480px', 'bold-timeline' ) 		=> 'hidden_xs',
							esc_html__( '480-767px', 'bold-timeline' ) 		=> 'hidden_ms',
							esc_html__( '768-991px', 'bold-timeline' ) 		=> 'hidden_sm',
							esc_html__( '992-1200px', 'bold-timeline' ) 	=> 'hidden_md',
							esc_html__( '≥1200px', 'bold-timeline' ) 		=> 'hidden_lg'
					)
				),
			
                    ) 
		)  
	);	
	
}
add_action( 'plugins_loaded', 'bold_timeline_item_button' );