<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       none
 * @since      1.0.0
 *
 * @package    Buddy_Chat
 * @subpackage Buddy_Chat/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Buddy_Chat
 * @subpackage Buddy_Chat/public
 * @author     Nono <none>
 */
class Buddy_Chat_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	private $db;
	private $table_name;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of the plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		global $wpdb;

		$this->plugin_name = $plugin_name;
		$this->version     = $version;

		$this->db         = $wpdb;
		$this->table_name = $wpdb->prefix . 'bpc_message';
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Buddy_Chat_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Buddy_Chat_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

    $chat_enabled = apply_filters('bpc_enable_chat', true);
    if($chat_enabled) {
      wp_enqueue_style( $this->plugin_name . '_emoji_mart', plugin_dir_url( __FILE__ ) . 'css/emoji-mart.css', array(), $this->version, 'all' );
      wp_enqueue_style( $this->plugin_name . '_emoji', plugin_dir_url( __FILE__ ) . 'css/emoji.css', array(), $this->version, 'all' );
      wp_enqueue_style( $this->plugin_name . '_main', plugin_dir_url( __FILE__ ) . 'css/buddychat.css', array(), $this->version, 'all' );
      wp_enqueue_style( $this->plugin_name . '_virtualscroller', plugin_dir_url( __FILE__ ) . 'css/vue-virtual-scroller.css', array(), $this->version, 'all' );
    }
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Buddy_Chat_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Buddy_Chat_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
    $chat_enabled = apply_filters('bpc_enable_chat', true);
    if($chat_enabled) {
      wp_enqueue_script( $this->plugin_name . '_vue', plugin_dir_url( __FILE__ ) . 'js/vue.min.js', array(), $this->version, true );
      wp_enqueue_script( $this->plugin_name . '_event_source', plugin_dir_url( __FILE__ ) . 'js/eventsource.min.js', array(), $this->version, true );
      wp_enqueue_script( $this->plugin_name . '_intersectionobserver', plugin_dir_url( __FILE__ ) . 'js/intersection-observer.js', array(), $this->version, true );
      wp_enqueue_script( $this->plugin_name . '_emoji_mart', plugin_dir_url( __FILE__ ) . 'js/emoji-mart.min.js', array(), $this->version, true );
      wp_enqueue_script( $this->plugin_name . '_emoji', plugin_dir_url( __FILE__ ) . 'js/emoji.min.js', array(), $this->version, true );
      wp_enqueue_script( $this->plugin_name . '_scrollbar', plugin_dir_url( __FILE__ ) . 'js/vuebar.js', array( $this->plugin_name . '_vue' ), $this->version, true );
      wp_enqueue_script( $this->plugin_name . '_virtualscroller', plugin_dir_url( __FILE__ ) . 'js/vue-virtual-scroller.min.js', array( $this->plugin_name . '_vue' ), $this->version, true );

      wp_register_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/buddy-chat-public.js', array( $this->plugin_name . '_vue', $this->plugin_name . '_event_source', $this->plugin_name . '_emoji_mart', $this->plugin_name . '_emoji' ), $this->version, true );

      global $buddychat_options;

      wp_localize_script(
        $this->plugin_name,
        'bpc_data',
        array(
          'title'                  => esc_html($buddychat_options['title']),
          'perpage'                => $buddychat_options['perpage'],
          'active_tab'             => $buddychat_options['active-tab'] ? $buddychat_options['active-tab'] : 'all-members',
          'messages'               => array(
            'loading'   => esc_html($buddychat_options['loading']),
            'no_user'   => esc_html($buddychat_options['no-user']),
            'no_friend' => esc_html($buddychat_options['no-friend']),
            'no_group'  => esc_html($buddychat_options['no-group']),
          ),
          'me'                     => get_current_user_id(),
          'image_dir_url'          => plugin_dir_url( __FILE__ ) . 'images',
          'notification_sound_url' => $buddychat_options['notification']['url'],
          'event_source_url'       => admin_url( 'admin-post.php?action=bpc_event_source' ),
          'online_users_url'       => admin_url( 'admin-ajax.php?action=bpc_online_users' ),
          'chat_buddies_url'       => admin_url( 'admin-ajax.php?action=bpc_chat_buddies' ),
          'all_users_url'          => admin_url( 'admin-ajax.php?action=bpc_all_users' ),
          'all_friends_url'        => admin_url( 'admin-ajax.php?action=bpc_all_friends' ),
          'send_message_url'       => admin_url( 'admin-ajax.php?action=bpc_send_message' ),
          'get_message_url'        => admin_url( 'admin-ajax.php?action=bpc_get_message' ),
        )
      );
      wp_enqueue_script( $this->plugin_name );
    }
	}

	public function bpc_template() {
    $chat_enabled = apply_filters('bpc_enable_chat', true);
    if($chat_enabled) {
      $template = apply_filters( 'bpc_template', 'default' );
      require_once dirname( __FILE__ ) . "/partials/buddy-chat-public-$template.php";
    }
	}

	public function bpc_chat_buddies() {
		$result            = array();
		$result['users']   = $this->get_buddypress_users_without_me();
		$result['friends'] = $this->get_my_friends();
		$result['groups']  = $this->get_my_groups();

		$this->_send_json_response( $result );
	}
	public function bpc_all_users() {
		$query = $_GET['query'] ? $_GET['query'] : false;
		$page  = $_GET['page'] ? $_GET['page'] : 1;
		// var_dump($query, $page);
		$this->_send_json_response( $this->get_buddypress_users_without_me( $query, $page ) );
	}
	public function bpc_all_friends() {
		$query = $_GET['query'] ? $_GET['query'] : false;
		$page  = $_GET['page'] ? $_GET['page'] : 1;
		// var_dump($query, $page);
		$this->_send_json_response( $this->get_my_friends( $query, $page ) );
	}

	public function bpc_online_users() {
		$userQuery = new BP_User_Query(
			array(
				'type'    => 'online',
				'exclude' => get_current_user_id(),
			)
		);

		$results = array();
		foreach ( $userQuery->results as $userData ) {

			$results[] = $userData->id;
		}
		$this->_send_json_response( $results );
	}

	public function bpc_send_message() {

		switch ( $_POST['type'] ) {
			case 'one2one':
				$this->db->insert(
					$this->table_name,
					array(
						'to_id'        => $_POST['to_id'],
						'from_id'      => get_current_user_id(),
						'message'      => $_POST['message'],
						'message_type' => 'text',
						'createdAt'    => time(),
					)
				);
				break;
			case 'group':
				$this->db->insert(
					$this->table_name,
					array(
						'tog_id'       => $_POST['to_id'],
						'from_id'      => get_current_user_id(),
						'message'      => $_POST['message'],
						'message_type' => 'text',
						'createdAt'    => time(),
					)
				);
				break;
		}
		$_POST['createdAt'] = time();
		$this->_send_json_response( $_POST );
	}

	public function bpc_get_message() {
		if ( ! isset( $_GET['page'] ) || $_GET['page'] < 1 ) {
			$page = 1;
		} else {
			$page = $_GET['page'];
		}
		$limit = ( ( $page - 1 ) * 10 ) . ', 10';
		$me    = get_current_user_id();
		$buddy = $_GET['buddy'];

		if ( isset( $_GET['chat_type'] ) ) {
			$chat_type = $_GET['chat_type'];
		} else {
			$chat_type = 'one2one';
		}

		$skip_ids = "''";
		if ( isset( $_GET['skip_ids'] ) && $_GET['skip_ids'] ) {
			$skip_ids = $_GET['skip_ids'];
		}

		switch ( $chat_type ) {
			case 'group':
				$ms = $this->db->get_results( "SELECT * FROM {$this->table_name} WHERE tog_id=$buddy AND id NOT IN ($skip_ids) ORDER BY createdAt DESC LIMIT $limit" );
				foreach ( $ms as $m ) {
					if ( $m->to_id ) {
						$m->to_avatar = bp_core_fetch_avatar(
							array(
								'item_id' => $m['to_id'],
								'object'  => 'user',
								'type'    => 'thumb',
								'html'    => false,
							)
						);
					}
					$m->from_avatar = bp_core_fetch_avatar(
						array(
							'item_id' => $m->from_id,
							'object'  => 'user',
							'type'    => 'thumb',
							'html'    => false,
						)
					);
				}
				$this->_send_json_response( $ms );
				break;

			default:
				// echo "SELECT * FROM {$this->table_name} WHERE ((from_id=$me AND to_id=$buddy) OR (from_id=$buddy AND to_id=$me)) AND id NOT IN ($skip_ids) ORDER BY createdAt DESC LIMIT $limit";
				$ms = $this->db->get_results( "SELECT * FROM {$this->table_name} WHERE ((from_id=$me AND to_id=$buddy) OR (from_id=$buddy AND to_id=$me)) AND id NOT IN ($skip_ids) ORDER BY createdAt DESC LIMIT $limit" );
				foreach ( $ms as $m ) {
					if ( $m->to_id ) {
						$m->to_avatar = bp_core_fetch_avatar(
							array(
								'item_id' => $m->to_id,
								'object'  => 'user',
								'type'    => 'thumb',
								'html'    => false,
							)
						);
					}
					$m->from_avatar = bp_core_fetch_avatar(
						array(
							'item_id' => $m->from_id,
							'object'  => 'user',
							'type'    => 'thumb',
							'html'    => false,
						)
					);
				}
				$this->_send_json_response( $ms );
				break;
		}
	}

	public function bpc_event_source() {
		header( 'Content-Type: text/event-stream' );
		header( 'Cache-Control: no-cache' );
		header( 'Connection: keep-alive' );
		header( 'Access-Control-Allow-Origin: *' );
		header( 'X-Accel-Buffering: no' );

		$connect_time = time();
		$user_id      = get_current_user_id();
		$groups       = $this->get_my_groups();
		$gids         = array();
		foreach ( $groups as $group ) {
			$gids[] = $group['id'];
		}
		$groups = implode( ',', $gids );
		if ( ! $groups ) {
			$groups = "''";
		}

		while ( true ) {
			$current_time = time();
			if ( ( $current_time - $connect_time ) > 30000 ) {
				die();
			}

			$updated_datas = $this->get_message_updates( $user_id, $groups );
			if ( $updated_datas ) {
				foreach ( $updated_datas as $key => $data ) {
					echo "id: {$data->id}\n";
					echo "data: {\n";
					echo "data: \"id\": \"{$data->id}\",\n";
					echo "data: \"message\": \"{$data->message}\",\n";
					echo "data: \"message_type\": \"{$data->message_type}\",\n";
					echo "data: \"file_mime\": \"{$data->file_mime}\",\n";
					if ( $data->to_id ) {
						echo "data: \"to_id\": {$data->to_id},\n";
						echo 'data: "to_avatar": "' . bp_core_fetch_avatar(
							array(
								'item_id' => $data->to_id,
								'object'  => 'user',
								'type'    => 'thumb',
								'html'    => false,
							)
						) . "\",\n";
					}
					if ( $data->tog_id ) {
						echo "data: \"tog_id\": {$data->tog_id},\n";
						echo 'data: "group_name": "' . groups_get_group( array( 'group_id' => $data->tog_id ) )->name . "\",\n";
						echo 'data: "group_avatar": "' . bp_core_fetch_avatar(
							array(
								'item_id' => $data->tog_id,
								'object'  => 'group',
								'type'    => 'thumb',
								'html'    => false,
							)
						) . "\",\n";
					}
					echo "data: \"from_id\": {$data->from_id},\n";
					echo 'data: "from_name": "' . get_userdata( $data->from_id )->display_name . "\",\n";
					echo 'data: "from_avatar": "' . bp_core_fetch_avatar(
						array(
							'item_id' => $data->from_id,
							'object'  => 'user',
							'type'    => 'thumb',
							'html'    => false,
						)
					) . "\",\n";
					echo "data: \"createdAt\": \"{$data->createdAt}\"\n";
					echo "data: }\n\n";
					ob_flush();
					flush();
				}
			} else {
				echo "id: $current_time\n",
					"event: ping\n",
					"data: live\n\n";
				ob_flush();
				flush();
			}

			if ( connection_aborted() ) {
				break;
			}
			sleep( 1 );
		}
	}

	private function get_message_updates( $user_id, $group_ids ) {
		$result = $this->db->get_results( "SELECT * from {$this->table_name} WHERE (to_id=$user_id OR (tog_id IN ($group_ids) AND from_id != $user_id)) AND seen=false ORDER BY createdAt DESC" );
		foreach ( $result as $res ) {
			$this->db->update(
				$this->table_name,
				array(
					'seen' => true,
				),
				array(
					'id' => $res->id,
				)
			);
		}

		return $result;
	}



	private function get_buddypress_users_without_me( $query = false, $page = 1 ) {
		global $buddychat_options;

		if ( $buddychat_options['available-tabs']['all-members'] ) {
			$userQuery = new BP_User_Query(
				array(
					'type'         => array( 'popular', 'online', 'active', 'alphabetical' ),
					'per_page'     => $buddychat_options['perpage'],
					'page'         => $page,
					'search_terms' => $query,
					'exclude'      => get_current_user_id(),
				)
			);

			$results = array();
			foreach ( $userQuery->results as $userData ) {
				// print_r($userData);
				$user                 = array();
				$user['id']           = $userData->id;
				$user['display_name'] = $userData->display_name;
				$user['avatar']       = bp_core_fetch_avatar(
					array(
						'item_id' => $userData->id,
						'object'  => 'user',
						'type'    => 'thumb',
						'html'    => false,
					)
				);

				$results[] = $user;
			}

			return array(
				'users' => $results,
				'count' => (int) $userQuery->total_users,
			);
		} else {
			return array(
				'users' => array(),
				'count' => 0,
			);
		}
	}
	private function get_my_friends( $query = false, $page = 1 ) {
		global $buddychat_options;

		if ( bp_is_active( 'friends' ) && $buddychat_options['available-tabs']['friends'] ) {
			$friendIds = BP_Friends_Friendship::get_friend_user_ids( get_current_user_id() );

			$userQuery = new BP_User_Query(
				array(
					'type'         => 'alphabetical',
					'user_ids'     => $friendIds,
					'search_terms' => $query,
					'per_page'     => $buddychat_options['perpage'],
					'page'         => $page,
				)
			);

			$results = array();
			foreach ( $userQuery->results as $userData ) {
				// print_r($userData);
				$user                 = array();
				$user['id']           = $userData->id;
				$user['display_name'] = $userData->display_name;
				$user['avatar']       = bp_core_fetch_avatar(
					array(
						'item_id' => $userData->id,
						'object'  => 'user',
						'type'    => 'thumb',
						'html'    => false,
					)
				);

				$results[] = $user;
			}

			return array(
				'friends' => $results,
				'count'   => (int) $userQuery->total_users,
			);
		} else {
			return array(
				'friends' => array(),
				'count'   => 0,
			);
		}

	}
	private function get_my_groups() {
		global $buddychat_options;
		if ( bp_is_active( 'groups' ) && $buddychat_options['available-tabs']['groups'] ) {
			$groups = groups_get_groups(
				array(
					'user_id'  => get_current_user_id(),
					'per_page' => -1,
				)
			)['groups'];

			$result = array();

			foreach ( $groups as $group ) {
				$gp           = array();
				$gp['id']     = $group->id;
				$gp['name']   = $group->name;
				$gp['avatar'] = bp_core_fetch_avatar(
					array(
						'item_id' => $group->id,
						'object'  => 'group',
						'type'    => 'thumb',
						'html'    => false,
					)
				);

				$result[] = $gp;
			}
			return $result;
		} else {
			return array();
		}
	}

	private function _send_json_response( $data ) {
		echo json_encode( $data );
		die();
	}

}
