var defaultTitle = document.title;
var emoji = new EmojiConvertor();
emoji.img_set = 'emojione'
emoji.img_sets.emojione.sheet = `${bpc_data.image_dir_url}/emojione-64.png`
emoji.use_sheet = true;
emoji.include_title = true;

Vue.component('editable', {
  props: ['value', 'placeholder', 'minimized'],
  components: {
    'picker': EmojiMart.Picker
  },
  template: `
    <div>
      <div class="chat-window__inputarea">
        <div class="chat-window__input">
          <div v-if="tl == 0" class="chat-window__input--placeholder">{{placeholder}}</div>
          <div
            class="chat-window__input--field"
            contenteditable
            ref="editor"
            @input="on_input"
            @mouseup="track_caret_pos"
            @keyup="track_caret_pos"
          ></div>
        </div>
        <div class="chat-window__input--emoji" @click="pickerShown = !pickerShown"><span style="display: inline-block; width: 24px; height: 24px; background-image: url(${bpc_data.image_dir_url}/emojione-64.png); background-size: 5200%; background-position: 58.8235% 52.9412%;"></span></div>
      </div>
      <div v-if="pickerShown" class="emoji-picker__container">
        <picker
          @select="on_emoji_selected"
          set="emojione"
          :backgroundImageFn="emoji_img"
          :style="{ position: 'absolute', bottom: '60px', right: '-25px' }" 
          :per-line="8"
          :emoji-size="24"/>
      </div>
    </div>
  `,
  data() {
    return {
      tl: this.value ? this.value.length : 0,
      pickerShown: false
    }
  },
  watch: {
    value(v) {
      if(!v){
        this.$refs.editor.innerText = v;
        this.tl = 0
      }
    },
    minimized(v) {
      this.pickerShown = false
    }
  },
  methods:{
    emoji_img(){
      return `${bpc_data.image_dir_url}/emojione-64.png`
    },
    on_input(event) {
      this.$emit('input', event.target.innerText)
      this.tl = event.target.innerText.length
    },
    on_emoji_selected(emo) {
      let pos = this.caretPos || 0
      let newS = this.$refs.editor.innerText
      if(newS.lastIndexOf('\n\n') > -1) {
        newS = newS.substring(0, newS.length-2)
      }
      newS = newS.substring(0, pos) + emo.colons + newS.substring(pos)

      this.$refs.editor.innerText = newS
      this.tl = this.$refs.editor.innerText.length
      //this.track_caret_pos()
      this.caretPos = pos + emo.colons.length
    },
    track_caret_pos(event){
      if(this.$refs.editor.innerText.length == 1 && this.$refs.editor.innerText == '\n') {
        this.$refs.editor.innerText = ''
      }
      this.caretPos = getCaretPosition(this.$refs.editor)
      this.$emit('keyup', event, this.id, this.type)
      this.pickerShown = false
      this.tl = this.$refs.editor.innerText.length
    }
  },
  mounted(){
    if(this.value)
      this.$refs.editor.innerText = this.value;
  }
})

Vue.component('chat-window', {
  props:['buddy', 'users', 'online_users'],
  template: `
    <li class="chat-window" :class="{focused: buddy.focused}" @click="on_window_click">
      <div ref="chat-container" class="chat-window__container">
        <div class="chat-window__title" @click.prevent="toggle_minimize">
          <div class="avatar-container" v-if="buddy.avatar">
            <img :src="buddy.avatar" class="avatar" :alt="buddy.title">
            <span v-if="buddy.type == 'one2one'" class="status" :class="{online: is_user_online(buddy.id)}"></span>
          </div>
          <div class="flex-r">
            <div>
              <div class="chat-buddy anchor ellipsis">{{buddy.title}} <transition name="fade"><span v-if="buddy.unread_msg_count > 0" class="badge badge-danger" :class="{jump: jump}">{{buddy.unread_msg_count}}</span></transition></div>
              <div class="mute">{{ is_user_online(buddy.id) ? 'Online' : 'Offline' }}</div>
            </div>
          </div>
          <a class="chat_window__close-btn" href="#" @click.prevent.stop="$emit('close', buddy)"><span class="dashicons dashicons-no-alt"></span></a>
        </div>
        <div class="chat-window__message-list" v-bar>
          <div ref="messageList">
            <ul class="bpc-chat-list">
              <li v-for="(group, index) in sorted_messages"
                :class="get_message_class(group)"
                :key="index"
              >
                <time v-if="should_display_date(index)">{{formated_time(group.fCAt)}}</time>
                <div class="message-block">
                  <img v-if="group.from_id != me" :src="group.from_avatar" class="avatar" :alt="buddy.title">
                  <div class="messages">
                    <div v-for="message in group.messages" class="message" v-html="formated_message(message.message)"></div>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
        <div>
          <editable
            v-model="input"
            :id="buddy.id"
            :type="buddy.type"
            :minimized="minimized"
            @keyup="handle_message_input"
            placeholder="write your message"></editable>
        </div>
      </div>
    </li>
  `,
  data() {
    return {
      input: '',
      messages:[],
      grouped_messages:[],
      page: 1,
      loading: false,
      me: bpc_data.me,
      minimized: false,
      jump: false
    }
  },
  computed:{
    sorted_messages() {
      return this.grouped_messages.sort((m1, m2) => {
        return m1.fCAt - m2.fCAt
      })
    }
  },
  methods:{
    toggle_minimize() {
      this.minimized = !this.minimized
      if(!this.minimized) {
        this.$set(this.buddy, 'unread_msg_count', 0)
        this.$refs['chat-container'].style.bottom = `0`
      }else{
        let cs = window.getComputedStyle(this.$refs['chat-container'])
        let windowHieght = this.$refs['chat-container'].offsetHeight
        let titleHeight = this.$refs['chat-container'].querySelector('.chat-window__title').offsetHeight
        this.$refs['chat-container'].style.bottom = `${-(windowHieght - titleHeight - parseInt(cs.borderTopWidth) - parseInt(cs.paddingTop))}px`
      }
    },
    on_window_click(event){
      this.buddy.focused = true
      this.$emit('on_window_click', this.buddy)
      
      this.$set(this.buddy, 'unread_msg_count', 0)
      if(defaultTitle) document.title = defaultTitle
    },
    async handle_message_input($event) {
      if($event.keyCode == 13 && !$event.shiftKey) {
        if(!this.input.trim()) return
        let message = {
          from_id: bpc_data.me,
          message: this.input.trim(),
          createdAt: parseInt(Date.now()/1000),
          saving: true
        }
        if(this.buddy.type == 'one2one') {
          message.to_id = this.buddy.id
        }else{
          message.tog_id = this.buddy.id
        }
        this.store_message(message)
        this.input = ''
        this.scroll_to_bottom()
        
        let formData = new FormData()
        formData.append('to_id', this.buddy.id)
        formData.append('message', message.message)
        formData.append('type', this.buddy.type)
        // this.$forceUpdate()
        let res = await fetch(bpc_data.send_message_url, {
          method: 'POST',
          body: formData
        })
        let json = await res.json();
        message.saving = false
      }
    },
    async load_messages(forceToBottom){
      if(this.loading || this.ended) return
      this.loading = true

      let ul = this.$refs.messageList.childNodes[0]
      let previousListLength = ul.childNodes.length

      let res = await fetch(bpc_data.get_message_url + `&buddy=${this.buddy.id}&page=${this.page}&chat_type=${this.buddy.type}&skip_ids=${this.skip_ids.join(',')}`)
      let json = await res.json()
      this.loading = false

      this.store_message(json)

      if(json.length == 10) {
        this.page += 1
      }else{
        this.ended = true
      }

      if(forceToBottom && json.length)
        this.scroll_to_bottom()
      else if(json.length){
        this.$nextTick(() => {
          let currentListLength = ul.childNodes.length
          ul.childNodes[currentListLength - previousListLength].scrollIntoView({block: "center", inline: "nearest"})
        })
      }
    },
    waited_load_messages() {
      if(this.load_message_timeout) clearTimeout(this.load_message_timeout)
      this.load_message_timeout = setTimeout(async () => {
        if(this.skip_ids.length < 10){
          await this.load_messages(false)
          this.buddy.from_event_stream = false
          this.skip_ids = []
        }
        else{
          this.buddy.from_event_stream = false
          this.skip_ids = []
        }
      }, 3000)
    },
    group_message(message){
      message.createdAt = parseInt(message.createdAt)
      let group = this.grouped_messages.find((g) => {
        return g.from_id == message.from_id && (g.fCAt  < (message.createdAt + 10)) && (g.lCAt  > (message.createdAt - 10))
      })
      if(group) {
        if(group.fCAt > message.createdAt){
          group.messages.unshift(message)
          group.fCAt = message.createdAt
        }else{
          group.messages.push(message)
          group.lCAt = message.createdAt
        }
      }else{
        group = {
          from_id: message.from_id,
          from_avatar: message.from_avatar,
          fCAt: message.createdAt,
          lCAt: message.createdAt,
          messages: [message]
        }
        this.grouped_messages.push(group)
      }
    },
    store_message(messages) {
      if(Array.isArray(messages)) {
        messages.map((m) => {
          this.group_message(m)
        })
      }else{
        this.group_message(messages)
      }
    },
    should_display_date(current_index) {
      let g1 = this.grouped_messages[current_index]
      let g2 = this.grouped_messages[current_index - 1]
      if(!g2) return true

      if((g1.fCAt - g2.fCAt) > 5*60) return true

      return false
    },
    on_new_message(data) {
      if(this.buddy.from_event_stream){
        this.skip_ids.push(data.id)
        this.waited_load_messages()
      }
      if(this.minimized) {
        this.jump = true
        if(this.jump_timeout) clearTimeout(this.jump_timeout)
        this.jump_timeout = setTimeout(() => {
          this.jump = false
        }, 500)
      }
      if(this.minimized || (!this.buddy.focused)) {
        this.$set(this.buddy, 'unread_msg_count', this.buddy.unread_msg_count + 1)
      }
      if(!this.buddy.focused) {
        document.title = `${this.buddy.title} says (${this.buddy.unread_msg_count})`
      }
      this.store_message(data)
      this.scroll_to_bottom()
    },
    formated_time(time_seconds) {
      let date = new Date(time_seconds * 1000)
      return date.toLocaleDateString("en-US", { year: 'numeric', month: 'short', day: 'numeric', hour: 'numeric', minute:'numeric' })
    },
    formated_message(message) {
      return emoji.replace_colons(message)
    },
    get_message_class(message) {
      return message.from_id == bpc_data.me ? 'message--self' : 'message--other'
    },
    scroll_to_bottom(){
      this.$nextTick(() => {
        if(this.$refs.messageList)
          this.$refs.messageList.scrollTop = this.$refs.messageList.scrollHeight
      })
    },
    is_user_online(user_id) {
      return this.online_users.indexOf(user_id) > -1
    }
  },
  mounted() {
    this.ended = false
    this.skip_ids = []
    this.buddy.unread_msg_count = 0
    if(this.buddy.from_event_stream) {
      this.waited_load_messages()
    }else{
      this.load_messages(true)
    }

    this.buddy.bus.$on('new_message', (data) => {
      this.on_new_message(data)
    })

    this.$nextTick(() => {
      this.prevScrollPos = event.srcElement.scrollTop
      this.$refs.messageList.onscroll = (event) => {
        if(event.srcElement.scrollTop > this.prevScrollPos) {
          this.scrollingTop = false
        }else if(event.srcElement.scrollTop < this.prevScrollPos){
          this.scrollingTop = true
        }

        this.prevScrollPos = event.srcElement.scrollTop

        if(this.scrollingTop && (event.srcElement.scrollTop < 7))
          this.load_messages(false)
      }
    })
  }
})

var app = new Vue({
  el: '#buddy-chat-app',
  data: () => {
  	return {
  		buddies: {
        users: [],
        friends: [],
        groups: [],
        userCount: null,
        friendCount: null,
        currentUserPage: 1,
        currentFriendPage: 1
      },
  		chat_windows: [],
      online_users:[],
      me: bpc_data.me,
      collapsed: true,
      filter: {
        user: '',
        friend: '',
        group: ''
      },
      max_active_window: 2,
      currentWindowCount: 0,
      current_tab: bpc_data.active_tab,
      show_inactive: false,
      show_settings: false,
      show_buddies: false,
      is_notification_sound_off: false,
      is_minimized: true,
      active_users_list: 'default',
      fetching: {
        users: false,
        friends: false,
        groups: false
      },
      messages: {
        loading: bpc_data.messages.loading,
        emptyUser: bpc_data.messages.no_user,
        emptyFriend: bpc_data.messages.no_friend,
        emptyGroup: bpc_data.messages.no_group
      }
  	}
  },
  computed: {
    is_collapsed() {
      return this.collapsed
    },
    users() {
      return this.buddies.users
    },
    friends() {
      return this.buddies.friends
    },
    groups() {
      return this.filterData(this.buddies.groups, 'name', this.filter.group)
    },
    inactive_chat_windows() {
      return this.chat_windows.filter(w => w.active != true)
    },
    active_chat_windows() {
      return this.chat_windows.filter(w => w.active == true)
    }
  },
  watch: {
    chat_windows(newV) {
      if(newV.length < this.currentWindowCount) {
        let iCW = this.chat_windows.filter(w => w.active != true)
        if(iCW.length > 0) {
          iCW[0].active = true
        }
        // this.updateChatWindows()
      }
      this.currentWindowCount = newV.length
    },
    'filter.user': function () {
      this.buddies.currentUserPage = 1
      this.fetchUsers()
    },
    'filter.friend': function () {
      this.buddies.currentFriendPage = 1
      this.fetchFriends()
    }
  },
  methods:{
    toggle_notification_sound() {
      this.is_notification_sound_off = !this.is_notification_sound_off
    },
    toggle_window() {
      this.collapsed = !this.collapsed
    },
    switch_tab(tab) {
      this.current_tab = tab
    },
    toggle_inactive_list() {
      this.show_inactive = !this.show_inactive
    },
    on_window_click(buddy) {
      this.active_chat_windows.filter(cw => cw != buddy).map(cw => {
        cw.focused = false
      })
    },
    on_header_click() {
      this.is_minimized = !this.is_minimized
    },
    // a work around for vuebar multi instance bug
    show_popped_buddies() {
      this.show_buddies = !this.show_buddies
      if(this.show_buddies) {
        this.$vuebar.destroyScrollbar(this.$refs['popped-buddies'])
        this.$nextTick(() => {
          this.$vuebar.initScrollbar(this.$refs['popped-buddies'], {})
        })
      }
    },
    filterData(dataArr, dataAttr, filterStr) {
      if(!dataArr) return []
      if(!filterStr) return dataArr
      let regex = new RegExp(`${filterStr}`, 'i')
      return dataArr.filter(data => regex.test(data[dataAttr]))
    },
    fetchUsers(append) {
      if(this.fetch_all_user_timer) clearTimeout(this.fetch_all_user_timer)
      this.fetching.users = true
      this.fetch_all_user_timer = setTimeout(async () => {
        let res = await fetch(`${bpc_data.all_users_url}&query=${this.filter.user}&page=${this.buddies.currentUserPage}`)
        let data = await res.json();
        if(append) {
          this.buddies.users = [...this.buddies.users, ...data.users]
        }else{
          this.buddies.users = data.users
        }
        this.buddies.usersCount = data.count
        this.fetching.users = false
      }, 300)
    },
    fetchFriends(append) {
      if(this.fetch_all_friend_timer) clearTimeout(this.fetch_all_friend_timer)
      this.fetching.friends = true
      this.fetch_all_friend_timer = setTimeout(async () => {
        let res = await fetch(`${bpc_data.all_friends_url}&query=${this.filter.friend}&page=${this.buddies.currentUserPage}`)
        let data = await res.json();
        if(append) {
          this.buddies.friends = [...this.buddies.friends, ...data.friends]
        }else{
          this.buddies.friends = data.friends
        }
        this.buddies.friendsCount = data.count
        this.fetching.friends = false
      }, 300)
    },
  	chat_with(buddy, title, type) {
  		let exists = this.chat_windows.find(cw => (cw.id == buddy.id) && cw.type == type)
  		if(!exists){
        buddy.type = type
        buddy.title = title
        buddy.bus = new Vue()
        buddy.active = false
        exists = buddy
  			this.chat_windows.push(buddy)
  		}
      let active_windows = this.chat_windows.filter(w => w.active)
      let isAlreadyActive = active_windows.filter(cw => (cw.id == buddy.id) && cw.type == type).length > 0

      if(isAlreadyActive) return;

      if(active_windows.length >= this.max_active_window) {
        active_windows[0].active = false
      }
      exists.active = true
      this.updateChatWindows()
  	},
    updateChatWindows() {
      this.chat_windows = Object.assign([], this.chat_windows)
    },
    async fetch_online_users() {
      let res = await fetch(bpc_data.online_users_url)
      this.online_users = await res.json();

      this.online_users_timer = setTimeout(() => {
        this.fetch_online_users()
      }, 60000)
    },
    on_new_message(e) {
      let data = JSON.parse(e.data)
      let buddy = null
      if(data.tog_id) {
        buddy = this.chat_windows.find(w => (w.id == data.tog_id) && (w.type=='group'))
      }else{
        buddy = this.chat_windows.find(w => (w.id == data.from_id) && (w.type=='one2one'))
      }


      if(buddy) {
        buddy.bus.$emit('new_message', data)
      }else if(data.tog_id){
        buddy = {
          id: data.tog_id,
          avatar: data.group_avatar
        }
        buddy.from_event_stream = true
        this.chat_with(buddy, data.group_name, 'group')
        this.$nextTick(() => {
          buddy.bus.$emit('new_message', data)
        })
      }else{
        buddy = {
          id: data.from_id,
          avatar: data.from_avatar
        }
        buddy.from_event_stream = true
        this.chat_with(buddy, data.from_name, 'one2one')
        this.$nextTick(() => {
          buddy.bus.$emit('new_message', data)
        })
      }

      if(this.window_hidden) {

        if (!this.is_notification_sound_off)
          this.notification_sound.play();
        
      }
    },
    is_user_online(user_id) {
      return this.online_users.indexOf(user_id) > -1
    },
    close(chat_window) {
      this.chat_windows.splice(this.chat_windows.indexOf(chat_window), 1)
    },
    attach_window_visibility_change_handler() {
      var hidden, visibilityChange; 
      if (typeof document.hidden !== "undefined") { // Opera 12.10 and Firefox 18 and later support 
        hidden = "hidden";
        visibilityChange = "visibilitychange";
      } else if (typeof document.msHidden !== "undefined") {
        hidden = "msHidden";
        visibilityChange = "msvisibilitychange";
      } else if (typeof document.webkitHidden !== "undefined") {
        hidden = "webkitHidden";
        visibilityChange = "webkitvisibilitychange";
      }

      // Warn if the browser doesn't support addEventListener or the Page Visibility API
      if (typeof document.addEventListener === "undefined" || hidden === undefined) {
        console.log("This demo requires a browser, such as Google Chrome or Firefox, that supports the Page Visibility API.");
      } else {
        // Handle page visibility change   
        document.addEventListener(visibilityChange, () => {
          if (document[hidden]) {
            this.window_hidden = true
          } else {
            this.window_hidden = false
          }
        }, false);

      }
    },
    attach_window_size_change_handler() {
      let chat_box_width = 280
      let gap_right = 15
      let container = document.querySelector('.bpc-chat-windows-list')
      window.addEventListener('resize', (event) => {
        let containerWidth = container.offsetWidth
        let w = containerWidth - chat_box_width - gap_right
        let maw = Math.floor(w/chat_box_width)
        
        this.max_active_window = maw > 0 ? maw : 1

        if(window.innerWidth <= 768) {
          if(window.innerWidth <= 720) {
            this.active_users_list = 'popped'
            this.attach_chat_buddies_window_scroll_handler()
          }
          else {
            this.active_users_list = 'default'
            this.attach_chat_buddies_window_scroll_handler()
          }
        }else{
          this.active_users_list = 'dash'
          this.attach_chat_buddies_window_scroll_handler()
        }
        
        let active_windows = this.chat_windows.filter(cw => cw.active)
        if(active_windows.length < this.max_active_window ) {
          
          let inactive_windows = this.chat_windows.filter(w => w.active == false)
          if(inactive_windows.length > 0) {
            inactive_windows.slice(0, this.max_active_window - active_windows.length).map(cw => {
              cw.active = true
            })

            this.updateChatWindows()
          }
        }else if(active_windows.length > this.max_active_window) {
          active_windows.slice(0, active_windows.length - this.max_active_window).map(cw => {
            cw.active = false
          })
          this.updateChatWindows()
        }
      })
    },
    attach_chat_buddies_window_scroll_handler() {
      this.$nextTick(() => {
        document.getElementsByClassName('buddy-chat-buddies__content')[0].onscroll = (event) => {
          if(this.current_tab == 'all-members' &&
            (this.buddies.userCount > (this.buddies.currentUserPage * parseInt(bpc_data.perpage))) &&
            ((event.srcElement.scrollHeight - event.srcElement.scrollTop) == event.srcElement.clientHeight)) {
            this.buddies.currentUserPage += 1
            this.fetchUsers(true)
          }
          else if(this.current_tab == 'friends' &&
            (this.buddies.friendCount > (this.buddies.currentFriendPage * parseInt(bpc_data.perpage))) &&
            ((event.srcElement.scrollHeight - event.srcElement.scrollTop) == event.srcElement.clientHeight)) {
            this.buddies.currentFriendPage += 1
            this.fetchFriends(true)
          }
        }
      })
    }
  },
  async mounted(){
  	try{
      let res = await fetch(bpc_data.chat_buddies_url)
      let data = await res.json();
      this.buddies.users = data.users.users
      this.buddies.userCount = data.users.count
      this.buddies.friends = data.friends.friends
      this.buddies.friendCount = data.friends.count
      this.buddies.groups = data.groups

      this.eventSource = new EventSource(bpc_data.event_source_url)
      this.eventSource.onmessage = this.on_new_message.bind(this)

      this.fetch_online_users()
      
      this.notification_sound = new Audio(bpc_data.notification_sound_url);
      
      this.attach_window_size_change_handler()
      this.attach_chat_buddies_window_scroll_handler()
      // trigger resize event
      window.dispatchEvent(new Event('resize'))
  	}catch(e) {
  		console.error(e)
  	}
  },
  created() {
    this.attach_window_visibility_change_handler()
  },
  beforeDestroy() {
    if(this.online_users_timer) clearTimeout(this.online_users_timer)
  }
})

function getCaretPosition(editableDiv) {
  var caretPos = 0,
    sel, range;
  if (window.getSelection) {
    sel = window.getSelection();
    if (sel.rangeCount) {
      range = sel.getRangeAt(0);
      //console.log('range.commonAncestorContainer.parentNode', range.commonAncestorContainer.parentNode)
      if ((range.commonAncestorContainer.parentNode == editableDiv)
        || (range.commonAncestorContainer.parentNode == editableDiv.parentNode)) {
        let childNodes = editableDiv.childNodes
        for(let i=0; i < childNodes.length; i++) {
          if(childNodes[i] == sel.anchorNode) {
            caretPos += sel.anchorOffset
            break
          }
          caretPos += childNodes[i].length || 1
        }
      }
    }
  } else if (document.selection && document.selection.createRange) {
    range = document.selection.createRange();
    if (range.parentElement() == editableDiv) {
      var tempEl = document.createElement("span");
      editableDiv.insertBefore(tempEl, editableDiv.firstChild);
      var tempRange = range.duplicate();
      tempRange.moveToElementText(tempEl);
      tempRange.setEndPoint("EndToEnd", range);
      caretPos = tempRange.text.length;
    }
  }
  return caretPos;
}