/**
 * External Links Controller for WordPress. Exclusively on Envato Market: http://codecanyon.net/user/42theme/portfolio?ref=42Theme
 * @encoding     UTF-8
 * @version      1.0.3
 * @copyright    Copyright (C) 2020 42Theme ( https://42theme.com ). All rights reserved.
 * @license      Envato License https://codecanyon.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy ( ak@42theme.com )
 * @support      support@42theme.com
 **/

( function ( $ ) {

    "use strict";

    // noinspection JSDeprecatedSymbols
    /** Run as soon as the page DOM becomes safe to manipulate. */
    $( document ).ready(function() {

        /** Show messages if we have some. */
        ShowAdminMessages();

        /** "noopener" or "noreferrer", only one */
        $( '.t42-junction-noopener' ).on( 'change', function() {

            if ( this.checked ) {
                $( '.t42-junction-noreferrer' ).prop( 'checked', false );
            }

        } );

        $( '.t42-junction-noreferrer' ).on( 'change', function() {

            if ( this.checked ) {
                $( '.t42-junction-noopener' ).prop( 'checked', false );
            }

        } );

        /** "nofollow" or "dofollow", only one */
        $( '.t42-junction-nofollow' ).on( 'change', function() {

            if ( this.checked ) {
                $( '.t42-junction-dofollow' ).prop( 'checked', false );
            }

        } );

        $( '.t42-junction-dofollow' ).on( 'change', function() {

            if ( this.checked ) {
                $( '.t42-junction-nofollow' ).prop( 'checked', false );
            }

        } );

        /**
         * Show popup with admin messages.
         **/
        function ShowAdminMessages() {

            let messages;

            /** If there is no data from backend. */
            // noinspection JSUnresolvedVariable
            if ( typeof window.t42Junction === 'undefined' ) {
                return;
            }

            /** If there is no messages. */
            // noinspection JSUnresolvedVariable
            if ( ! window.t42Junction.hasOwnProperty( 'messages' ) ) {
                return;
            }

            // noinspection JSUnresolvedVariable
            /** Get messages. */
            messages = window.t42Junction.messages;

            /** Show each message with their params. */
            messages.forEach( function( message ) {
                // noinspection JSUnresolvedVariable, JSHint
                iziToast.show( {
                    title: message.title,
                    message: message.message,
                    icon: message.icon,
                    color: message.color,
                    timeout: message.timeout,
                } );
            } ); // END messages.forEach
        } // END ShowAdminMessages

        /** Open activation tab. */
        $( '.t42-activation-status .t42-activate-btn' ).on( 'click', function () {
            UIkit2t42.switcher( 'ul.t42-tab' ).show( 2 );
        } );


    } ); // END $( document ).ready();

    /**
     * Set current tab from sessionStorage value.
     **/
    function SetCurrentTab() {
        /** Get tab index from sessionStorage. */
        let t42JunctionSelectedTab = sessionStorage.getItem( 't42JunctionSelectedTab' );

        /** Or select first tab. */
        if ( ! t42JunctionSelectedTab ) {
            t42JunctionSelectedTab = 0;
        }

        /** Select previous tab. */
        UIkit2t42.switcher( 'ul.t42-tab' ).show( t42JunctionSelectedTab ); // jshint ignore:line

        /** Scroll to  previously stored position. */
        setTimeout( SetScrollPosition, 500 );

    }

    /**
     * Set scroll position from sessionStorage value.
     **/
    function SetScrollPosition() {

        /** Get scroll position from sessionStorage. */
        let t42JunctionScrollTop = sessionStorage.getItem( 't42JunctionScrollTop' );

        /** Or set to top. */
        if ( ! t42JunctionScrollTop ) {
            t42JunctionScrollTop = 0;
        }

        /** Scroll to previous position. */
        $('.t42-settings-content').scrollTop( t42JunctionScrollTop );

    }

    /**
     * Remember selected tab in sessionStorage.
     **/
    function RememberCurrentTab() {
        /** Get current selected tab. */
        let t42JunctionSelectedTab = $( 'ul.t42-tab li.t42-active' ).index();

        /** Save value in sessionStorage. */
        window.sessionStorage.setItem( 't42JunctionSelectedTab', t42JunctionSelectedTab );
    }

    /**
     * Remember current scroll position in sessionStorage.
     **/
    function RememberScrollPosition() {
        /** Get current scroll position. */
        let t42JunctionScrollTop = jQuery('.t42-settings-content').scrollTop();

        /** Save value in sessionStorage. */
        window.sessionStorage.setItem( 't42JunctionScrollTop', t42JunctionScrollTop );
    }

    /** Set previously stored tab. */
    $( window ).on('load', function () {

        /** Select previously stored tab. */
        SetCurrentTab();

        /** Remember selected tab on every tab change. */
        $( 'ul.t42-tab' ).on( 'show.uk.switcher', RememberCurrentTab );

        /** Remember scroll position on every scroll change. */
        $( '.t42-settings-content' ).on( 'scroll', RememberScrollPosition );

    } );

} ( jQuery ) );